/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.config;

import com.mactso.hbm.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolManager {
    public static Hashtable<String, toolItem> toolHashtable = new Hashtable();
    private static String defaultToolString = "hbm:default";
    private static int defaultToolDimensionID = 0;
    private static String defaultToolKey = defaultToolString + ":" + defaultToolDimensionID;

    public static toolItem getToolInfo(String key, int dimensionID) {
        toolItem t;
        String iKey = key + ":" + dimensionID;
        if (toolHashtable.isEmpty()) {
            ToolManager.toolInit();
        }
        if ((t = toolHashtable.get(iKey)) == null && (t = toolHashtable.get(iKey = key + ":0")) == null) {
            t = toolHashtable.get(defaultToolKey);
        }
        return t;
    }

    public static void toolInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        int i = 0;
        String toolLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultTools6464, ";");
        while (st6464.hasMoreElements()) {
            toolLine6464 = st6464.nextToken().trim();
            if (toolLine6464.isEmpty()) continue;
            dTL6464.add(toolLine6464);
            ++i;
        }
        MyConfig.defaultTools = dTL6464.toArray(new String[i]);
        toolHashtable.clear();
        for (i = 0; i < MyConfig.defaultTools.length; ++i) {
            try {
                double tExhaustionAmt;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultTools[i], ",");
                String modAndTool = st.nextToken();
                String key = modAndTool + ":" + st.nextToken();
                double tExhaustionY = Double.parseDouble(st.nextToken());
                if (tExhaustionY < 5.0 || tExhaustionY > 255.0) {
                    tExhaustionY = 48.0;
                }
                if ((tExhaustionAmt = Double.parseDouble(st.nextToken())) < 0.0 || tExhaustionAmt > 40.0) {
                    tExhaustionAmt = 0.0;
                }
                toolHashtable.put(key, new toolItem(tExhaustionY, tExhaustionAmt));
                if (modAndTool.contentEquals("hbm:default") || ForgeRegistries.ITEMS.containsKey(new ResourceLocation(modAndTool))) continue;
                System.out.println("HarderBranchMining: Tool: " + modAndTool + " not in Forge Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("HarderBranchMining: Bad Tool Config : " + MyConfig.defaultTools[i]);
            }
        }
        if (ToolManager.getToolInfo(defaultToolString, defaultToolDimensionID) == null) {
            double tExhaustionY = 48.0;
            double tExhaustionAmt = 10.0;
            toolHashtable.put(defaultToolKey, new toolItem(tExhaustionY, tExhaustionAmt));
        }
    }

    public static class toolItem {
        double toolExhaustionY;
        double toolExhaustionAmount;

        public toolItem(double toolExhaustionY, double toolExhaustionAmount) {
            this.toolExhaustionY = toolExhaustionY;
            this.toolExhaustionAmount = toolExhaustionAmount;
        }

        public double getExhaustionY() {
            return this.toolExhaustionY;
        }

        public double getExhaustionAmt() {
            return this.toolExhaustionAmount;
        }
    }
}

