/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.event;

import com.mactso.hbm.config.MyConfig;
import com.mactso.hbm.config.ToolManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.OreBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlockBreakHandler {
    private static final int EXHAUSTION_FIXED = 0;
    private static final int EXHAUSTION_DEPTH = 1;
    private static int debugLimiter = 0;

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        double depthBasedExhaustionFactor = 0.0;
        double tempExhaustionAmount = 0.0;
        PlayerEntity p = event.getPlayer();
        Item item = p.func_184614_ca().func_77973_b();
        if (1.0f >= event.getState().func_185887_b((IBlockReader)event.getWorld(), event.getPos())) {
            if (MyConfig.aDebugLevel > 1) {
                StringTextComponent component = new StringTextComponent("Block Broken! Soft Block.  No Exhaustion.");
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                p.func_145747_a((ITextComponent)component);
            }
            return;
        }
        Block block = event.getState().func_177230_c();
        if (block instanceof OreBlock && MyConfig.aNormalOre) {
            return;
        }
        World w = (World)event.getWorld();
        ItemStack tempItemStack = event.getPlayer().func_184614_ca();
        Item tempItem = event.getPlayer().func_184614_ca().func_77973_b();
        ToolManager.toolItem toolInfo = ToolManager.getToolInfo(tempItem.getRegistryName().toString(), p.field_71093_bK.func_186068_a());
        depthBasedExhaustionFactor = toolInfo.getExhaustionY() - (double)event.getPos().func_177956_o();
        if (depthBasedExhaustionFactor < 0.0) {
            return;
        }
        depthBasedExhaustionFactor = MyConfig.aExhaustionType == 1 ? (depthBasedExhaustionFactor /= toolInfo.getExhaustionY()) : 1.0;
        tempExhaustionAmount = toolInfo.getExhaustionAmt() * depthBasedExhaustionFactor;
        event.getPlayer().func_71024_bL().func_75113_a((float)tempExhaustionAmount);
        if (MyConfig.aDebugLevel > 0) {
            System.out.println("Block Broken! Player:" + p.func_200200_C_() + ", Dimension" + p.field_71093_bK + ", Pos:" + event.getPos() + ", tempExhaustionAmount:" + tempExhaustionAmount);
            if (MyConfig.aDebugLevel > 1) {
                StringTextComponent component = new StringTextComponent("Block Broken! With " + tempItem.getRegistryName().toString() + " by Player:" + p.func_200200_C_().func_150254_d() + ", Dim#:" + p.field_71093_bK.func_186068_a() + ", Depth:" + event.getPos().func_177956_o() + ", Exhaustion:" + (double)Math.round(tempExhaustionAmount * 1000.0) / 1000.0);
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                p.func_145747_a((ITextComponent)component);
            }
        }
    }

    @SubscribeEvent
    public void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        float baseDestroySpeed;
        Item playerItem;
        double depthBasedSpeedFactor = 0.0;
        String worldName = "server-local ";
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        PlayerEntity p = event.getPlayer();
        if (p.field_70170_p.func_201670_d()) {
            worldName = "client-remote ";
        }
        if (!(playerItem = p.func_184614_ca().func_77973_b()).canHarvestBlock(p.func_184614_ca(), event.getState())) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (block instanceof OreBlock && MyConfig.aNormalOre) {
            return;
        }
        Item item = p.func_184614_ca().func_77973_b();
        if (p.func_184614_ca().func_190926_b()) {
            BlockState s = event.getState();
            double hardness = s.func_185887_b((IBlockReader)p.field_70170_p, event.getPos());
            Block b = event.getState().func_177230_c();
            if (hardness <= 1.0) {
                return;
            }
        }
        ToolManager.toolItem toolInfo = ToolManager.getToolInfo(playerItem.getRegistryName().toString(), p.field_71093_bK.func_186068_a());
        if ((double)event.getPos().func_177956_o() > toolInfo.getExhaustionY()) {
            return;
        }
        depthBasedSpeedFactor = 1.0 - (double)event.getPos().func_177956_o() / toolInfo.getExhaustionY();
        BlockState s = event.getState();
        float newDestroySpeed = baseDestroySpeed = event.getOriginalSpeed();
        if (MyConfig.aDigSpeedModifier > 1.0) {
            newDestroySpeed = baseDestroySpeed - baseDestroySpeed * (float)depthBasedSpeedFactor;
            newDestroySpeed /= (float)MyConfig.aDigSpeedModifier;
            if (event.getPos().func_177956_o() < p.func_180425_c().func_177956_o()) {
                newDestroySpeed /= (float)MyConfig.aDownSpeedModifier;
            }
        }
        if (newDestroySpeed > 0.0f) {
            event.setNewSpeed(newDestroySpeed);
        }
        if (MyConfig.aDebugLevel > 0 && debugLimiter++ > 2) {
            System.out.println("dbgL:" + MyConfig.aDebugLevel + " exT:" + MyConfig.aExhaustionType + " DSM:" + MyConfig.aDigSpeedModifier);
            System.out.println("Block Speed ! depthSpeedFactor:" + depthBasedSpeedFactor * 100.0 + "%");
            System.out.println("Block Speed ! Configured digSpeedModifer:" + MyConfig.aDigSpeedModifier * 100.0 + "%");
            System.out.println("Block Speed ! Original Speed: " + baseDestroySpeed + " newSpeedSet:" + event.getNewSpeed() + " DigSpeedMod:" + MyConfig.aDigSpeedModifier + ".");
            if (MyConfig.aDebugLevel > 1 && p.field_70170_p.func_201670_d()) {
                StringTextComponent component = new StringTextComponent(worldName + " Block Speed ! Original Speed: " + baseDestroySpeed + " newSpeedSet:" + event.getNewSpeed() + ". DigSpeedMod:" + MyConfig.aDigSpeedModifier + ".");
                p.func_145747_a((ITextComponent)component);
            }
            debugLimiter = 0;
        }
    }
}

