/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DieselHandler {
    static HashMap<String, Integer> dieselGenBurnTime = new HashMap();
    static Set<Fluid> drillFuel = new HashSet<Fluid>();
    public static ArrayList<RefineryRecipe> refineryList = new ArrayList();

    public static void registerFuel(Fluid fuel, int time) {
        if (fuel != null) {
            dieselGenBurnTime.put(fuel.getName(), time);
        }
    }

    public static int getBurnTime(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.get(fuel.getName());
        }
        return 0;
    }

    public static boolean isValidFuel(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.containsKey(fuel.getName());
        }
        return false;
    }

    public static HashMap<String, Integer> getFuelValues() {
        return dieselGenBurnTime;
    }

    public static Map<String, Integer> getFuelValuesSorted(boolean inverse) {
        return ApiUtils.sortMap(dieselGenBurnTime, inverse);
    }

    public static void registerDrillFuel(Fluid fuel) {
        if (fuel != null) {
            drillFuel.add(fuel);
        }
    }

    public static boolean isValidDrillFuel(Fluid fuel) {
        return fuel != null && drillFuel.contains(fuel);
    }

    public static void addRefineryRecipe(FluidStack input0, FluidStack input1, FluidStack output) {
        refineryList.add(new RefineryRecipe(input0, input1, output));
    }

    public static RefineryRecipe findIncompleteRefineryRecipe(FluidStack input0, FluidStack input1) {
        if (input0 == null && input1 == null) {
            return null;
        }
        for (RefineryRecipe recipe : refineryList) {
            if (!(input0 != null && input1 == null ? input0.isFluidEqual(recipe.input0) || input0.isFluidEqual(recipe.input1) : (input0 == null && input1 != null ? input1.isFluidEqual(recipe.input0) || input1.isFluidEqual(recipe.input1) : input0.isFluidEqual(recipe.input0) && input1.isFluidEqual(recipe.input1) || input0.isFluidEqual(recipe.input1) && input1.isFluidEqual(recipe.input0)))) continue;
            return recipe;
        }
        return null;
    }

    public static RefineryRecipe findRefineryRecipe(FluidStack input0, FluidStack input1) {
        if (input0 == null || input1 == null) {
            return null;
        }
        for (RefineryRecipe recipe : refineryList) {
            if ((!input0.isFluidEqual(recipe.input0) || !input1.isFluidEqual(recipe.input1)) && (!input0.isFluidEqual(recipe.input1) || !input1.isFluidEqual(recipe.input0))) continue;
            return recipe;
        }
        return null;
    }

    public static class RefineryRecipe {
        public final FluidStack input0;
        public final FluidStack input1;
        public final FluidStack output;

        public RefineryRecipe(FluidStack input0, FluidStack input1, FluidStack output) {
            this.input0 = input0;
            this.input1 = input1;
            this.output = output;
        }
    }
}

