/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;

public class ShaderCaseChemthrower
extends ShaderCase {
    public String additionalTexture = null;
    public int glowLayer = -1;
    public boolean renderCageOnBase = true;
    public boolean tanksUncoloured = true;
    public TextureAtlasSprite i_chemthrowerBase;
    public TextureAtlasSprite i_chemthrowerOverlay;
    public TextureAtlasSprite i_chemthrowerUncoloured;
    public TextureAtlasSprite i_chemthrowerAdditional;

    public ShaderCaseChemthrower(String overlayType, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, boolean cageOnBase, boolean tanksUncoloured, String additionalTexture) {
        super(overlayType, colourGrip, colourPrimary, colourSecondary, "immersiveengineering:items/shaders/chemthrower_");
        this.additionalTexture = additionalTexture;
        this.renderCageOnBase = cageOnBase;
        this.tanksUncoloured = tanksUncoloured;
    }

    @Override
    public String getShaderType() {
        return "chemthrower";
    }

    @Override
    public int getPasses(ItemStack shader, ItemStack item, String modelPart) {
        int i;
        int n = i = this.additionalTexture != null ? 1 : 0;
        if (modelPart.equals("cage")) {
            return (this.renderCageOnBase ? 2 : 1) + i;
        }
        if (modelPart.equals("base")) {
            return 3 + i;
        }
        if (modelPart.equals("tanks")) {
            return (this.tanksUncoloured ? 1 : 2) + i;
        }
        return 2 + i;
    }

    @Override
    public TextureAtlasSprite getReplacementSprite(ItemStack shader, ItemStack item, String modelPart, int pass) {
        boolean hasUncoloured;
        int maxPass = this.getPasses(shader, item, modelPart);
        boolean bl = hasUncoloured = modelPart.equals("base") || this.tanksUncoloured && modelPart.equals("tanks");
        if (pass == maxPass - 1 && hasUncoloured) {
            return this.i_chemthrowerUncoloured;
        }
        if (pass == maxPass - (hasUncoloured ? 2 : 1) && this.i_chemthrowerAdditional != null) {
            return this.i_chemthrowerAdditional;
        }
        if (modelPart.equals("cage")) {
            return pass == 0 && this.renderCageOnBase ? this.i_chemthrowerBase : this.i_chemthrowerOverlay;
        }
        return pass == 0 ? this.i_chemthrowerBase : this.i_chemthrowerOverlay;
    }

    @Override
    public int[] getRGBAColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        boolean hasUncoloured;
        int maxPass = this.getPasses(shader, item, modelPart);
        boolean bl = hasUncoloured = modelPart.equals("base") || this.tanksUncoloured && modelPart.equals("tanks");
        if (pass == maxPass - 1 && hasUncoloured) {
            return defaultWhite;
        }
        if (pass == maxPass - (hasUncoloured ? 2 : 1) && this.i_chemthrowerAdditional != null) {
            return this.colourOverlay;
        }
        int i = this.getTextureType(modelPart, pass);
        if (i == 0) {
            return this.colourUnderlying;
        }
        if (i == 1) {
            return this.colourPrimary;
        }
        if (i == 2) {
            return this.colourSecondary;
        }
        return defaultWhite;
    }

    public int getTextureType(String modelPart, int pass) {
        if (modelPart.equals("grip")) {
            return pass == 0 ? 0 : pass + 1;
        }
        return pass + 1;
    }

    @Override
    public void stichTextures(TextureMap map, int sheetID) {
        this.i_chemthrowerBase = ApiUtils.getRegisterSprite(map, "immersiveengineering:items/shaders/chemthrower_0");
        this.i_chemthrowerOverlay = ApiUtils.getRegisterSprite(map, this.baseTexturePath + "1_" + this.overlayType);
        this.i_chemthrowerUncoloured = ApiUtils.getRegisterSprite(map, "immersiveengineering:items/shaders/chemthrower_uncoloured");
        if (this.additionalTexture != null) {
            this.i_chemthrowerAdditional = ApiUtils.getRegisterSprite(map, this.baseTexturePath + this.additionalTexture);
        }
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre, boolean inventory) {
    }
}

