/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import blusunrize.immersiveengineering.client.models.ModelCoresample;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ImmersiveModelRegistry {
    public static ImmersiveModelRegistry instance = new ImmersiveModelRegistry();
    private static final ImmutableMap<String, String> flipData = ImmutableMap.of((Object)"flip-v", (Object)String.valueOf(true));
    private HashMap<ModelResourceLocation, ItemModelReplacement> itemModelReplacements = new HashMap();

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, ItemModelReplacement> entry : this.itemModelReplacements.entrySet()) {
            Object object = event.modelRegistry.func_82594_a((Object)entry.getKey());
            if (!(object instanceof IBakedModel)) continue;
            try {
                IBakedModel existingModel = (IBakedModel)object;
                event.modelRegistry.func_82595_a((Object)entry.getKey(), (Object)this.createBakedObjItemModel(existingModel, entry.getValue(), (IModelState)new OBJModel.OBJState((List)Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"}), true), DefaultVertexFormats.field_176599_b));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ModelResourceLocation mLoc = new ModelResourceLocation(new ResourceLocation("immersiveengineering", IEContent.itemCoresample.itemName), "inventory");
        event.modelRegistry.func_82595_a((Object)mLoc, (Object)new ModelCoresample());
    }

    public void registerCustomItemModel(ItemStack stack, ItemModelReplacement replacement) {
        if (stack.func_77973_b() instanceof ItemIEBase) {
            ResourceLocation loc = ((ItemIEBase)stack.func_77973_b()).getSubNames() != null && ((ItemIEBase)stack.func_77973_b()).getSubNames().length > 0 ? new ResourceLocation("immersiveengineering", ((ItemIEBase)stack.func_77973_b()).itemName + "/" + ((ItemIEBase)stack.func_77973_b()).getSubNames()[stack.func_77952_i()]) : new ResourceLocation("immersiveengineering", ((ItemIEBase)stack.func_77973_b()).itemName);
            this.itemModelReplacements.put(new ModelResourceLocation(loc, "inventory"), replacement);
        }
    }

    public OBJModel.OBJBakedModel createBakedObjItemModel(IBakedModel existingModel, ItemModelReplacement replacement, IModelState state, VertexFormat format) {
        try {
            Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(ResourceLocation location) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
            };
            ResourceLocation modelLocation = new ResourceLocation(replacement.objPath);
            OBJModel objModel = (OBJModel)OBJLoader.instance.loadModel(modelLocation);
            objModel = (OBJModel)objModel.process(flipData);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ModelLoader.White.loc.toString(), (Object)ModelLoader.White.instance);
            TextureAtlasSprite missing = (TextureAtlasSprite)textureGetter.apply((Object)new ResourceLocation("missingno"));
            for (String s : objModel.getMatLib().getMaterialNames()) {
                if (objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation().func_110623_a().startsWith("#")) {
                    FMLLog.severe((String)"OBJLoader: Unresolved texture '%s' for obj model '%s'", (Object[])new Object[]{objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation().func_110623_a(), modelLocation});
                    builder.put((Object)s, (Object)missing);
                    continue;
                }
                builder.put((Object)s, textureGetter.apply((Object)objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation()));
            }
            builder.put((Object)"missingno", (Object)missing);
            return replacement.createBakedModel(existingModel, objModel, state, format, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ItemModelReplacement {
        String objPath;
        HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap = new HashMap();

        public ItemModelReplacement(String path) {
            this.objPath = path;
            for (ItemCameraTransforms.TransformType t : ItemCameraTransforms.TransformType.values()) {
                this.transformationMap.put(t, new Matrix4());
            }
        }

        public ItemModelReplacement setTransformations(ItemCameraTransforms.TransformType type, Matrix4 matrix) {
            this.transformationMap.put(type, matrix);
            return this;
        }

        public OBJModel.OBJBakedModel createBakedModel(IBakedModel existingModel, OBJModel objModel, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures) {
            return new IESmartObjModel(existingModel, objModel, state, format, textures, this.transformationMap);
        }
    }
}

