/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.entities.EntityGrapplingHook;
import blusunrize.immersiveengineering.common.entities.EntityPropertiesShaderCart;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemManeuverGear;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ManeuverGearHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.TileEntityRequest;
import blusunrize.immersiveengineering.common.util.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandler {
    public static ArrayList<IEBlockInterfaces.ISpawnInterdiction> interdictionTiles = new ArrayList();
    public static boolean validateConnsNextTick = false;
    public static HashSet<IEExplosion> currentExplosions = new HashSet();
    public static Set<TileEntityRequest> ccRequestedTEs = Collections.newSetFromMap(new ConcurrentHashMap());
    public static Set<TileEntityRequest> cachedRequestResults = Collections.newSetFromMap(new ConcurrentHashMap());
    public static HashMap<UUID, TileEntityCrusher> crusherMap = new HashMap();
    public static HashSet<Class<? extends EntityLiving>> listOfBoringBosses = new HashSet();

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (ImmersiveNetHandler.INSTANCE == null) {
            ImmersiveNetHandler.INSTANCE = new ImmersiveNetHandler();
        }
        ImmersiveEngineering.proxy.onWorldLoad();
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityMinecart) {
            for (Class<? extends EntityMinecart> invalid : ShaderCaseMinecart.invalidMinecartClasses) {
                if (!invalid.isAssignableFrom(event.entity.getClass())) continue;
                return;
            }
            event.entity.registerExtendedProperties("IEShaderCart", (IExtendedEntityProperties)new EntityPropertiesShaderCart());
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinWorldEvent event) {
        if (event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityMinecart && event.entity.getExtendedProperties("IEShaderCart") != null) {
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageMinecartShaderSync(event.entity, null));
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPropertiesShaderCart properties;
        if (event.target instanceof EntityLivingBase && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemRevolver, 1, Short.MAX_VALUE), (ItemStack)event.entityPlayer.func_71045_bC(), (boolean)false)) {
            event.setCanceled(true);
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.target instanceof EntityMinecart && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() instanceof IShaderItem && (properties = (EntityPropertiesShaderCart)event.target.getExtendedProperties("IEShaderCart")) != null) {
            properties.setShader(Utils.copyStackWithAmount(event.entityPlayer.func_71045_bC(), 1));
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageMinecartShaderSync(event.target, properties), (EntityPlayerMP)event.entityPlayer);
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && validateConnsNextTick && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            boolean validateConnections = Config.getBoolean("validateConnections");
            int invalidConnectionsDropped = 0;
            for (int dim : ImmersiveNetHandler.INSTANCE.getRelevantDimensions()) {
                WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
                if (world == null) {
                    ImmersiveNetHandler.INSTANCE.directConnections.remove(dim);
                    continue;
                }
                if (!validateConnections) continue;
                for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                    if (world.func_175625_s(con.start) instanceof IImmersiveConnectable && world.func_175625_s(con.end) instanceof IImmersiveConnectable) continue;
                    ImmersiveNetHandler.INSTANCE.removeConnection((World)world, con);
                    ++invalidConnectionsDropped;
                }
                IELogger.info("removed " + invalidConnectionsDropped + " invalid connections from world");
            }
            int invalidProxies = 0;
            HashSet<DimensionBlockPos> toRemove = new HashSet<DimensionBlockPos>();
            for (Map.Entry<DimensionBlockPos, IICProxy> e : ImmersiveNetHandler.INSTANCE.proxies.entrySet()) {
                DimensionBlockPos p = e.getKey();
                WorldServer w = MinecraftServer.func_71276_C().func_71218_a(p.dimension);
                if (w != null && w.func_175667_e((BlockPos)p)) {
                    toRemove.add(p);
                }
                if (validateConnections && w == null) {
                    ++invalidProxies;
                    toRemove.add(p);
                    continue;
                }
                if (!validateConnections || w.func_175625_s((BlockPos)p) instanceof IImmersiveConnectable) continue;
                ++invalidProxies;
                toRemove.add(p);
            }
            if (invalidProxies > 0) {
                IELogger.info("Removed " + invalidProxies + " invalid connector proxies (used to transfer power through unloaded chunks)");
            }
            validateConnsNextTick = false;
        }
        if (event.phase == TickEvent.Phase.END && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (Map.Entry<ImmersiveNetHandler.Connection, Integer> e : ImmersiveNetHandler.INSTANCE.getTransferedRates(event.world.field_73011_w.func_177502_q()).entrySet()) {
                if (e.getValue() <= e.getKey().cableType.getTransferRate()) continue;
                if (event.world instanceof WorldServer) {
                    for (Vec3 vec : e.getKey().getSubVertices(event.world)) {
                        ((WorldServer)event.world).func_180505_a(EnumParticleTypes.FLAME, false, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0, 0.0, 0.02, 0.0, 1.0, new int[0]);
                    }
                }
                ImmersiveNetHandler.INSTANCE.removeConnection(event.world, e.getKey());
            }
            ImmersiveNetHandler.INSTANCE.getTransferedRates(event.world.field_73011_w.func_177502_q()).clear();
            Iterator<TileEntityRequest> it = cachedRequestResults.iterator();
            while (it.hasNext()) {
                TileEntityRequest req = it.next();
                if (!ccRequestedTEs.contains(req)) {
                    it.remove();
                    continue;
                }
                req.te = req.w.func_175625_s(req.pos);
            }
            it = ccRequestedTEs.iterator();
            for (int timeout = 100; it.hasNext() && timeout > 0; --timeout) {
                TileEntityRequest req;
                TileEntityRequest tileEntityRequest = req = it.next();
                synchronized (tileEntityRequest) {
                    req.te = req.w.func_175625_s(req.pos);
                    req.checked = true;
                    req.notifyAll();
                }
                it.remove();
                cachedRequestResults.add(req);
            }
        }
        if (event.phase == TickEvent.Phase.START && !currentExplosions.isEmpty()) {
            Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
            while (itExplosion.hasNext()) {
                IEExplosion ex = itExplosion.next();
                ex.doExplosionTick();
                if (!ex.isExplosionFinished) continue;
                itExplosion.remove();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (ManeuverGearHelper.isPlayerWearing3DMG(event.player)) {
            EntityGrapplingHook[] hooks = ManeuverGearHelper.getHooks(event.player);
            Vec3 newMotion = new Vec3(0.0, 0.0, 0.0);
            int vec = 0;
            for (int i = 0; i < 2; ++i) {
                if (hooks[i] == null || hooks[i].getHookMode() != ManeuverGearHelper.HookMode.REELING) continue;
                double speed = hooks[i].getHookSpeed();
                Vec3 hookMotion = new Vec3((hooks[i].field_70165_t - event.player.field_70165_t) * speed, (hooks[i].field_70163_u - (event.player.field_70163_u + (double)(event.player.field_70131_O / 2.0f))) * speed, (hooks[i].field_70161_v - event.player.field_70161_v) * speed).func_72432_b();
                newMotion = newMotion.func_178787_e(hookMotion);
                ++vec;
            }
            if (vec > 0) {
                event.player.field_70159_w = newMotion.field_72450_a / (double)vec;
                event.player.field_70181_x = newMotion.field_72448_b / (double)vec;
                event.player.field_70179_y = newMotion.field_72449_c / (double)vec;
                event.player.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            HashMap<ExcavatorHandler.MineralMix, Integer> packetMap = new HashMap<ExcavatorHandler.MineralMix, Integer>();
            for (Map.Entry<ExcavatorHandler.MineralMix, Integer> e : ExcavatorHandler.mineralList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMineralListSync(packetMap));
        }
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        MovingObjectPosition mop;
        if (event.block instanceof BlockIEBase && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b().getToolClasses(event.entityPlayer.func_71045_bC()).contains("IE_HAMMER") && (mop = Utils.getMovingObjectPositionFromPlayer(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, true)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && ((BlockIEBase)event.block).allowHammerHarvest(event.entityPlayer.field_70170_p.func_180495_p(mop.func_178782_a()))) {
            event.success = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        TileEntityCrusher crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.source.func_76355_l()) && (crusher = crusherMap.get(event.entityLiving.func_110124_au())) != null) {
            for (EntityItem item : event.drops) {
                if (item == null || item.func_92059_d() == null) continue;
                crusher.doProcessOutput(item.func_92059_d());
            }
            crusherMap.remove(event.entityLiving.func_110124_au());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && event.entityLiving instanceof IBossDisplayData) {
            EnumRarity r = EnumRarity.EPIC;
            for (Class<? extends EntityLiving> boring : listOfBoringBosses) {
                if (!boring.isAssignableFrom(event.entityLiving.getClass())) continue;
                r = EnumRarity.RARE;
                break;
            }
            ItemStack bag = new ItemStack((Item)IEContent.itemShaderBag);
            ItemNBTHelper.setString(bag, "rarity", r.toString());
            event.drops.add(new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, bag));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        float gas;
        int reduce;
        ItemStack gear;
        float mod;
        int amp;
        if (event.source.func_76347_k() && event.entityLiving.func_70660_b(IEPotions.flammable) != null) {
            amp = event.entityLiving.func_70660_b(IEPotions.flammable).func_76458_c();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.ammount *= mod;
        }
        if (event.source.func_76355_l().equals("flux") && event.entityLiving.func_70660_b(IEPotions.conductive) != null) {
            amp = event.entityLiving.func_70660_b(IEPotions.conductive).func_76458_c();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.ammount *= mod;
        }
        if (event.entityLiving instanceof EntityPlayer && event.source == DamageSource.field_76379_h && ManeuverGearHelper.isPlayerWearing3DMG((EntityPlayer)event.entityLiving) && (gear = ManeuverGearHelper.getPlayer3DMG((EntityPlayer)event.entityLiving)) != null && (reduce = (int)Math.min((double)event.ammount, Math.floor((double)(gas = ItemNBTHelper.getFloat(gear, "gas")) / ItemManeuverGear.jumpCost))) > 0) {
            event.ammount -= (float)reduce;
            gas = (float)((double)gas - (double)reduce * ItemManeuverGear.jumpCost);
            ItemNBTHelper.setFloat(gear, "gas", gas);
            ItemNBTHelper.setInt(gear, "cooldown", ItemManeuverGear.rechargeCooldown);
            ManeuverGearHelper.updatePlayer3DMG((EntityPlayer)event.entityLiving, gear);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving.func_70660_b(IEPotions.sticky) != null) {
            event.entityLiving.field_70181_x -= (double)((float)(event.entityLiving.func_70660_b(IEPotions.sticky).func_76458_c() + 1) * 0.3f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.entityLiving.isCreatureType(EnumCreatureType.MONSTER, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).func_145831_w().field_73011_w.func_177502_q() != event.entity.field_70170_p.field_73011_w.func_177502_q() || !(((TileEntity)interdictor).func_145835_a(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setCanceled(true);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).field_70170_p.field_73011_w.func_177502_q() != event.entity.field_70170_p.field_73011_w.func_177502_q() || !(((Entity)interdictor).func_70068_e(event.entity) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setCanceled(true);
                }
            }
        }
        if (event.entityLiving.func_70660_b(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.entityLiving.isCreatureType(EnumCreatureType.MONSTER, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).func_145831_w().field_73011_w.func_177502_q() != event.entity.field_70170_p.field_73011_w.func_177502_q() || !(((TileEntity)interdictor).func_145835_a(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).field_70170_p.field_73011_w.func_177502_q() != event.entity.field_70170_p.field_73011_w.func_177502_q() || !(((Entity)interdictor).func_70068_e(event.entity) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null) {
            block0: for (IEAchievements.AchievementIE achievement : IEAchievements.normalCraftingAchievements) {
                if (achievement.triggerItems != null && achievement.triggerItems.length > 0) {
                    for (ItemStack trigger : achievement.triggerItems) {
                        if (!OreDictionary.itemMatches((ItemStack)trigger, (ItemStack)event.crafting, (boolean)true)) continue;
                        event.player.func_71029_a((StatBase)achievement);
                        continue block0;
                    }
                    continue;
                }
                if (!OreDictionary.itemMatches((ItemStack)achievement.field_75990_d, (ItemStack)event.crafting, (boolean)true)) continue;
                event.player.func_71029_a((StatBase)achievement);
            }
        }
        if (event.crafting != null && ItemNBTHelper.hasKey(event.crafting, "jerrycanFilling")) {
            int drain = ItemNBTHelper.getInt(event.crafting, "jerrycanFilling");
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stackInSlot = event.craftMatrix.func_70301_a(i);
                if (stackInSlot == null || !((Object)((Object)IEContent.itemJerrycan)).equals(stackInSlot.func_77973_b()) || !ItemNBTHelper.hasKey(stackInSlot, "fluid")) continue;
                ItemNBTHelper.setInt(stackInSlot, "jerrycanDrain", drain);
                break;
            }
            ItemNBTHelper.remove(event.crafting, "jerrycanFilling");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.player != null && !event.isCanceled()) {
            block0: for (IEAchievements.AchievementIE achievement : IEAchievements.placementAchievements) {
                if (achievement.triggerItems != null && achievement.triggerItems.length > 0) {
                    for (ItemStack trigger : achievement.triggerItems) {
                        if (!OreDictionary.itemMatches((ItemStack)trigger, (ItemStack)event.itemInHand, (boolean)true)) continue;
                        event.player.func_71029_a((StatBase)achievement);
                        continue block0;
                    }
                    continue;
                }
                if (!OreDictionary.itemMatches((ItemStack)achievement.field_75990_d, (ItemStack)event.itemInHand, (boolean)true)) continue;
                event.player.func_71029_a((StatBase)achievement);
            }
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack current = event.entityPlayer.func_71045_bC();
        if (current != null && current.func_77973_b().equals((Object)IEContent.itemDrill) && current.func_77952_i() == 0 && event.entityPlayer.func_70055_a(Material.field_151586_h)) {
            if (((ItemDrill)IEContent.itemDrill).getUpgrades(current).func_74767_n("waterproof")) {
                event.newSpeed *= 5.0f;
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (event.left != null && event.left.func_77973_b() instanceof IDrillHead && ((IDrillHead)event.left.func_77973_b()).getHeadDamage(event.left) > 0 && event.right != null && event.left.func_77973_b().func_82789_a(event.left, event.right)) {
            int cost;
            event.output = event.left.func_77946_l();
            int repair = Math.min(((IDrillHead)event.output.func_77973_b()).getHeadDamage(event.output), ((IDrillHead)event.output.func_77973_b()).getMaximumHeadDamage(event.output) / 4);
            for (cost = 0; repair > 0 && cost < event.right.field_77994_a; ++cost) {
                ((IDrillHead)event.output.func_77973_b()).damageHead(event.output, -repair);
                event.cost += Math.max(1, repair / 200);
                repair = Math.min(((IDrillHead)event.output.func_77973_b()).getHeadDamage(event.output), ((IDrillHead)event.output.func_77973_b()).getMaximumHeadDamage(event.output) / 4);
            }
            event.materialCost = cost;
            if (event.name == null || event.name.isEmpty()) {
                if (event.left.func_82837_s()) {
                    event.cost += 5;
                    event.output.func_135074_t();
                }
            } else if (!event.name.equals(event.left.func_82833_r())) {
                event.cost += 5;
                if (event.left.func_82837_s()) {
                    event.cost += 2;
                }
                event.output.func_151001_c(event.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TileEntity requestTE(World w, BlockPos pos) {
        TileEntityRequest req = new TileEntityRequest(w, pos);
        TileEntity te = null;
        for (TileEntityRequest curr : cachedRequestResults) {
            if (!req.equals(curr)) continue;
            te = curr.te;
        }
        if (te != null) {
            return te;
        }
        TileEntityRequest tileEntityRequest = req;
        synchronized (tileEntityRequest) {
            ccRequestedTEs.add(req);
            for (int timeout = 100; !req.checked && timeout > 0; --timeout) {
                if (!ccRequestedTEs.contains(req)) {
                    ccRequestedTEs.add(req);
                }
                try {
                    req.wait(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!req.checked) {
                IELogger.info("Timeout while requesting a TileEntity");
                return w.func_175625_s(pos);
            }
        }
        return req.te;
    }

    static {
        listOfBoringBosses.add(EntityWither.class);
    }
}

