/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemBlockIEBase
extends ItemBlock {
    public ItemBlockIEBase(Block b) {
        super(b);
        if (((BlockIEBase)b).enumValues.length > 1) {
            this.func_77627_a(true);
        }
    }

    public int func_77647_b(int damageValue) {
        return damageValue;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        this.field_150939_a.func_149666_a(item, tab, itemList);
    }

    public String func_77667_c(ItemStack stack) {
        String subName = ((BlockIEBase)this.field_150939_a).func_176203_a(stack.func_77952_i()).func_177229_b(((BlockIEBase)this.field_150939_a).property).toString().toLowerCase(Locale.US);
        return super.func_77667_c(stack) + "." + subName;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advInfo) {
        FluidStack fs;
        if (((BlockIEBase)this.field_150939_a).hasFlavour(stack)) {
            String subName = ((BlockIEBase)this.field_150939_a).func_176203_a(stack.func_77952_i()).func_177229_b(((BlockIEBase)this.field_150939_a).property).toString().toLowerCase(Locale.US);
            String flavourKey = "desc.ImmersiveEngineering.flavour." + ((BlockIEBase)this.field_150939_a).name + "." + subName;
            list.add(EnumChatFormatting.GRAY.toString() + StatCollector.func_74838_a((String)flavourKey));
        }
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{ItemNBTHelper.getInt(stack, "energyStorage")}));
        }
        if (ItemNBTHelper.hasKey(stack, "tank") && (fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemNBTHelper.getTagCompound(stack, "tank"))) != null) {
            list.add(fs.getLocalizedName() + ": " + fs.amount + "mB");
        }
        super.func_77624_a(stack, player, list, advInfo);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!((BlockIEBase)this.field_150939_a).canIEBlockBePlaced(world, pos, newState, side, hitX, hitY, hitZ, player, stack)) {
            return false;
        }
        boolean ret = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (ret) {
            ((BlockIEBase)this.field_150939_a).onIEBlockPlacedBy(world, pos, newState, side, hitX, hitY, hitZ, (EntityLivingBase)player, stack);
        }
        return ret;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f(world, pos)) {
            pos = pos.func_177972_a(side);
            iblockstate = world.func_180495_p(pos);
            block = iblockstate.func_177230_c();
        }
        if (stack.field_77994_a > 0 && playerIn.func_175151_a(pos, side, stack)) {
            int i;
            IBlockState iblockstate1;
            if (!world.field_72995_K && this.canBlockBePlaced(world, pos, side, stack) && this.placeBlockAt(stack, playerIn, world, pos, side, hitX, hitY, hitZ, iblockstate1 = this.field_150939_a.func_180642_a(world, pos, side, hitX, hitY, hitZ, i = this.func_77647_b(stack.func_77960_j()), (EntityLivingBase)playerIn))) {
                world.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f(worldIn, pos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f(worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return this.canBlockBePlaced(worldIn, pos, side, stack);
    }

    private boolean canBlockBePlaced(World w, BlockPos pos, EnumFacing side, ItemStack stack) {
        BlockIEBase blockIn = (BlockIEBase)this.field_150939_a;
        Block block = w.func_180495_p(pos).func_177230_c();
        AxisAlignedBB axisalignedbb = blockIn.func_180640_a(w, pos, blockIn.func_176203_a(stack.func_77952_i()));
        if (axisalignedbb != null && !w.func_72917_a(axisalignedbb, null)) {
            return false;
        }
        return block.func_176200_f(w, pos) && blockIn.func_176193_a(w, pos, side, stack);
    }
}

