/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Conveyor;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorVertical;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConveyor
extends BlockIETileProvider<BlockTypes_Conveyor> {
    public BlockConveyor() {
        super("conveyor", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_Conveyor.class), ItemBlockIEBase.class, new Object[]{IEProperties.FACING_ALL, IEProperties.CONVEYORWALLS[0], IEProperties.CONVEYORWALLS[1], IEProperties.CONVEYORUPDOWN, IEProperties.BOOLEANS[0]});
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.field_149786_r = 0;
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityConveyorBelt && !(tile instanceof TileEntityConveyorVertical)) {
            for (int i = 0; i < IEProperties.CONVEYORWALLS.length; ++i) {
                state = state.func_177226_a((IProperty)IEProperties.CONVEYORWALLS[i], (Comparable)Boolean.valueOf(((TileEntityConveyorBelt)tile).renderWall(i)));
            }
            state = state.func_177226_a((IProperty)IEProperties.CONVEYORUPDOWN, (Comparable)Integer.valueOf(((TileEntityConveyorBelt)tile).transportUp ? 1 : (((TileEntityConveyorBelt)tile).transportDown ? 2 : 0)));
        }
        return state;
    }

    @Override
    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        super.onIEBlockPlacedBy(world, pos, state, side, hitX, hitY, hitZ, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityConveyorBelt && !(tile instanceof TileEntityConveyorVertical)) {
            TileEntityConveyorBelt conveyer = (TileEntityConveyorBelt)tile;
            EnumFacing f = conveyer.facing;
            tile = world.func_175625_s(pos.func_177972_a(f).func_177982_a(0, 1, 0));
            if (tile instanceof TileEntityConveyorBelt && !(tile instanceof TileEntityConveyorVertical) && ((TileEntityConveyorBelt)tile).facing != f.func_176734_d()) {
                conveyer.transportUp = true;
            }
            if ((tile = world.func_175625_s(pos.func_177972_a(f.func_176734_d()).func_177982_a(0, 1, 0))) instanceof TileEntityConveyorBelt && !(tile instanceof TileEntityConveyorVertical) && ((TileEntityConveyorBelt)tile).facing == f) {
                conveyer.transportDown = true;
            }
            if (conveyer.transportUp && conveyer.transportDown) {
                conveyer.transportDown = false;
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityConveyorVertical) {
            return side == ((TileEntityConveyorVertical)te).facing;
        }
        if (te instanceof TileEntityConveyorBelt) {
            return side == EnumFacing.DOWN && !((TileEntityConveyorBelt)te).transportUp && !((TileEntityConveyorBelt)te).transportDown;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (BlockTypes_Conveyor.values()[meta]) {
            case CONVEYOR: {
                return new TileEntityConveyorBelt();
            }
            case CONVEYOR_DROPPER: {
                return new TileEntityConveyorBelt(true);
            }
            case CONVEYOR_VERTICAL: {
                return new TileEntityConveyorVertical();
            }
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState blockState) {
        return true;
    }

    @Override
    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("IE_HAMMER") || super.isToolEffective(type, state);
    }
}

