/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityAssembler
extends TileEntityMultiblockMetal<TileEntityAssembler, IMultiblockRecipe>
implements IFluidHandler,
IEBlockInterfaces.IGuiTile {
    public boolean[] computerOn = new boolean[3];
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public ItemStack[] inventory = new ItemStack[21];
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    IItemHandler insertionHandler = new IEInventoryHandler(18, (IIEInventory)this, 0, true, false);
    IItemHandler extractionHandler = new IEInventoryHandler(3, (IIEInventory)this, 18, false, true);

    public TileEntityAssembler() {
        super(MultiblockAssembler.instance, new int[]{3, 3, 3}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 21);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = nbt.func_150295_c("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = new NBTTagList();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.func_74782_a("pattern" + iPattern, (NBTBase)patternList);
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xF)) {
            return;
        }
        boolean update = false;
        ItemStack[][] outputBuffer = new ItemStack[this.patterns.length][0];
        for (int p = 0; p < this.patterns.length; ++p) {
            CrafterPatternInventory pattern = this.patterns[p];
            if (!this.computerOn[p] || pattern.inv[9] == null || !this.canOutput(pattern.inv[9], p)) continue;
            ItemStack output = pattern.inv[9].func_77946_l();
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
            ItemStack[][] itemStackArray = outputBuffer;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[] itemStackArray2;
                for (ItemStack stack : itemStackArray2 = itemStackArray[i]) {
                    if (stack == null) continue;
                    queryList.add(stack.func_77946_l());
                }
            }
            for (ItemStack[] itemStackArray3 : this.inventory) {
                if (itemStackArray3 == null) continue;
                queryList.add(itemStackArray3.func_77946_l());
            }
            int consumed = Config.getInt("assembler_consumption");
            if (!this.hasIngredients(pattern, queryList) || this.energyStorage.extractEnergy(consumed, true) != consumed) continue;
            this.energyStorage.extractEnergy(consumed, false);
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(output);
            Object[] oreInputs = null;
            ArrayList arrayList = new ArrayList();
            if (pattern.recipe instanceof ShapedOreRecipe || pattern.recipe instanceof ShapelessOreRecipe) {
                oreInputs = pattern.recipe instanceof ShapedOreRecipe ? ((ShapedOreRecipe)pattern.recipe).getInput() : ((ShapelessOreRecipe)pattern.recipe).getInput().toArray();
            }
            for (int i = 0; i < 9; ++i) {
                if (pattern.inv[i] == null) continue;
                Object query = pattern.inv[i].func_77946_l();
                int querySize = pattern.inv[i].field_77994_a;
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]) != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]);
                    fs.amount *= querySize;
                    boolean hasFluid = false;
                    for (FluidTank tank : this.tanks) {
                        if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                        hasFluid = true;
                        break;
                    }
                    if (hasFluid) {
                        query = fs;
                    }
                }
                if (query instanceof ItemStack && oreInputs != null) {
                    for (int iOre = 0; iOre < oreInputs.length; ++iOre) {
                        if (arrayList.contains(iOre) || !Utils.stackMatchesObject(query, oreInputs[iOre], true)) continue;
                        query = oreInputs[iOre];
                        querySize = 1;
                        break;
                    }
                }
                boolean taken = false;
                for (int j = 0; j < outputBuffer.length && !(taken = this.consumeItem(query, querySize, outputBuffer[j], outputList)); ++j) {
                }
                if (taken) continue;
                this.consumeItem(query, querySize, this.inventory, outputList);
            }
            outputBuffer[p] = outputList.toArray(new ItemStack[outputList.size()]);
            update = true;
        }
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, 2));
        block8: for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].length <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].length; ++iOutput) {
                ItemStack output = outputBuffer[buffer][iOutput];
                if (output == null || output.field_77994_a <= 0 || !this.isRecipeIngredient(output, buffer) && inventoryTile != null && ((output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d())) == null || output.field_77994_a <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (this.inventory[18 + buffer] == null && free < 0) {
                        free = 18 + buffer;
                    } else if (this.inventory[18 + buffer] != null && OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[18 + buffer], (boolean)true) && this.inventory[18 + buffer].field_77994_a + output.field_77994_a <= this.inventory[18 + buffer].func_77976_d()) {
                        this.inventory[18 + buffer].field_77994_a += output.field_77994_a;
                        free = -1;
                        continue block8;
                    }
                } else {
                    for (int i = 0; i < this.inventory.length; ++i) {
                        if (this.inventory[i] == null && free < 0) {
                            free = i;
                            continue;
                        }
                        if (this.inventory[i] == null || !OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[i], (boolean)true) || this.inventory[i].field_77994_a + output.field_77994_a > this.inventory[i].func_77976_d()) continue;
                        this.inventory[i].field_77994_a += output.field_77994_a;
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory[free] = output.func_77946_l();
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient(this.inventory[18 + i], i) || inventoryTile == null) continue;
            this.inventory[18 + i] = Utils.insertStackIntoInventory(inventoryTile, this.inventory[18 + i], this.facing.func_176734_d());
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    public boolean consumeItem(Object query, int querySize, ItemStack[] inventory, ArrayList<ItemStack> containerItems) {
        if (query instanceof FluidStack) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().containsFluid((FluidStack)query)) continue;
                tank.drain(((FluidStack)query).amount, true);
                this.func_70296_d();
                this.field_145850_b.func_175689_h(this.func_174877_v());
                return true;
            }
        }
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !Utils.stackMatchesObject(inventory[i], query, true)) continue;
            int taken = Math.min(querySize, inventory[i].field_77994_a);
            boolean doTake = true;
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inventory[i]);
            if (container != null) {
                if (inventory[i].field_77994_a - taken <= 0) {
                    inventory[i] = container;
                    doTake = false;
                } else {
                    containerItems.add(container.func_77946_l());
                }
            }
            if (doTake) {
                inventory[i].field_77994_a -= taken;
                if (inventory[i].field_77994_a <= 0) {
                    inventory[i] = null;
                }
            }
            if ((querySize -= taken) <= 0) break;
        }
        return query == null || querySize <= 0;
    }

    public boolean hasIngredients(CrafterPatternInventory pattern, ArrayList<ItemStack> queryList) {
        Object[] oreInputs = null;
        ArrayList usedOreSlots = new ArrayList();
        if (pattern.recipe instanceof ShapedOreRecipe || pattern.recipe instanceof ShapelessOreRecipe) {
            oreInputs = pattern.recipe instanceof ShapedOreRecipe ? ((ShapedOreRecipe)pattern.recipe).getInput() : ((ShapelessOreRecipe)pattern.recipe).getInput().toArray();
        }
        boolean match = true;
        for (int i = 0; i < 9; ++i) {
            if (pattern.inv[i] == null) continue;
            if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]) != null) {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]);
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (hasFluid) continue;
            }
            Object query = pattern.inv[i].func_77946_l();
            int querySize = pattern.inv[i].field_77994_a;
            if (oreInputs != null) {
                for (int iOre = 0; iOre < oreInputs.length; ++iOre) {
                    if (usedOreSlots.contains(iOre) || !Utils.stackMatchesObject(query, oreInputs[iOre], true)) continue;
                    query = oreInputs[iOre];
                    querySize = 1;
                    break;
                }
            }
            Iterator<ItemStack> it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!Utils.stackMatchesObject(next, query, true)) continue;
                int taken = Math.min(querySize, next.field_77994_a);
                next.field_77994_a -= taken;
                if (next.field_77994_a <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            match = false;
            break;
        }
        return match;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (this.inventory[18 + iPattern] == null) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[18 + iPattern], (boolean)true) && ItemStack.func_77970_a((ItemStack)output, (ItemStack)this.inventory[18 + iPattern]) && this.inventory[18 + iPattern].field_77994_a + output.field_77994_a <= this.inventory[18 + iPattern].func_77976_d();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (slot - 1 < this.patterns.length) {
            for (int p = slot + 1; p < this.patterns.length; ++p) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (pattern.inv[i] == null || !OreDictionary.itemMatches((ItemStack)pattern.inv[i], (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c < 9 || this.field_174879_c == 10 || this.field_174879_c == 13 || this.field_174879_c == 16 || this.field_174879_c == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.SOUTH || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.NORTH) {
            zMin = 0.25f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.NORTH || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.SOUTH) {
            zMax = 0.75f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.EAST || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.WEST) {
            xMin = 0.25f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.WEST || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.EAST) {
            xMax = 0.75f;
        }
        if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.EAST || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.WEST) {
            zMin = 0.1875f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.WEST || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.EAST) {
            zMax = 0.8125f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.NORTH || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.SOUTH) {
            xMin = 0.1875f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.SOUTH || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.NORTH) {
            xMax = 0.8125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return null;
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{22};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{3, 5};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, -1);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (output != null) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public FluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.field_174879_c == 10 || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.field_174879_c == 10 && facing == this.facing.func_176734_d() || this.field_174879_c == 16 && facing == this.facing;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.field_174879_c == 10 || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityAssembler master = (TileEntityAssembler)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 10 && facing == this.facing.func_176734_d()) {
                return (T)master.insertionHandler;
            }
            if (this.field_174879_c == 16 && facing == this.facing) {
                return (T)master.extractionHandler;
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 5;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (!this.formed || resource == null) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        TileEntityAssembler master = (TileEntityAssembler)this.master();
        if (master == null) {
            return 0;
        }
        int fill = -1;
        for (FluidTank tank : master.tanks) {
            if (tank.getFluid() == null || !tank.getFluid().isFluidEqual(resource)) continue;
            fill = tank.fill(resource, doFill);
            break;
        }
        if (fill == -1) {
            FluidTank tank;
            FluidTank[] fluidTankArray = master.tanks;
            int n = fluidTankArray.length;
            for (int i = 0; i < n && (fill = (tank = fluidTankArray[i]).fill(resource, doFill)) <= 0; ++i) {
            }
        }
        if (fill > 0) {
            master.func_70296_d();
            this.field_145850_b.func_175689_h(master.func_174877_v());
        }
        return fill < 0 ? 0 : fill;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return resource == null ? null : this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.field_174879_c == 1 && (from == null || from == this.facing.func_176734_d());
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        TileEntityAssembler master;
        if (!(this.field_174879_c != 1 || from != null && from != this.facing.func_176734_d() || (master = (TileEntityAssembler)this.master()) == null || this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0)) {
            return new FluidTankInfo[]{master.tanks[0].getInfo(), master.tanks[1].getInfo(), master.tanks[2].getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public ItemStack[] inv = new ItemStack[10];
        public IRecipe recipe;
        final TileEntityAssembler tile;

        public CrafterPatternInventory(TileEntityAssembler tile) {
            this.tile = tile;
        }

        public int func_70302_i_() {
            return 10;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (slot < 9 && stack != null) {
                if (stack.field_77994_a <= amount) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amount);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv[slot] = stack;
                if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                    stack.field_77994_a = this.func_70297_j_();
                }
            }
            this.recalculateOutput();
        }

        public void func_174888_l() {
            for (int i = 0; i < this.inv.length; ++i) {
                this.inv[i] = null;
            }
        }

        public void recalculateOutput() {
            Utils.InventoryCraftingFalse invC = new Utils.InventoryCraftingFalse(3, 3);
            for (int j = 0; j < 9; ++j) {
                invC.func_70299_a(j, this.inv[j]);
            }
            this.recipe = Utils.findRecipe(invC, this.tile.func_145831_w());
            this.inv[9] = this.recipe != null ? this.recipe.func_77572_b((InventoryCrafting)invC) : null;
        }

        public ArrayList<ItemStack> getTotalPossibleOutputs() {
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(this.inv[9].func_77946_l());
            for (int i = 0; i < 9; ++i) {
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inv[i]) == null) continue;
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inv[i]);
                boolean hasFluid = false;
                for (FluidTank tank : this.tile.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (!hasFluid) continue;
            }
            Utils.InventoryCraftingFalse invC = new Utils.InventoryCraftingFalse(3, 3);
            for (int j = 0; j < 9; ++j) {
                invC.func_70299_a(j, this.inv[j]);
            }
            for (ItemStack ss : this.recipe.func_179532_b((InventoryCrafting)invC)) {
                if (ss == null) continue;
                outputList.add(ss);
            }
            return outputList;
        }

        public String func_70005_c_() {
            return "IECrafterPattern";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                this.inv[i].func_77955_b(itemTag);
                list.func_74742_a((NBTBase)itemTag);
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
            this.recalculateOutput();
        }

        public IChatComponent func_145748_c_() {
            return new ChatComponentText(this.func_70005_c_());
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }
    }
}

