/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityElectricLantern
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.ISpawnInterdiction,
ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.ILightValue {
    public int energyStorage = 0;
    public boolean active = false;
    private boolean interdictionList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.interdictionList && Config.getBoolean("lantern_spawnPrevent")) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
            synchronized (arrayList) {
                if (!EventHandler.interdictionTiles.contains(this)) {
                    EventHandler.interdictionTiles.add(this);
                }
            }
            this.interdictionList = true;
        }
        boolean b = this.active;
        if (this.energyStorage > 0) {
            --this.energyStorage;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
        }
        if (this.active != b) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, 0);
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.active ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145843_s() {
        ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
        synchronized (arrayList) {
            if (EventHandler.interdictionTiles.contains(this)) {
                EventHandler.interdictionTiles.remove(this);
            }
        }
        super.func_145843_s();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.func_74767_n("active");
        this.energyStorage = nbt.func_74762_e("energyStorage");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("energyStorage", this.energyStorage);
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    protected boolean isRelay() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < 10) {
            if (!simulate) {
                int rec = Math.min(10 - this.energyStorage, 2);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(10 - this.energyStorage, 2);
        }
        return 0;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = this.func_174877_v().func_177958_n() - ((TileEntity)link).func_174877_v().func_177958_n();
        int zDif = this.func_174877_v().func_177952_p() - ((TileEntity)link).func_174877_v().func_177952_p();
        if (xDif == 0 && zDif == 0) {
            return new Vec3(0.5, 0.0625, 0.5);
        }
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), 0.0625, 0.5);
        }
        return new Vec3(0.5, 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177958_n() - this.func_174877_v().func_177958_n() : (xDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177958_n() - this.func_174877_v().func_177958_n() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177952_p() - this.func_174877_v().func_177952_p() : (zDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177952_p() - this.func_174877_v().func_177952_p() : 0));
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), 0.0625, 0.5);
        }
        return new Vec3(0.5, 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return null;
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public int getLightValue() {
        return this.active ? 15 : 0;
    }
}

