/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockExcavator;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityExcavator
extends TileEntityMultiblockMetal<TileEntityExcavator, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds {
    public boolean active = false;

    public TileEntityExcavator() {
        super(MultiblockExcavator.instance, new int[]{3, 6, 3}, 64000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    @Override
    public void func_73660_a() {
        BlockPos wheelPos;
        TileEntity center;
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && (center = this.field_145850_b.func_175625_s(wheelPos = this.getBlockPosForPos(31))) instanceof TileEntityBucketWheel) {
            float rot = 0.0f;
            int target = -1;
            TileEntityBucketWheel wheel = (TileEntityBucketWheel)center;
            EnumFacing fRot = this.facing.func_176735_f();
            if (wheel.facing == fRot) {
                if (this.active != wheel.active) {
                    this.field_145850_b.func_175641_c(wheel.func_174877_v(), wheel.func_145838_q(), 0, this.active ? 1 : 0);
                }
                if ((rot = wheel.rotation) % 45.0f > 40.0f) {
                    target = Math.round(rot / 360.0f * 8.0f) % 8;
                }
            }
            if (wheel.facing != fRot || wheel.mirrored != this.mirrored) {
                for (int h = -3; h <= 3; ++h) {
                    for (int w = -3; w <= 3; ++w) {
                        TileEntity te = this.field_145850_b.func_175625_s(wheelPos.func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.X ? w : 0, h, this.facing.func_176740_k() == EnumFacing.Axis.Z ? w : 0));
                        if (!(te instanceof TileEntityBucketWheel)) continue;
                        ((TileEntityBucketWheel)te).facing = fRot;
                        ((TileEntityBucketWheel)te).mirrored = this.mirrored;
                        te.func_70296_d();
                        this.field_145850_b.func_175689_h(te.func_174877_v());
                    }
                }
            }
            if (!this.isRSDisabled()) {
                ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(this.field_145850_b, wheelPos.func_177958_n() >> 4, wheelPos.func_177952_p() >> 4);
                int consumed = Config.getInt("excavator_consumption");
                int extracted = this.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.active = true;
                    if (target >= 0 && target < 8) {
                        if (wheel.digStacks[(target + 4) % 8] == null) {
                            ItemStack blocking = this.digBlocksInTheWay(wheel);
                            BlockPos lowGroundPos = wheelPos.func_177982_a(0, -5, 0);
                            if (blocking != null) {
                                wheel.digStacks[(target + 4) % 8] = blocking;
                                wheel.func_70296_d();
                                this.field_145850_b.func_175689_h(wheelPos);
                            } else if (!(mineral == null || this.field_145850_b.func_175623_d(lowGroundPos.func_177967_a(this.facing, -2)) || this.field_145850_b.func_175623_d(lowGroundPos.func_177967_a(this.facing, 2)) || this.field_145850_b.func_175623_d(lowGroundPos.func_177967_a(this.facing, -1)) || this.field_145850_b.func_175623_d(lowGroundPos.func_177967_a(this.facing, 1)) || this.field_145850_b.func_175623_d(lowGroundPos))) {
                                ItemStack ore = mineral.getRandomOre(this.field_145850_b.field_73012_v);
                                float configChance = this.field_145850_b.field_73012_v.nextFloat();
                                float failChance = this.field_145850_b.field_73012_v.nextFloat();
                                if (ore != null && (double)configChance > Config.getDouble("excavator_chance") && failChance > mineral.failChance) {
                                    wheel.digStacks[(target + 4) % 8] = ore;
                                    wheel.func_70296_d();
                                    this.field_145850_b.func_175689_h(wheelPos);
                                }
                                ExcavatorHandler.depleteMinerals(this.field_145850_b, wheelPos.func_177958_n() >> 4, wheelPos.func_177952_p() >> 4);
                            }
                        }
                        if (wheel.digStacks[target] != null) {
                            this.doProcessOutput(wheel.digStacks[target].func_77946_l());
                            Block b = Block.func_149634_a((Item)wheel.digStacks[target].func_77973_b());
                            if (b != null && b != Blocks.field_150350_a) {
                                wheel.particleStack = wheel.digStacks[target].func_77946_l();
                            }
                            wheel.digStacks[target] = null;
                            wheel.func_70296_d();
                            this.field_145850_b.func_175689_h(wheelPos);
                        }
                    }
                }
            } else if (this.active) {
                this.active = false;
            }
        }
    }

    ItemStack digBlocksInTheWay(TileEntityBucketWheel wheel) {
        BlockPos pos = wheel.func_174877_v().func_177982_a(0, -4, 0);
        ItemStack s = this.digBlock(pos);
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, -1));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, -2));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, 1));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, 2));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, -1).func_177972_a(this.facing.func_176746_e()));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, -1).func_177972_a(this.facing.func_176735_f()));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177972_a(this.facing.func_176746_e()));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177972_a(this.facing.func_176735_f()));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, 1).func_177972_a(this.facing.func_176746_e()));
        if (s != null) {
            return s;
        }
        s = this.digBlock(pos.func_177967_a(this.facing, 1).func_177972_a(this.facing.func_176735_f()));
        if (s != null) {
            return s;
        }
        return null;
    }

    ItemStack digBlock(BlockPos pos) {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return null;
        }
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer((WorldServer)this.field_145850_b);
        IBlockState blockstate = this.field_145850_b.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (block != null && !this.field_145850_b.func_175623_d(pos) && block.func_180647_a((EntityPlayer)fakePlayer, this.field_145850_b, pos) != 0.0f) {
            if (!block.canHarvestBlock((IBlockAccess)this.field_145850_b, pos, (EntityPlayer)fakePlayer)) {
                return null;
            }
            block.func_176208_a(this.field_145850_b, pos, blockstate, (EntityPlayer)fakePlayer);
            if (block.removedByPlayer(this.field_145850_b, pos, (EntityPlayer)fakePlayer, true)) {
                block.func_176206_d(this.field_145850_b, pos, blockstate);
                if (block.canSilkHarvest(this.field_145850_b, pos, blockstate, (EntityPlayer)fakePlayer)) {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    Item bitem = Item.func_150898_a((Block)block);
                    if (bitem == null) {
                        return null;
                    }
                    ItemStack itemstack = new ItemStack(bitem, 1, block.func_176201_c(blockstate));
                    if (itemstack != null) {
                        items.add(itemstack);
                    }
                    ForgeEventFactory.fireBlockHarvesting(items, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)blockstate, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    for (int i = 0; i < items.size(); ++i) {
                        if (i == 0) continue;
                        EntityItem ei = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, ((ItemStack)items.get(i)).func_77946_l());
                        this.field_145850_b.func_72838_d((Entity)ei);
                    }
                    this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockstate));
                    if (items.size() > 0) {
                        return (ItemStack)items.get(0);
                    }
                } else {
                    block.func_180657_a(this.field_145850_b, (EntityPlayer)fakePlayer, pos, blockstate, this.field_145850_b.func_175625_s(pos));
                    this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockstate));
                }
            }
        }
        return null;
    }

    @Override
    public float[] getBlockBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c == 45) {
            return new float[]{fl == EnumFacing.EAST ? 0.5f : 0.0f, 0.0f, fl == EnumFacing.SOUTH ? 0.5f : 0.0f, fl == EnumFacing.WEST ? 0.5f : 1.0f, 0.5f, fl == EnumFacing.NORTH ? 0.5f : 1.0f};
        }
        if (this.field_174879_c == 48) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.field_174879_c == 51) {
            return new float[]{fl == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, fl == EnumFacing.NORTH ? 0.5f : 0.0f, fl == EnumFacing.EAST ? 0.5f : 1.0f, 0.5f, fl == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        if (this.field_174879_c == 47) {
            float[] fArray = new float[6];
            fArray[0] = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.375f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == EnumFacing.SOUTH ? 0.5f : (fArray[2] = fl == EnumFacing.NORTH ? 0.375f : 0.0f);
            fArray[3] = fl == EnumFacing.WEST ? 0.5f : (fl == EnumFacing.EAST ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c == 50) {
            return new float[]{fw == EnumFacing.EAST ? 0.875f : 0.0f, 0.0f, fw == EnumFacing.SOUTH ? 0.875f : 0.0f, fw == EnumFacing.WEST ? 0.125f : 1.0f, 1.0f, fw == EnumFacing.NORTH ? 0.125f : 1.0f};
        }
        if (this.field_174879_c == 53) {
            float[] fArray = new float[6];
            fArray[0] = fl == EnumFacing.WEST ? 0.5f : (fl == EnumFacing.EAST ? 0.375f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == EnumFacing.NORTH ? 0.5f : (fArray[2] = fl == EnumFacing.SOUTH ? 0.375f : 0.0f);
            fArray[3] = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.625f : 1.0f);
            fArray[4] = 1.0f;
            fArray[5] = fl == EnumFacing.SOUTH ? 0.5f : (fl == EnumFacing.NORTH ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c == 5 || this.field_174879_c == 23 || this.field_174879_c == 41) {
            return new float[]{fw == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.NORTH ? 0.5f : 0.0f, fw == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        if (this.field_174879_c == 9 || this.field_174879_c == 12 || this.field_174879_c == 15) {
            return new float[]{fw == EnumFacing.EAST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.SOUTH ? 0.5f : 0.0f, fw == EnumFacing.WEST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.NORTH ? 0.5f : 1.0f};
        }
        if (this.field_174879_c == 11 || this.field_174879_c == 14 || this.field_174879_c == 17) {
            return new float[]{fw == EnumFacing.WEST ? 0.5f : 0.0f, 0.0f, fw == EnumFacing.NORTH ? 0.5f : 0.0f, fw == EnumFacing.EAST ? 0.5f : 1.0f, 1.0f, fw == EnumFacing.SOUTH ? 0.5f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return null;
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c == 5 || this.field_174879_c == 23 || this.field_174879_c == 41) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{AxisAlignedBB.func_178781_a((double)(fw == EnumFacing.WEST ? 0.5 : 0.0), (double)0.0, (double)(fw == EnumFacing.NORTH ? 0.5 : 0.0), (double)(fw == EnumFacing.EAST ? 0.5 : 1.0), (double)1.0, (double)(fw == EnumFacing.SOUTH ? 0.5 : 1.0)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            list.add(AxisAlignedBB.func_178781_a((double)(fw == EnumFacing.EAST ? 0.5 : (fw == EnumFacing.WEST ? 0.0 : 0.25)), (double)0.25, (double)(fw == EnumFacing.SOUTH ? 0.5 : (fw == EnumFacing.NORTH ? 0.0 : 0.25)), (double)(fw == EnumFacing.WEST ? 0.5 : (fw == EnumFacing.EAST ? 1.0 : 0.75)), (double)0.75, (double)(fw == EnumFacing.NORTH ? 0.5 : (fw == EnumFacing.SOUTH ? 1.0 : 0.75))).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 9 || this.field_174879_c == 12 || this.field_174879_c == 15) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{AxisAlignedBB.func_178781_a((double)(fw == EnumFacing.EAST ? 0.5 : 0.0), (double)0.0, (double)(fw == EnumFacing.SOUTH ? 0.5 : 0.0), (double)(fw == EnumFacing.WEST ? 0.5 : 1.0), (double)1.0, (double)(fw == EnumFacing.NORTH ? 0.5 : 1.0)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c == 9) {
                list.add(AxisAlignedBB.func_178781_a((double)(fw == EnumFacing.WEST || fl == EnumFacing.EAST ? 0.5 : 0.0), (double)0.5, (double)(fw == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.5 : 0.0), (double)(fw == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.5 : 1.0), (double)1.0, (double)(fw == EnumFacing.SOUTH || fl == EnumFacing.NORTH ? 0.5 : 1.0)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            } else if (this.field_174879_c == 12) {
                list.add(AxisAlignedBB.func_178781_a((double)(fw == EnumFacing.WEST ? 0.5 : 0.0), (double)0.5, (double)(fw == EnumFacing.NORTH ? 0.5 : 0.0), (double)(fw == EnumFacing.EAST ? 0.5 : 1.0), (double)1.0, (double)(fw == EnumFacing.SOUTH ? 0.5 : 1.0)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            } else {
                list.add(AxisAlignedBB.func_178781_a((double)(fw == EnumFacing.WEST || fl == EnumFacing.WEST ? 0.5 : 0.0), (double)0.5, (double)(fw == EnumFacing.NORTH || fl == EnumFacing.NORTH ? 0.5 : 0.0), (double)(fw == EnumFacing.EAST || fl == EnumFacing.EAST ? 0.5 : 1.0), (double)1.0, (double)(fw == EnumFacing.SOUTH || fl == EnumFacing.SOUTH ? 0.5 : 1.0)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        if (this.field_174879_c == 47) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{AxisAlignedBB.func_178781_a((double)(fl == EnumFacing.EAST ? 0.5 : (fl == EnumFacing.WEST ? 0.375 : 0.0)), (double)0.0, (double)(fl == EnumFacing.SOUTH ? 0.5 : (fl == EnumFacing.NORTH ? 0.375 : 0.0)), (double)(fl == EnumFacing.WEST ? 0.5 : (fl == EnumFacing.EAST ? 0.625 : 1.0)), (double)1.0, (double)(fl == EnumFacing.NORTH ? 0.5 : (fl == EnumFacing.SOUTH ? 0.625 : 1.0))).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            list.add(AxisAlignedBB.func_178781_a((double)(fl == EnumFacing.EAST ? 0.625 : (fw == EnumFacing.EAST ? 0.875 : 0.0)), (double)0.0, (double)(fl == EnumFacing.SOUTH ? 0.625 : (fw == EnumFacing.SOUTH ? 0.875 : 0.0)), (double)(fl == EnumFacing.WEST ? 0.375 : (fw == EnumFacing.WEST ? 0.125 : 1.0)), (double)1.0, (double)(fl == EnumFacing.NORTH ? 0.375 : (fw == EnumFacing.NORTH ? 0.125 : 1.0))).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 53) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{AxisAlignedBB.func_178781_a((double)(fl == EnumFacing.WEST ? 0.5 : (fl == EnumFacing.EAST ? 0.375 : 0.0)), (double)0.0, (double)(fl == EnumFacing.NORTH ? 0.5 : (fl == EnumFacing.SOUTH ? 0.375 : 0.0)), (double)(fl == EnumFacing.EAST ? 0.5 : (fl == EnumFacing.WEST ? 0.625 : 1.0)), (double)1.0, (double)(fl == EnumFacing.SOUTH ? 0.5 : (fl == EnumFacing.NORTH ? 0.625 : 1.0))).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            list.add(AxisAlignedBB.func_178781_a((double)(fl == EnumFacing.WEST ? 0.625 : (fw == EnumFacing.EAST ? 0.875 : 0.0)), (double)0.0, (double)(fl == EnumFacing.NORTH ? 0.625 : (fw == EnumFacing.SOUTH ? 0.875 : 0.0)), (double)(fl == EnumFacing.EAST ? 0.375 : (fw == EnumFacing.WEST ? 0.125 : 1.0)), (double)1.0, (double)(fl == EnumFacing.SOUTH ? 0.375 : (fw == EnumFacing.NORTH ? 0.125 : 1.0))).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, MovingObjectPosition mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{5, 23, 41};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{18};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, -1);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (output != null) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public ItemStack[] getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public FluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }
}

