/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityFluidPipe
extends TileEntityIEBase
implements IFluidPipe,
IFluidHandler,
IEBlockInterfaces.IAdvancedHasObjProperty,
IEBlockInterfaces.IColouredTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds {
    static ConcurrentHashMap<BlockPos, Set<DirectionalFluidOutput>> indirectConnections = new ConcurrentHashMap();
    public static ArrayList<ItemStack> validScaffoldCoverings = new ArrayList();
    public int[] sideConfig = new int[]{0, 0, 0, 0, 0, 0};
    public ItemStack scaffoldCovering = null;
    static HashMap<String, OBJModel.OBJState> cachedOBJStates = new HashMap();
    static String[] CONNECTIONS = new String[]{"con_yMin", "con_yMax", "con_zMin", "con_zMax", "con_xMin", "con_xMax"};

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlers(BlockPos node, World world) {
        if (indirectConnections.containsKey(node)) {
            return indirectConnections.get(node);
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            if (world.func_175667_e(next)) {
                TileEntity te = world.func_175625_s(next);
                if (!closedList.contains(next) && te instanceof IFluidPipe) {
                    if (te instanceof TileEntityFluidPipe) {
                        closedList.add(next);
                    }
                    for (int i = 0; i < 6; ++i) {
                        FluidTankInfo[] tankInfo;
                        BlockPos nextPos;
                        EnumFacing fd = EnumFacing.func_82600_a((int)i);
                        if (!((IFluidPipe)te).hasOutputConnection(fd) || !world.func_175667_e(nextPos = next.func_177972_a(fd))) continue;
                        TileEntity te2 = world.func_175625_s(nextPos);
                        if (te2 instanceof TileEntityFluidPipe) {
                            openList.add(nextPos);
                            continue;
                        }
                        if (!(te2 instanceof IFluidHandler) || (tankInfo = ((IFluidHandler)te2).getTankInfo(fd.func_176734_d())) == null || tankInfo.length <= 0) continue;
                        IFluidHandler handler = (IFluidHandler)te2;
                        fluidHandlers.add(new DirectionalFluidOutput(handler, fd));
                    }
                }
            }
            openList.remove(0);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !indirectConnections.containsKey(node)) {
            indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            indirectConnections.get(node).addAll(fluidHandlers);
        }
        return fluidHandlers;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            indirectConnections.clear();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.scaffoldCovering = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("scaffold"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        if (this.scaffoldCovering != null) {
            nbt.func_74782_a("scaffold", (NBTBase)this.scaffoldCovering.func_77955_b(new NBTTagCompound()));
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int tileSpecificAcceptedFluid;
        int limit;
        if (resource == null || from == null || this.sideConfig[from.ordinal()] != 0 || this.field_145850_b.field_72995_K) {
            return 0;
        }
        int canAccept = resource.amount;
        if (canAccept <= 0) {
            return 0;
        }
        ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(TileEntityFluidPipe.getConnectedFluidHandlers(this.func_174877_v(), this.field_145850_b));
        if (outputList.size() < 1) {
            return 0;
        }
        BlockPos ccFrom = new BlockPos((Vec3i)this.func_174877_v().func_177972_a(from));
        int sum = 0;
        HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
        for (DirectionalFluidOutput output : outputList) {
            BlockPos cc = Utils.toCC(output.output);
            if (cc.equals((Object)ccFrom) || !this.field_145850_b.func_175667_e(cc) || !output.output.canFill(output.direction.func_176734_d(), resource.getFluid())) continue;
            limit = resource.tag != null && resource.tag.func_74764_b("pressurized") || this.canOutputPressurized(output.output, false) ? 1000 : 50;
            tileSpecificAcceptedFluid = Math.min(limit, canAccept);
            int temp = output.output.fill(output.direction.func_176734_d(), Utils.copyFluidStackWithAmount(resource, tileSpecificAcceptedFluid, true), false);
            if (temp <= 0) continue;
            sorting.put(output, temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            for (DirectionalFluidOutput output : sorting.keySet()) {
                limit = resource.tag != null && resource.tag.func_74764_b("pressurized") || this.canOutputPressurized(output.output, false) ? 1000 : 50;
                tileSpecificAcceptedFluid = Math.min(limit, canAccept);
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)tileSpecificAcceptedFluid * prio);
                int r = output.output.fill(output.direction.func_176734_d(), Utils.copyFluidStackWithAmount(resource, amount, true), doFill);
                if (r > 50) {
                    this.canOutputPressurized(output.output, true);
                }
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    boolean canOutputPressurized(IFluidHandler output, boolean consumePower) {
        if (output instanceof IFluidPipe) {
            return ((IFluidPipe)output).canOutputPressurized(consumePower);
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return from != null && this.sideConfig[from.ordinal()] == 0;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTank(1000).getInfo()};
    }

    public byte getConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            FluidTankInfo[] tankInfo;
            TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)i)));
            connections = (byte)(connections << 1);
            if (this.sideConfig[i] != 0 || !(con instanceof IFluidHandler) || (tankInfo = ((IFluidHandler)con).getTankInfo(EnumFacing.func_82600_a((int)i).func_176734_d())) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public byte getAvailableConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            FluidTankInfo[] tankInfo;
            TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)i)));
            connections = (byte)(connections << 1);
            if (!(con instanceof IFluidHandler) || (tankInfo = ((IFluidHandler)con).getTankInfo(EnumFacing.func_82600_a((int)i).func_176734_d())) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public int getConnectionStyle(int connection) {
        byte tileConnections;
        if (this.sideConfig[connection] == -1) {
            return 0;
        }
        byte thisConnections = this.getConnectionByte();
        if ((thisConnections & 1 << connection) == 0) {
            return 0;
        }
        if (thisConnections != 3 && thisConnections != 12 && thisConnections != 48) {
            return 1;
        }
        TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)connection)));
        if (con instanceof TileEntityFluidPipe && thisConnections == (tileConnections = ((TileEntityFluidPipe)con).getConnectionByte())) {
            return 0;
        }
        return 1;
    }

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 0) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        EnumFacing fd = EnumFacing.func_82600_a((int)side);
        TileEntity connected = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
        if (connected instanceof TileEntityFluidPipe) {
            ((TileEntityFluidPipe)connected).sideConfig[fd.func_176734_d().ordinal()] = this.sideConfig[side];
            connected.func_70296_d();
            this.field_145850_b.func_175641_c(this.func_174877_v().func_177972_a(fd), this.func_145838_q(), 0, 0);
        }
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return null;
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        ArrayList list = Lists.newArrayList();
        byte connections = this.getConnectionByte();
        if (connections == 48) {
            list.add(new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            if ((connections & 0x10) == 0) {
                list.add(new AxisAlignedBB(0.0, 0.125, 0.125, 0.125, 0.875, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            if ((connections & 0x20) == 0) {
                list.add(new AxisAlignedBB(0.875, 0.125, 0.125, 1.0, 0.875, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        } else if (connections == 12) {
            list.add(new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            if ((connections & 4) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            if ((connections & 8) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.125, 0.875, 0.875, 0.875, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        } else if (connections == 3) {
            list.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            if ((connections & 1) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            if ((connections & 2) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.875, 0.125, 0.875, 1.0, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        } else {
            list.add(new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            for (int i = 0; i < 6; ++i) {
                if ((connections & 1) == 1) {
                    list.add(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.125), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.125), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.125), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.875), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.875), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.875)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                }
                connections = (byte)(connections >> 1);
            }
        }
        return list;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        byte connections = this.getAvailableConnectionByte();
        byte availableConnections = this.getConnectionByte();
        if (this.scaffoldCovering != null) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (int i = 0; i < 6; ++i) {
            double size;
            double depth = this.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
            double d = size = this.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
            if ((connections & 1) == 1) {
                list.add(new AdvancedAABB(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 1.0 - depth : size), i == 0 ? 0.0 : (i == 1 ? 1.0 - depth : size), i == 2 ? 0.0 : (i == 3 ? 1.0 - depth : size), i == 4 ? depth : (i == 5 ? 1.0 : 1.0 - size), i == 0 ? depth : (i == 1 ? 1.0 : 1.0 - size), i == 2 ? depth : (i == 3 ? 1.0 : 1.0 - size)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), EnumFacing.func_82600_a((int)i)));
            }
            if ((availableConnections & 1) == 1) {
                int n = i;
                baseAABB[n] = baseAABB[n] + (i % 2 == 1 ? 0.125 : -0.125);
            }
            baseAABB[i] = Math.min(Math.max(baseAABB[i], 0.0), 1.0);
            availableConnections = (byte)(availableConnections >> 1);
            connections = (byte)(connections >> 1);
        }
        list.add(new AdvancedAABB(new AxisAlignedBB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), null));
        return list;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, MovingObjectPosition mop, ArrayList<AxisAlignedBB> list) {
        if (box instanceof AdvancedAABB && box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(mop.field_72307_f)) {
            AxisAlignedBB changedBox = ((AdvancedAABB)box).fd != null ? box.func_72314_b(((AdvancedAABB)box).fd.func_82601_c() != 0 ? 0.0 : 0.03125, ((AdvancedAABB)box).fd.func_96559_d() != 0 ? 0.0 : 0.03125, ((AdvancedAABB)box).fd.func_82599_e() != 0 ? 0.0 : 0.03125) : box;
            list.add(changedBox);
            return true;
        }
        return false;
    }

    @Override
    public OBJModel.OBJState getOBJState() {
        byte connections = this.getConnectionByte();
        String key = "";
        for (int i = 0; i < 6; ++i) {
            key = (connections & 1 << i) != 0 ? key + (this.getConnectionStyle(i) == 1 ? "2" : "1") : key + "0";
        }
        if (!cachedOBJStates.containsKey(key)) {
            ArrayList<String> parts = new ArrayList<String>();
            Matrix4 rotationMatrix = new Matrix4(TRSRTransformation.identity().getMatrix());
            int totalConnections = Integer.bitCount(connections);
            boolean straightY = (connections & 3) == 3;
            boolean straightZ = (connections & 0xC) == 12;
            boolean straightX = (connections & 0x30) == 48;
            switch (totalConnections) {
                case 0: {
                    parts.add("center");
                    break;
                }
                case 1: {
                    parts.add("stopper");
                    if ((connections & 2) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    } else if ((connections & 4) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 8) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    } else if ((connections & 0x20) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    }
                    parts.add("con_yMin");
                    break;
                }
                case 2: {
                    if (straightY) {
                        parts.add("pipe_y");
                        if (this.getConnectionStyle(0) == 1) {
                            parts.add("con_yMin");
                        }
                        if (this.getConnectionStyle(1) != 1) break;
                        parts.add("con_yMax");
                        break;
                    }
                    if (straightZ) {
                        parts.add("pipe_z");
                        if (this.getConnectionStyle(2) == 1) {
                            parts.add("con_zMin");
                        }
                        if (this.getConnectionStyle(3) != 1) break;
                        parts.add("con_zMax");
                        break;
                    }
                    if (straightX) {
                        parts.add("pipe_x");
                        if (this.getConnectionStyle(4) == 1) {
                            parts.add("con_xMin");
                        }
                        if (this.getConnectionStyle(5) != 1) break;
                        parts.add("con_xMax");
                        break;
                    }
                    parts.add("curve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    byte connectTo = (byte)(connections & 0x3C);
                    if ((connections & 3) != 0) {
                        if (connectTo == 16) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 32) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 8) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    if (connectTo == 40) {
                        rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo == 24) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo != 36) break;
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (straightX || straightZ || straightY) {
                        parts.add("tcross");
                        parts.add("con_yMin");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (straightX) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                            if ((connections & 4) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 2) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                            if ((connections & 0x10) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 0x20) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x20) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    parts.add("tcurve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_xMax");
                    if ((connections & 8) != 0) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        } else {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        }
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 4: {
                    boolean cross;
                    boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                    if (cross) {
                        parts.add("cross");
                        parts.add("con_yMin");
                        parts.add("con_yMax");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (!straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        break;
                    }
                    parts.add("tcross2");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        if ((connections & 8) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) == 0) break;
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 5: {
                    parts.add("tcross3");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if (straightY) {
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate((connections & 2) != 0 ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) == 0) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    break;
                }
            }
            Matrix4 tempMatr = new Matrix4();
            tempMatr.m23 = 0.5;
            tempMatr.m13 = 0.5;
            tempMatr.m03 = 0.5;
            rotationMatrix.leftMultiply(tempMatr);
            tempMatr.invert();
            rotationMatrix = rotationMatrix.multiply(tempMatr);
            cachedOBJStates.put(key, new OBJModel.OBJState(parts, true, (IModelState)new TRSRTransformation(rotationMatrix.toMatrix4f())));
        }
        return cachedOBJStates.get(key);
    }

    public static OBJModel.OBJState getStateFromKey(String key) {
        if (!cachedOBJStates.containsKey(key)) {
            ArrayList<String> parts = new ArrayList<String>();
            Matrix4 rotationMatrix = new Matrix4(TRSRTransformation.identity().getMatrix());
            byte connections = (byte)Integer.parseInt(key.replace("2", "1"), 2);
            int totalConnections = Integer.bitCount(connections);
            boolean straightY = (connections & 3) == 3;
            boolean straightZ = (connections & 0xC) == 12;
            boolean straightX = (connections & 0x30) == 48;
            switch (totalConnections) {
                case 0: {
                    parts.add("center");
                    break;
                }
                case 1: {
                    parts.add("stopper");
                    if ((connections & 2) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    } else if ((connections & 4) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 8) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    } else if ((connections & 0x20) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    }
                    parts.add("con_yMin");
                    break;
                }
                case 2: {
                    if (straightY) {
                        parts.add("pipe_y");
                        if (key.charAt(5) == '2') {
                            parts.add("con_yMin");
                        }
                        if (key.charAt(4) != '\u0001') break;
                        parts.add("con_yMax");
                        break;
                    }
                    if (straightZ) {
                        parts.add("pipe_z");
                        if (key.charAt(3) == '2') {
                            parts.add("con_zMin");
                        }
                        if (key.charAt(2) != '2') break;
                        parts.add("con_zMax");
                        break;
                    }
                    if (straightX) {
                        parts.add("pipe_x");
                        if (key.charAt(1) == '2') {
                            parts.add("con_xMin");
                        }
                        if (key.charAt(0) != '2') break;
                        parts.add("con_xMax");
                        break;
                    }
                    parts.add("curve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    byte connectTo = (byte)(connections & 0x3C);
                    if ((connections & 3) != 0) {
                        if (connectTo == 16) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 32) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 8) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    if (connectTo == 40) {
                        rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo == 24) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo != 36) break;
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (straightX || straightZ || straightY) {
                        parts.add("tcross");
                        parts.add("con_yMin");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (straightX) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                            if ((connections & 4) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 2) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                            if ((connections & 0x10) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 0x20) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x20) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    parts.add("tcurve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_xMax");
                    if ((connections & 8) != 0) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        } else {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        }
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 4: {
                    boolean cross;
                    boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                    if (cross) {
                        parts.add("cross");
                        parts.add("con_yMin");
                        parts.add("con_yMax");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (!straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        break;
                    }
                    parts.add("tcross2");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        if ((connections & 8) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) == 0) break;
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 5: {
                    parts.add("tcross3");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if (straightY) {
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate((connections & 2) != 0 ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) == 0) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    break;
                }
            }
            Matrix4 tempMatr = new Matrix4();
            tempMatr.m23 = 0.5;
            tempMatr.m13 = 0.5;
            tempMatr.m03 = 0.5;
            rotationMatrix.leftMultiply(tempMatr);
            tempMatr.invert();
            rotationMatrix = rotationMatrix.multiply(tempMatr);
            cachedOBJStates.put(key, new OBJModel.OBJState(parts, true, (IModelState)new TRSRTransformation(rotationMatrix.toMatrix4f())));
        }
        return cachedOBJStates.get(key);
    }

    @Override
    public int getRenderColour() {
        return 0xFF00FF;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        EnumFacing fd = null;
        List<AxisAlignedBB> boxes = this.getAdvancedSelectionBounds();
        for (AxisAlignedBB box : boxes) {
            if (!(box instanceof AdvancedAABB) || !box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(new Vec3((double)((float)this.func_174877_v().func_177958_n() + hitX), (double)((float)this.func_174877_v().func_177956_o() + hitY), (double)((float)this.func_174877_v().func_177952_p() + hitZ))) || !(box instanceof AdvancedAABB)) continue;
            fd = ((AdvancedAABB)box).fd;
        }
        if (fd != null) {
            this.toggleSide(fd.ordinal());
            this.field_145850_b.func_175689_h(this.func_174877_v());
            indirectConnections.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        return false;
    }

    @Override
    public boolean hasOutputConnection(EnumFacing side) {
        return side == null ? false : this.sideConfig[side.ordinal()] == 0;
    }

    public static class DirectionalFluidOutput {
        IFluidHandler output;
        EnumFacing direction;

        public DirectionalFluidOutput(IFluidHandler output, EnumFacing direction) {
            this.output = output;
            this.direction = direction;
        }
    }
}

