/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidPump
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IConfigurableSides,
IFluidHandler,
IFluidPipe,
IFluxReceiver,
IEnergyReceiver {
    public int[] sideConfig = new int[]{0, -1, -1, -1, -1, -1};
    public boolean dummy = false;
    public FluidTank tank = new FluidTank(4000);
    public EnergyStorage energyStorage = new EnergyStorage(8000);
    public boolean placeCobble = true;
    boolean checkingArea = false;
    Fluid searchFluid = null;
    ArrayList<BlockPos> openList = new ArrayList();
    ArrayList<BlockPos> closedList = new ArrayList();
    ArrayList<BlockPos> checked = new ArrayList();

    public void func_73660_a() {
        if (this.dummy || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            int i = this.outputFluid(this.tank.getFluid(), false);
            this.tank.drain(i, true);
        }
        if (this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 || this.field_145850_b.func_175687_A(this.func_174877_v().func_177982_a(0, 1, 0)) > 0) {
            for (EnumFacing f : EnumFacing.values()) {
                if (this.sideConfig[f.ordinal()] != 0) continue;
                TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
                if (tile instanceof IFluidHandler) {
                    FluidStack drain = ((IFluidHandler)tile).drain(f.func_176734_d(), 500, false);
                    if (drain == null || drain.amount <= 0 || !((IFluidHandler)tile).canDrain(f.func_176734_d(), drain.getFluid())) continue;
                    int out = this.outputFluid(drain, false);
                    ((IFluidHandler)tile).drain(f.func_176734_d(), out, true);
                    continue;
                }
                if (this.field_145850_b.func_82737_E() % 20L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x13) || this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(f)).func_177230_c() != Blocks.field_150355_j || !Config.getBoolean("pump_infiniteWater") || this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), false) != 1000 || this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), true) < Config.getInt("pump_consumption")) continue;
                int connectedSources = 0;
                for (EnumFacing f2 : EnumFacing.field_176754_o) {
                    IBlockState waterState = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(f).func_177972_a(f2));
                    if (waterState.func_177230_c() != Blocks.field_150355_j || Blocks.field_150355_j.func_176201_c(waterState) != 0) continue;
                    ++connectedSources;
                }
                if (connectedSources <= true) continue;
                this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), false);
                this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
            }
            if (this.field_145850_b.func_82737_E() % 40L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) % 40)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    BlockPos pos = this.closedList.get(target);
                    FluidStack fs = Utils.drainFluidBlock(this.field_145850_b, pos, false);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, false) == fs.amount && this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), true) >= Config.getInt("pump_consumption")) {
                        this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), false);
                        fs = Utils.drainFluidBlock(this.field_145850_b, pos, true);
                        if (Config.getBoolean("pump_placeCobble") && this.placeCobble) {
                            this.field_145850_b.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
                        }
                        this.tank.fill(fs, true);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        for (EnumFacing f : EnumFacing.values()) {
            if (this.sideConfig[f.ordinal()] != 0) continue;
            this.openList.add(this.func_174877_v().func_177972_a(f));
            this.checkingArea = true;
        }
    }

    public void checkAreaTick() {
        BlockPos next = null;
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            ++timeout;
            next = this.openList.get(0);
            if (!this.checked.contains(next)) {
                Fluid fluid = Utils.getRelatedFluid(this.field_145850_b, next);
                if (!(fluid == null || fluid == FluidRegistry.WATER && Config.getBoolean("pump_infiniteWater") || this.searchFluid != null && fluid != this.searchFluid)) {
                    if (this.searchFluid == null) {
                        this.searchFluid = fluid;
                    }
                    if (Utils.drainFluidBlock(this.field_145850_b, next, false) != null) {
                        this.closedList.add(next);
                    }
                    for (EnumFacing f : EnumFacing.values()) {
                        BlockPos pos2 = next.func_177972_a(f);
                        fluid = Utils.getRelatedFluid(this.field_145850_b, pos2);
                        if (this.checked.contains(pos2) || this.closedList.contains(pos2) || this.openList.contains(pos2) || fluid == null || fluid == FluidRegistry.WATER && Config.getBoolean("pump_infiniteWater") || this.searchFluid != null && fluid != this.searchFluid) continue;
                        this.openList.add(pos2);
                    }
                }
                this.checked.add(next);
            }
            this.openList.remove(0);
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, boolean simulate) {
        if (fs == null) {
            return 0;
        }
        int canAccept = fs.amount;
        if (canAccept <= 0) {
            return 0;
        }
        int accelPower = Config.getInt("pump_consumption_accelerate");
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<TileEntityFluidPipe.DirectionalFluidOutput, Integer> sorting = new HashMap<TileEntityFluidPipe.DirectionalFluidOutput, Integer>();
        for (EnumFacing f : EnumFacing.values()) {
            int temp;
            TileEntity tile;
            if (this.sideConfig[f.ordinal()] != 1 || !((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) instanceof IFluidHandler) || !((IFluidHandler)tile).canFill(f.func_176734_d(), fs.getFluid())) continue;
            FluidStack insertResource = new FluidStack(fs.getFluid(), fs.amount);
            if (tile instanceof TileEntityFluidPipe && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                insertResource.tag = new NBTTagCompound();
                insertResource.tag.func_74757_a("pressurized", true);
            }
            if ((temp = ((IFluidHandler)tile).fill(f.func_176734_d(), insertResource, false)) <= 0) continue;
            sorting.put(new TileEntityFluidPipe.DirectionalFluidOutput((IFluidHandler)tile, f), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (TileEntityFluidPipe.DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                FluidStack insertResource = new FluidStack(fs.getFluid(), amount);
                if (output.output instanceof TileEntityFluidPipe && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    this.energyStorage.extractEnergy(accelPower, false);
                    insertResource.tag = new NBTTagCompound();
                    insertResource.tag.func_74757_a("pressurized", true);
                }
                int r = output.output.fill(output.direction.func_176734_d(), insertResource, !simulate);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, -1, -1, -1, -1, -1};
        }
        this.dummy = nbt.func_74767_n("dummy");
        if (nbt.func_74764_b("placeCobble")) {
            this.placeCobble = nbt.func_74767_n("placeCobble");
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.energyStorage.readFromNBT(nbt);
        if (descPacket) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        nbt.func_74757_a("dummy", this.dummy);
        nbt.func_74757_a("placeCobble", this.placeCobble);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return side >= 0 && side < 6 ? IEEnums.SideConfig.values()[this.sideConfig[side] + 1] : IEEnums.SideConfig.NONE;
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer p) {
        if (side != 1 && !this.dummy) {
            int n = side;
            this.sideConfig[n] = this.sideConfig[n] + 1;
            if (this.sideConfig[side] > 1) {
                this.sideConfig[side] = -1;
            }
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
            return true;
        }
        if (p.func_70093_af()) {
            TileEntity tmp;
            TileEntityFluidPump master = this;
            if (this.dummy && (tmp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileEntityFluidPump) {
                master = (TileEntityFluidPump)tmp;
            }
            master.placeCobble = !master.placeCobble;
            ChatUtils.sendServerNoSpamMessages(p, new IChatComponent[]{new ChatComponentTranslation("chat.ImmersiveEngineering.info.pump.placeCobble." + master.placeCobble, new Object[0])});
            return true;
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource == null || this.dummy || from == null || this.sideConfig[from.ordinal()] != 0) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.dummy || from == null || this.sideConfig[from.ordinal()] != 1) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return !this.dummy && (from == null || this.sideConfig[from.ordinal()] == 0);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return !this.dummy && (from == null || this.sideConfig[from.ordinal()] == 1);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (!(this.dummy || from != null && this.sideConfig[from.ordinal()] == -1)) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from == EnumFacing.UP || !this.dummy && (from == null || this.sideConfig[from.ordinal()] == -1);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.dummy) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0));
            if (te instanceof TileEntityFluidPump) {
                return ((TileEntityFluidPump)te).receiveEnergy(from, maxReceive, simulate);
            }
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (this.dummy) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0));
            if (te instanceof TileEntityFluidPump) {
                return ((TileEntityFluidPump)te).getEnergyStored(from);
            }
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.dummy) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0));
            if (te instanceof TileEntityFluidPump) {
                return ((TileEntityFluidPump)te).getMaxEnergyStored(from);
            }
            return 0;
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.field_145850_b.func_175656_a(pos.func_177982_a(0, 1, 0), state);
        ((TileEntityFluidPump)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)1, (int)0))).dummy = true;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, this.dummy ? -1 : 0, 0).func_177982_a(0, i, 0)) instanceof TileEntityFluidPump)) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, this.dummy ? -1 : 0, 0).func_177982_a(0, i, 0));
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return null;
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        int accelPower = Config.getInt("pump_consumption_accelerate");
        if (this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
            if (consumePower) {
                this.energyStorage.extractEnergy(accelPower, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOutputConnection(EnumFacing side) {
        return side != null && this.sideConfig[side.ordinal()] == 1;
    }
}

