/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalBarrel;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityWoodenBarrel
extends TileEntityIEBase
implements ITickable,
IFluidHandler,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride {
    public int[] sideConfig = new int[]{1, 0};
    public FluidTank tank = new FluidTank(12000);
    public static final int IGNITION_TEMPERATURE = 573;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean update = false;
        for (int i = 0; i < 2; ++i) {
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig[i] != 1) continue;
            EnumFacing f = EnumFacing.func_82600_a((int)i);
            int out = Math.min(40, this.tank.getFluidAmount());
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (te == null || !(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(f.func_176734_d(), this.tank.getFluid().getFluid())) continue;
            int accepted = ((IFluidHandler)te).fill(f.func_176734_d(), new FluidStack(this.tank.getFluid().getFluid(), out), false);
            FluidStack drained = this.tank.drain(accepted, true);
            ((IFluidHandler)te).fill(f.func_176734_d(), drained, true);
            update = true;
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.func_71045_bC())) {
            String s = null;
            s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : StatCollector.func_74838_a((String)"gui.ImmersiveEngineering.empty");
            return new String[]{s};
        }
        if (hammer && Config.getBoolean("colourblindSupport") && mop.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.func_176734_d().ordinal())];
            return new String[]{StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.blockSide.facing") + ": " + StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide.connectFluid." + i)), StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.blockSide.opposite") + ": " + StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide.connectFluid." + j))};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, MovingObjectPosition mop) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 2) {
            this.sideConfig = new int[]{-1, 0};
        }
        this.readTank(nbt);
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        this.writeTank(nbt, false);
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.isFluidValid(resource) && this.canFill(from, resource.getFluid())) {
            int i = this.tank.fill(resource, doFill);
            if (i > 0) {
                this.func_70296_d();
                this.field_145850_b.func_175689_h(this.func_174877_v());
            }
            return i;
        }
        return 0;
    }

    public boolean isFluidValid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getTemperature(fluid) < 573 && !fluid.getFluid().isGaseous(fluid);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource != null ? resource.amount : 0, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            FluidStack f = this.tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0) {
                this.func_70296_d();
                this.field_145850_b.func_175689_h(this.func_174877_v());
            }
            return f;
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return from == null || from.ordinal() < 2 && this.sideConfig[from.ordinal()] == 0;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return from == null || from.ordinal() < 2 && this.sideConfig[from.ordinal()] == 1;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from != null && from.ordinal() < 2 && this.sideConfig[from.ordinal()] != -1) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        if (side > 1) {
            return IEEnums.SideConfig.NONE;
        }
        return IEEnums.SideConfig.values()[this.sideConfig[side] + 1];
    }

    @Override
    public void toggleSide(int side) {
        if (side != 0 && side != 1) {
            return;
        }
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.func_174877_v());
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        FluidStack f = Utils.getFluidFromItemStack(player.func_71045_bC());
        boolean metal = this instanceof TileEntityMetalBarrel;
        if (f != null) {
            if (!metal && f.getFluid().isGaseous(f)) {
                ChatUtils.sendServerNoSpamMessages(player, new IChatComponent[]{new ChatComponentTranslation("chat.ImmersiveEngineering.info.noGasAllowed", new Object[0])});
            } else if (!metal && f.getFluid().getTemperature(f) >= 573) {
                ChatUtils.sendServerNoSpamMessages(player, new IChatComponent[]{new ChatComponentTranslation("chat.ImmersiveEngineering.info.tooHot", new Object[0])});
            } else if (Utils.fillFluidHandlerWithPlayerItem(this.field_145850_b, this, player)) {
                this.func_70296_d();
                this.field_145850_b.func_175689_h(this.func_174877_v());
                return true;
            }
        }
        if (Utils.fillPlayerItemFromFluidHandler(this.field_145850_b, this, player, this.tank.getFluid())) {
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IFluidContainerItem) {
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTank(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_77978_p());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return (int)(15.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }
}

