/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityRailgunShot
extends EntityIEProjectile {
    private ItemStack ammo;
    static final int dataMarker_ammo = 13;
    private RailgunHandler.RailgunProjectileProperties ammoProperties;

    public EntityRailgunShot(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityRailgunShot(World world, double x, double y, double z, double ax, double ay, double az, ItemStack ammo) {
        super(world, x, y, z, ax, ay, az);
        this.func_70105_a(0.5f, 0.5f);
        this.ammo = ammo;
        this.setAmmoSynced();
    }

    public EntityRailgunShot(World world, EntityLivingBase living, double ax, double ay, double az, ItemStack ammo) {
        super(world, living, ax, ay, az);
        this.func_70105_a(0.5f, 0.5f);
        this.ammo = ammo;
        this.setAmmoSynced();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_82709_a(13, 5);
    }

    public void setAmmoSynced() {
        if (this.getAmmo() != null) {
            this.field_70180_af.func_75692_b(13, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return this.field_70180_af.func_82710_f(13);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public RailgunHandler.RailgunProjectileProperties getAmmoProperties() {
        if (this.ammoProperties == null && this.ammo != null) {
            this.ammoProperties = RailgunHandler.getProjectileProperties(this.ammo);
        }
        return this.ammoProperties;
    }

    @Override
    public double getGravity() {
        return 0.005 * (this.getAmmoProperties() != null ? this.getAmmoProperties().gravity : 1.0);
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void func_70030_z() {
        if (this.getAmmo() == null && this.field_70170_p.field_72995_K) {
            this.ammo = this.getAmmoSynced();
        }
        super.func_70030_z();
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K && this.getAmmo() != null && mop.field_72308_g != null && this.getAmmoProperties() != null && !this.getAmmoProperties().overrideHitEntity(mop.field_72308_g, this.getShooter())) {
            mop.field_72308_g.func_70097_a(IEDamageSources.causeRailgunDamage(this, this.getShooter()), (float)this.getAmmoProperties().damage);
        }
    }

    @Override
    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.getAmmo() != null && player.field_71071_by.func_70441_a(this.getAmmo().func_77946_l())) {
            this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.ammo != null) {
            nbt.func_74782_a("ammo", (NBTBase)this.ammo.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.ammo = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ammo"));
    }
}

