/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemIETool
extends ItemIEBase
implements ITool {
    static int hammerMaxDamage;
    static int cutterMaxDamage;

    public ItemIETool() {
        super("tool", 1, "hammer", "wirecutter", "voltmeter", "manual");
        hammerMaxDamage = Config.getInt("hammerDurabiliy");
        cutterMaxDamage = Config.getInt("cutterDurabiliy");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (ItemNBTHelper.hasKey(stack, "linkingPos") && (link = ItemNBTHelper.getIntArray(stack, "linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
        if (adv && stack.func_77952_i() < 2) {
            int nbtDamage = ItemNBTHelper.getInt(stack, stack.func_77952_i() == 0 ? "hammerDmg" : "cutterDmg");
            int maxDamage = stack.func_77952_i() == 0 ? hammerMaxDamage : cutterMaxDamage;
            list.add("Durability: " + (maxDamage - nbtDamage) + " / " + maxDamage);
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() < 2;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int nbtDamage;
        if (stack.func_77952_i() == 0) {
            int nbtDamage2 = ItemNBTHelper.getInt(stack, "hammerDmg") + 1;
            if (nbtDamage2 < hammerMaxDamage) {
                ItemStack container = stack.func_77946_l();
                ItemNBTHelper.setInt(container, "hammerDmg", nbtDamage2);
                return container;
            }
        } else if (stack.func_77952_i() == 1 && (nbtDamage = ItemNBTHelper.getInt(stack, "cutterDmg") + 1) < cutterMaxDamage) {
            ItemStack container = stack.func_77946_l();
            ItemNBTHelper.setInt(container, "cutterDmg", nbtDamage);
            return container;
        }
        return null;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (stack.func_77952_i() == 0) {
                String[] interdictedMultiblocks = null;
                if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                    NBTTagList list = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
                    interdictedMultiblocks = new String[list.func_74745_c()];
                    for (int i = 0; i < interdictedMultiblocks.length; ++i) {
                        interdictedMultiblocks[i] = list.func_150307_f(i);
                    }
                }
                for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                    if (!mb.isBlockTrigger(world.func_180495_p(pos))) continue;
                    if (interdictedMultiblocks != null) {
                        for (String s : interdictedMultiblocks) {
                            if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                            return false;
                        }
                    }
                    if (!mb.createStructure(world, pos, side, player)) continue;
                    return true;
                }
                return RotationUtil.rotateBlock(world, pos, side, player);
            }
            if (stack.func_77952_i() == 1 && tileEntity instanceof IImmersiveConnectable) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(nodeHere), world, new TargetingInfo(side, hitX, hitY, hitZ));
                IESaveData.setDirty(world.field_73011_w.func_177502_q());
                int nbtDamage = ItemNBTHelper.getInt(stack, "cutterDmg") + 1;
                if (nbtDamage < cutterMaxDamage) {
                    ItemNBTHelper.setInt(stack, "cutterDmg", nbtDamage);
                } else {
                    player.func_70669_a(stack);
                    player.func_70062_b(0, null);
                }
                return true;
            }
            if (stack.func_77952_i() == 2) {
                if (!player.func_70093_af() && (tileEntity instanceof IFluxReceiver || tileEntity instanceof IFluxProvider)) {
                    int max = 0;
                    int stored = 0;
                    if (tileEntity instanceof IFluxReceiver) {
                        max = ((IFluxReceiver)tileEntity).getMaxEnergyStored(side);
                        stored = ((IFluxReceiver)tileEntity).getEnergyStored(side);
                    } else {
                        max = ((IFluxProvider)tileEntity).getMaxEnergyStored(side);
                        stored = ((IFluxProvider)tileEntity).getEnergyStored(side);
                    }
                    if (max > 0) {
                        ChatUtils.sendServerNoSpamMessages(player, new IChatComponent[]{new ChatComponentTranslation("chat.ImmersiveEngineering.info.energyStorage", new Object[]{stored, max})});
                    }
                    return true;
                }
                if (player.func_70093_af() && tileEntity instanceof IImmersiveConnectable) {
                    if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                        ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.func_177502_q(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                    } else {
                        int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
                        BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                        TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
                        if (array[0] == world.field_73011_w.func_177502_q()) {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            if (nodeLink != null) {
                                Set<ImmersiveNetHandler.AbstractConnection> connections = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(nodeLink), world, true);
                                for (ImmersiveNetHandler.AbstractConnection con : connections) {
                                    if (!Utils.toCC(nodeHere).equals((Object)con.end)) continue;
                                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.averageLoss", new Object[]{Utils.formatDouble(con.getAverageLossRate() * 100.0f, "###.000")}));
                                }
                            }
                        }
                        ItemNBTHelper.remove(stack, "linkingPos");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        return !player.field_70170_p.field_72995_K && stack.func_77952_i() == 0 && RotationUtil.rotateEntity((Entity)entity, player);
    }

    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        if (player.func_71045_bC() != null && this.equals(player.func_71045_bC().func_77973_b())) {
            return player.func_71045_bC().func_77952_i() == 0;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77952_i() == 3) {
            player.func_71029_a((StatBase)IEAchievements.openManual);
            if (world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, 0, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return stack;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return ItemNBTHelper.getInt(stack, "hammerDmg") > 0;
        }
        if (stack.func_77952_i() == 1) {
            return ItemNBTHelper.getInt(stack, "cutterDmg") > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return (double)ItemNBTHelper.getInt(stack, "hammerDmg") / (double)hammerMaxDamage;
        }
        if (stack.func_77952_i() == 1) {
            return (double)ItemNBTHelper.getInt(stack, "cutterDmg") / (double)cutterMaxDamage;
        }
        return 0.0;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.func_77952_i();
        return meta == 0 ? ImmutableSet.of((Object)"IE_HAMMER") : (meta == 1 ? ImmutableSet.of((Object)"IE_WIRECUTTER") : new HashSet());
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return 6.0f;
        }
        return super.getDigSpeed(stack, state);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return item.func_77952_i() != 3;
    }
}

