/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.tool.IBullet;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.network.MessageSpeedloaderSync;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRevolver
extends ItemUpgradeableTool
implements IShaderEquipableItem,
IOBJModelCallback<ItemStack>,
ITool {
    public HashMap<String, TextureAtlasSprite> revolverIcons = new HashMap();
    public TextureAtlasSprite revolverDefaultTexture;
    public static final ArrayListMultimap<String, SpecialRevolver> specialRevolvers = ArrayListMultimap.create();
    public static final Map<String, SpecialRevolver> specialRevolversByTag = new HashMap<String, SpecialRevolver>();

    public ItemRevolver() {
        super("revolver", 1, "REVOLVER", new String[]{"normal", "speedloader"});
    }

    public void stichRevolverTextures(TextureMap map) {
        this.revolverDefaultTexture = ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/revolver");
        for (String key : specialRevolversByTag.keySet()) {
            if (key.isEmpty() || ItemRevolver.specialRevolversByTag.get((Object)key).tag.isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            this.revolverIcons.put(key, ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/revolver_" + key.substring(0, split)));
        }
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 21;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 18, 80, 32, "REVOLVER", stack, true), new IESlot.Upgrades(container, invItem, 19, 100, 32, "REVOLVER", stack, true), new IESlot.Shader(container, invItem, 20, 130, 32, stack)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return stack.func_77952_i() != 1;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public void setShaderItem(ItemStack stack, ItemStack shader) {
        ItemStack[] contained = this.getContainedItems(stack);
        contained[20] = shader;
        this.setContainedItems(stack, contained);
    }

    @Override
    public ItemStack getShaderItem(ItemStack stack) {
        ItemStack[] contained = this.getContainedItems(stack);
        return contained[20];
    }

    @Override
    public String getShaderType() {
        return "revolver";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        if (stack.func_77952_i() != 1) {
            String tag = this.getRevolverDisplayTag(stack);
            if (!tag.isEmpty()) {
                list.add(StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.flavour.revolver." + tag)));
            } else if (ItemNBTHelper.hasKey(stack, "flavour")) {
                list.add(StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.flavour.revolver." + ItemNBTHelper.getString(stack, "flavour"))));
            } else if (stack.func_77952_i() == 0) {
                list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.revolver"));
            }
            ItemStack shader = this.getShaderItem(stack);
            if (shader != null) {
                list.add(EnumChatFormatting.DARK_GRAY + shader.func_82833_r());
            }
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        String tag;
        if (stack.func_77952_i() != 1 && !(tag = this.getRevolverDisplayTag(stack)).isEmpty()) {
            return this.func_77658_a() + "." + tag;
        }
        return super.func_77667_c(stack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double speed;
        Multimap multimap = super.getAttributeModifiers(stack);
        double melee = this.getUpgrades(stack).func_74769_h("melee");
        if (melee != 0.0) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", melee, 0));
        }
        if ((speed = this.getUpgrades(stack).func_74769_h("speed")) != 0.0) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", speed, 1));
        }
        return multimap;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        if (!world.field_72995_K && stack.func_77952_i() != 1 && ent != null && ItemNBTHelper.hasKey(stack, "blocked")) {
            int l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "casings", ent);
            if (l == 0) {
                ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderFill", "tile.piston.in", 0.3f, 3.0f, 1, 6, 1);
            }
            if ((l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderFill", ent)) == 0) {
                ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderClose", "fire.ignite", 0.6f, 5.0f, 1, 6, 1);
            }
            if ((l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderClose", ent)) == 0) {
                ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderSpin", "note.hat", 0.1f, 5.0f, 5, 8, 1);
            }
            if ((l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderSpin", ent)) == 0) {
                ItemNBTHelper.remove(stack, "blocked");
            }
        }
    }

    public ItemStack func_77659_a(ItemStack revolver, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_70093_af() || revolver.func_77952_i() == 1) {
                player.openGui((Object)ImmersiveEngineering.instance, 6, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else if (this.getUpgrades(revolver).func_74767_n("nerf")) {
                world.func_72956_a((Entity)player, "random.pop", 1.0f, 0.6f);
            } else {
                ItemStack[] bullets = this.getBullets(revolver);
                if (this.isEmpty(revolver)) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack loader = player.field_71071_by.func_70301_a(i);
                        if (loader == null || loader.func_77973_b() != this || loader.func_77952_i() != 1 || this.isEmpty(loader)) continue;
                        int dc = 0;
                        for (ItemStack b : bullets) {
                            if (b == null) continue;
                            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, b));
                            ++dc;
                        }
                        world.func_72956_a((Entity)player, "fire.ignite", 0.5f, 3.0f);
                        ItemNBTHelper.setDelayedSoundsForStack(revolver, "casings", "random.successful_hit", 0.05f, 5.0f, dc / 2, 8, 2);
                        this.setBullets(revolver, this.getBullets(loader));
                        this.setBullets(loader, new ItemStack[8]);
                        player.field_71071_by.func_70299_a(i, loader);
                        player.field_71071_by.func_70296_d();
                        if (player instanceof EntityPlayerMP) {
                            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSpeedloaderSync(i), (EntityPlayerMP)player);
                        }
                        ItemNBTHelper.setBoolean(revolver, "blocked", true);
                        return revolver;
                    }
                }
                if (!ItemNBTHelper.getBoolean(revolver, "blocked")) {
                    if (bullets[0] != null && bullets[0].func_77973_b() instanceof IBullet && ((IBullet)bullets[0].func_77973_b()).canSpawnBullet(bullets[0])) {
                        ((IBullet)bullets[0].func_77973_b()).spawnBullet(player, bullets[0], this.getUpgrades(revolver).func_74767_n("electro"));
                        bullets[0] = ((IBullet)bullets[0].func_77973_b()).getCasing(bullets[0]);
                        world.func_72956_a((Entity)player, "immersiveengineering:revolverFire", 1.0f, 1.0f);
                    } else {
                        world.func_72956_a((Entity)player, "note.hat", 0.6f, 3.0f);
                    }
                    ItemStack[] cycled = new ItemStack[this.getBulletSlotAmount(revolver)];
                    for (int i = 1; i < cycled.length; ++i) {
                        cycled[i - 1] = bullets[i];
                    }
                    cycled[cycled.length - 1] = bullets[0];
                    this.setBullets(revolver, cycled);
                }
            }
        }
        return revolver;
    }

    public boolean isEmpty(ItemStack stack) {
        ItemStack[] bullets = this.getBullets(stack);
        boolean empty = true;
        for (ItemStack b : bullets) {
            if (b == null || !(b.func_77973_b() instanceof IBullet) || !((IBullet)b.func_77973_b()).canSpawnBullet(b)) continue;
            empty = false;
        }
        return empty;
    }

    public ItemStack[] getBullets(ItemStack revolver) {
        ItemStack[] stackList = this.getContainedItems(revolver);
        ItemStack[] bullets = new ItemStack[this.getBulletSlotAmount(revolver)];
        System.arraycopy(stackList, 0, bullets, 0, bullets.length);
        return bullets;
    }

    public void setBullets(ItemStack revolver, ItemStack[] bullets) {
        ItemStack[] stackList = this.getContainedItems(revolver);
        for (int i = 0; i < bullets.length; ++i) {
            stackList[i] = bullets[i];
        }
        this.setContainedItems(revolver, stackList);
    }

    public int getBulletSlotAmount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).func_74762_e("bullets");
    }

    @Override
    public NBTTagCompound getUpgradeBase(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "baseUpgrades");
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String material) {
        String tag = ItemNBTHelper.getString(stack, "elite");
        if (!tag.isEmpty()) {
            return this.revolverIcons.get(tag);
        }
        return this.revolverDefaultTexture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        NBTTagCompound upgrades;
        SpecialRevolver r;
        if (group.equals("revolver_frame") || group.equals("barrel") || group.equals("cosmetic_compensator")) {
            return true;
        }
        HashSet<String> render = new HashSet<String>();
        String tag = ItemNBTHelper.getString(stack, "elite");
        String flavour = ItemNBTHelper.getString(stack, "flavour");
        if (tag != null && !tag.isEmpty() && specialRevolversByTag.containsKey(tag)) {
            r = specialRevolversByTag.get(tag);
            if (r != null && r.renderAdditions != null) {
                for (String ss : r.renderAdditions) {
                    render.add(ss);
                }
            }
        } else if (flavour != null && !flavour.isEmpty() && specialRevolversByTag.containsKey(flavour) && (r = specialRevolversByTag.get(flavour)) != null && r.renderAdditions != null) {
            for (String ss : r.renderAdditions) {
                render.add(ss);
            }
        }
        if ((upgrades = this.getUpgrades(stack)).func_74762_e("bullets") > 0 && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (upgrades.func_74769_h("melee") > 0.0 && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (upgrades.func_74767_n("electro")) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        return render.contains(group);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective) {
        return perspective;
    }

    public String[] compileRender(ItemStack revolver) {
        NBTTagCompound upgrades;
        SpecialRevolver r;
        HashSet<String> render = new HashSet<String>();
        render.add("revolver_frame");
        render.add("barrel");
        render.add("cosmetic_compensator");
        String tag = ItemNBTHelper.getString(revolver, "elite");
        String flavour = ItemNBTHelper.getString(revolver, "flavour");
        if (tag != null && !tag.isEmpty() && specialRevolversByTag.containsKey(tag)) {
            r = specialRevolversByTag.get(tag);
            if (r != null && r.renderAdditions != null) {
                for (String ss : r.renderAdditions) {
                    render.add(ss);
                }
            }
        } else if (flavour != null && !flavour.isEmpty() && specialRevolversByTag.containsKey(flavour) && (r = specialRevolversByTag.get(flavour)) != null && r.renderAdditions != null) {
            for (String ss : r.renderAdditions) {
                render.add(ss);
            }
        }
        if ((upgrades = this.getUpgrades(revolver)).func_74762_e("bullets") > 0 && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (upgrades.func_74769_h("melee") > 0.0 && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (upgrades.func_74767_n("electro")) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        return render.toArray(new String[render.size()]);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        ArrayList list;
        if (stack == null || player == null) {
            return;
        }
        if (stack.func_77952_i() == 1) {
            return;
        }
        String uuid = player.func_110124_au().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = ItemNBTHelper.getString(stack, "elite");
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            ItemNBTHelper.remove(stack, "elite");
            ItemNBTHelper.remove(stack, "flavour");
            ItemNBTHelper.remove(stack, "baseUpgrades");
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            ItemNBTHelper.setString(stack, "elite", r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            ItemNBTHelper.setString(stack, "flavour", r.flavour);
        }
        NBTTagCompound baseUpgrades = new NBTTagCompound();
        for (Map.Entry<String, Object> e : r.baseUpgrades.entrySet()) {
            if (e.getValue() instanceof Boolean) {
                baseUpgrades.func_74757_a(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                baseUpgrades.func_74768_a(e.getKey(), ((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof Float) {
                baseUpgrades.func_74780_a(e.getKey(), (double)((Float)e.getValue()).floatValue());
                continue;
            }
            if (e.getValue() instanceof Double) {
                baseUpgrades.func_74780_a(e.getKey(), ((Double)e.getValue()).doubleValue());
                continue;
            }
            if (!(e.getValue() instanceof String)) continue;
            baseUpgrades.func_74778_a(e.getKey(), (String)e.getValue());
        }
        ItemNBTHelper.setTagCompound(stack, "baseUpgrades", baseUpgrades);
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        ItemStack[] contents = this.getContainedItems(stack);
        if (contents[18] != null && contents[19] != null) {
            player.func_71029_a((StatBase)IEAchievements.upgradeRevolver);
        }
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public static class SpecialRevolver {
        public final String[] uuid;
        public final String tag;
        public final String flavour;
        public final HashMap<String, Object> baseUpgrades;
        public final String[] renderAdditions;

        public SpecialRevolver(String[] uuid, String tag, String flavour, HashMap<String, Object> baseUpgrades, String[] renderAdditions) {
            this.uuid = uuid;
            this.tag = tag;
            this.flavour = flavour;
            this.baseUpgrades = baseUpgrades;
            this.renderAdditions = renderAdditions;
        }
    }
}

