/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxContainerItem;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.entities.EntityGrapplingHook;
import blusunrize.immersiveengineering.common.items.ItemManeuverGear;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.compat.BaublesHelper;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.oredict.OreDictionary;

public class ManeuverGearHelper {
    private static HashMap<String, EntityGrapplingHook[]> hookMap = new HashMap();
    static ItemStack gearStack;

    public static EntityGrapplingHook[] getHooks(EntityPlayer player) {
        EntityGrapplingHook[] hooks = hookMap.get(player.func_70005_c_());
        if (hooks == null || hooks.length < 2) {
            hooks = new EntityGrapplingHook[2];
            hookMap.put(player.func_70005_c_(), hooks);
        }
        return hooks;
    }

    public static void pressHookButton(EntityPlayer player, int hook) {
        EntityGrapplingHook[] hooks = ManeuverGearHelper.getHooks(player);
        if ((hooks[hook] == null || hooks[hook].field_70128_L) && ManeuverGearHelper.doHookRFCheck(player, true)) {
            ManeuverGearHelper.doHookRFCheck(player, false);
            Vec3 vec = player.func_70040_Z();
            EntityGrapplingHook entityHook = new EntityGrapplingHook(player.field_70170_p, (EntityLivingBase)player, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            entityHook.setHookNr(hook);
            entityHook.setHookMode(HookMode.LAUNCHING);
            entityHook.setHookNrSynced();
            entityHook.setHookModeSynced();
            hooks[hook] = entityHook;
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72838_d((Entity)entityHook);
            }
        } else if (hooks[hook] != null && !hooks[hook].field_70128_L && hooks[hook].getHookMode() != HookMode.RETURNING && hooks[hook].field_70254_i) {
            hooks[hook].setHookMode(HookMode.REELING);
            hooks[hook].setHookModeSynced();
        }
    }

    public static void releaseHookButton(EntityPlayer player, int hook) {
        EntityGrapplingHook[] hooks = ManeuverGearHelper.getHooks(player);
        if (hooks[hook] != null && !hooks[hook].field_70128_L && hooks[hook].getHookMode() != HookMode.RETURNING && hooks[hook].field_70254_i) {
            hooks[hook].setHookMode(HookMode.LAUNCHING);
            hooks[hook].setHookModeSynced();
        }
    }

    public static void returnHook(EntityPlayer player, int hook) {
        EntityGrapplingHook[] hooks = ManeuverGearHelper.getHooks(player);
        if (hooks[hook] != null) {
            hooks[hook].setHookMode(HookMode.RETURNING);
            hooks[hook].field_70145_X = true;
            hooks[hook].setHookModeSynced();
        }
    }

    public static void doGasJump(EntityPlayer player) {
        if (ManeuverGearHelper.doGasJumpCheck(player, true)) {
            ManeuverGearHelper.doGasJumpCheck(player, false);
            player.func_70031_b(true);
            float increase = 0.4f;
            if (increase > 0.56f) {
                increase = 0.56f;
            }
            float speed = 2.0f;
            Vec3 vec = player.func_70040_Z();
            player.field_70159_w = vec.field_72450_a * (double)speed;
            player.field_70181_x = vec.field_72448_b * 0.375 * (double)speed;
            player.field_70179_y = vec.field_72449_c * (double)speed;
            player.field_70181_x += (double)increase;
        }
    }

    public static boolean isPlayerWearing3DMG(EntityPlayer player) {
        return ManeuverGearHelper.getPlayer3DMG(player) != null;
    }

    public static ItemStack getPlayer3DMG(EntityPlayer player) {
        ItemStack belt;
        if (gearStack == null) {
            gearStack = new ItemStack(IEContent.itemManeuverGear, 1, Short.MAX_VALUE);
        }
        if (Lib.BAUBLES && OreDictionary.itemMatches((ItemStack)gearStack, (ItemStack)(belt = BaublesHelper.getBauble(player, 3)), (boolean)false)) {
            return belt;
        }
        ItemStack leggings = player.func_82169_q(1);
        if (OreDictionary.itemMatches((ItemStack)gearStack, (ItemStack)leggings, (boolean)false)) {
            return leggings;
        }
        return null;
    }

    public static void updatePlayer3DMG(EntityPlayer player, ItemStack gear) {
        ItemStack leggings;
        ItemStack belt;
        if (gearStack == null) {
            gearStack = new ItemStack(IEContent.itemManeuverGear, 1, Short.MAX_VALUE);
        }
        if (Lib.BAUBLES && OreDictionary.itemMatches((ItemStack)gearStack, (ItemStack)(belt = BaublesHelper.getBauble(player, 3)), (boolean)false)) {
            BaublesHelper.setBauble(player, 3, gear);
        }
        if (OreDictionary.itemMatches((ItemStack)gearStack, (ItemStack)(leggings = player.func_82169_q(1)), (boolean)false)) {
            player.func_70062_b(2, gear);
        }
    }

    public static boolean doHookRFCheck(EntityPlayer player, boolean simulate) {
        ItemStack gear = ManeuverGearHelper.getPlayer3DMG(player);
        if (gear == null) {
            return false;
        }
        return ((IFluxContainerItem)gear.func_77973_b()).extractEnergy(gear, ItemManeuverGear.hookCost, simulate) == ItemManeuverGear.hookCost;
    }

    public static boolean doGasJumpCheck(EntityPlayer player, boolean simulate) {
        ItemStack gear = ManeuverGearHelper.getPlayer3DMG(player);
        if (gear == null) {
            return false;
        }
        float gas = ItemNBTHelper.getFloat(gear, "gas");
        if ((double)gas < ItemManeuverGear.jumpCost) {
            return false;
        }
        if (!simulate) {
            gas = (float)((double)gas - ItemManeuverGear.jumpCost);
            ItemNBTHelper.setFloat(gear, "gas", gas);
            ItemNBTHelper.setInt(gear, "cooldown", ItemManeuverGear.rechargeCooldown);
            ManeuverGearHelper.updatePlayer3DMG(player, gear);
        }
        return true;
    }

    public static enum HookMode {
        LAUNCHING,
        REELING,
        RETURNING;

    }

    public static enum ManeuverGearOperator {
        PRESS_0,
        PRESS_1,
        RELEASE_0,
        RELEASE_1,
        RETRACT_0,
        RETRACT_1,
        RETRACT_ALL,
        PRESS_SPACE;

    }
}

