/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class PeripheralCrusher
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getQueueLength", "setEnabled", "isActive", "getInputStack", "getMaxEnergyStored", "getEnergyStored"};

    public PeripheralCrusher(World w, BlockPos pos) {
        super(w, pos);
    }

    public String getType() {
        return "IE:crusher";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityCrusher te = this.getTileEntity(TileEntityCrusher.class);
        if (te == null) {
            throw new LuaException("The crusher was removed");
        }
        switch (method) {
            case 0: {
                List<ItemStack> list = te.inputs;
                synchronized (list) {
                    return new Object[]{te.processQueue.size()};
                }
            }
            case 1: {
                boolean param;
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = param = ((Boolean)arguments[0]).booleanValue();
                return null;
            }
            case 2: {
                return new Object[]{te.shouldRenderAsActive()};
            }
            case 3: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int id = (int)((Double)arguments[0]).doubleValue();
                if (id < 1 || te.processQueue.size() < id) {
                    throw new LuaException("The requested place in the queue does not exist");
                }
                TileEntityMultiblockMetal.MultiblockProcessInWorld process = (TileEntityMultiblockMetal.MultiblockProcessInWorld)te.processQueue.get(id - 1);
                Map<String, Object> ret = Utils.saveStack(process.inputItem);
                ret.put("progress", process.processTick);
                ret.put("maxProgress", process.maxTicks);
                return new Object[]{ret};
            }
            case 4: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 5: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityCrusher te = (TileEntityCrusher)this.w.func_175625_s(this.pos);
        if (te == null) {
            return;
        }
        ++te.controllingComputers;
        te.computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntityCrusher te = (TileEntityCrusher)this.w.func_175625_s(this.pos);
        if (te == null) {
            return;
        }
        --te.controllingComputers;
    }
}

