/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySqueezer;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class PeripheralSqueezer
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getRecipe", "getInputStack", "getOutputStack", "getFluid", "getEmptyCannisters", "getFilledCannisters", "getEnergyStored", "getMaxEnergyStored", "isActive", "setEnabled"};

    public PeripheralSqueezer(World w, BlockPos pos) {
        super(w, pos);
    }

    public String getType() {
        return "IE:squeezer";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntitySqueezer te = this.getTileEntity(TileEntitySqueezer.class);
        if (te == null) {
            throw new LuaException("The squeezer was removed");
        }
        switch (method) {
            case 0: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 8) {
                    throw new LuaException("Input slots are numbers 1-8");
                }
                SqueezerRecipe recipe = SqueezerRecipe.findRecipe(te.inventory[slot - 1]);
                if (recipe != null) {
                    return new Object[]{Utils.saveStack(recipe.input.getExampleStack()), Utils.saveStack(recipe.itemOutput), Utils.saveFluidStack(recipe.fluidOutput), recipe.getTotalProcessTime()};
                }
                return new Object[]{"No recipe found"};
            }
            case 1: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 8) {
                    throw new LuaException("Input slots are numbers 1-8");
                }
                return new Object[]{Utils.saveStack(te.inventory[slot - 1])};
            }
            case 2: {
                return new Object[]{Utils.saveStack(te.inventory[8])};
            }
            case 3: {
                return new Object[]{Utils.saveFluidTank(te.tanks[0])};
            }
            case 4: {
                return new Object[]{Utils.saveStack(te.inventory[9])};
            }
            case 5: {
                return new Object[]{Utils.saveStack(te.inventory[10])};
            }
            case 6: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
            case 7: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 8: {
                return new Object[]{te.shouldRenderAsActive()};
            }
            case 9: {
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = (Boolean)arguments[0];
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntitySqueezer te = (TileEntitySqueezer)this.w.func_175625_s(this.pos);
        if (te == null) {
            return;
        }
        ++te.controllingComputers;
        te.computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntitySqueezer te = (TileEntitySqueezer)this.w.func_175625_s(this.pos);
        if (te == null) {
            return;
        }
        te.computerOn = false;
    }
}

