/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class PeripheralTeslaCoil
extends IEPeripheral {
    static final String[] cmds = new String[]{"isActive", "setRSMode", "setPowerMode"};

    public PeripheralTeslaCoil(World w, BlockPos pos) {
        super(w, pos);
    }

    public String getType() {
        return "IE:teslaCoil";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityTeslaCoil te = this.getTileEntity(TileEntityTeslaCoil.class);
        if (te == null) {
            throw new LuaException("The tesla coil was removed");
        }
        switch (method) {
            case 0: {
                int energyDrain = Config.getInt("teslacoil_consumption");
                if (te.lowPower) {
                    energyDrain /= 2;
                }
                return new Object[]{te.canRun(energyDrain)};
            }
            case 1: {
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.redstoneControlInverted = (Boolean)arguments[0];
                break;
            }
            case 2: {
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                int energyDrain = Config.getInt("teslacoil_consumption");
                if (te.lowPower) {
                    energyDrain /= 2;
                }
                if (te.canRun(energyDrain)) {
                    throw new LuaException("Can't switch power mode on an active coil");
                }
                te.lowPower = (Boolean)arguments[0] == false;
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    @Override
    public boolean equals(IPeripheral other) {
        if (!(other instanceof PeripheralTeslaCoil)) {
            return false;
        }
        PeripheralTeslaCoil otherPer = (PeripheralTeslaCoil)other;
        return this.w == otherPer.w && this.pos.equals((Object)otherPer.pos);
    }
}

