/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.items.ItemGraphiteElectrode;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ArcFurnaceDriver
extends DriverSidedTileEntity {
    public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing facing) {
        TileEntityArcFurnace arc;
        TileEntityArcFurnace master;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof TileEntityArcFurnace && (master = (TileEntityArcFurnace)(arc = (TileEntityArcFurnace)te).master()) != null && arc.isRedstonePos()) {
            return new ArcFurnaceEnvironment(w, master.func_174877_v(), TileEntityArcFurnace.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityArcFurnace.class;
    }

    public class ArcFurnaceEnvironment
    extends ManagedEnvironmentIE<TileEntityArcFurnace> {
        public String preferredName() {
            return "ie_arc_furnace";
        }

        public int priority() {
            return 1000;
        }

        public ArcFurnaceEnvironment(World w, BlockPos p, Class<? extends TileEntityIEBase> teClass) {
            super(w, p, teClass);
        }

        public void onConnect(Node node) {
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.getTileEntity();
            if (master != null) {
                ++master.controllingComputers;
                master.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityArcFurnace te = (TileEntityArcFurnace)this.getTileEntity();
            if (te != null) {
                --te.controllingComputers;
            }
        }

        @Callback(doc="function():int -- gets the maximum amount of energy stored")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():int -- gets the amount of energy stored")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function(on:boolean) -- turns the excavator on or off")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityArcFurnace)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():boolean -- checks whether the arc furnace is currently active")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).shouldRenderAsActive()};
        }

        @Callback(doc="function(stack:int):table -- returns the specified input stack as described in the manual")
        public Object[] getInputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 12) {
                throw new IllegalArgumentException("Input slots are 1-12");
            }
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.getTileEntity();
            Map<String, Object> stack = Utils.saveStack(master.inventory[slot - 1]);
            block0: for (TileEntityMultiblockMetal.MultiblockProcess p : master.processQueue) {
                for (int i : ((TileEntityMultiblockMetal.MultiblockProcessInMachine)p).getInputSlots()) {
                    if (i != slot - 1) continue;
                    stack.put("progress", p.processTick);
                    stack.put("maxProgress", p.maxTicks);
                    break block0;
                }
            }
            if (!stack.containsKey("progress")) {
                stack.put("progress", 0);
                stack.put("maxProgress", 0);
            }
            return new Object[]{stack};
        }

        @Callback(doc="function(stack:int):table -- returns the specified output stack")
        public Object[] getOutputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 6) {
                throw new IllegalArgumentException("Output slots are 1-6");
            }
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).inventory[slot + 15]};
        }

        @Callback(doc="function(stack:int):table -- returns the specified additive stack")
        public Object[] getAdditiveStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 4) {
                throw new IllegalArgumentException("Additive slots are 1-4");
            }
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).inventory[slot + 11]};
        }

        @Callback(doc="function():table -- returns the slag stack")
        public Object[] getSlagStack(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).inventory[22]};
        }

        @Callback(doc="function():boolean -- checks whether the arc furnace has all 3 electrodes")
        public Object[] hasElectrodes(Context context, Arguments args) {
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.getTileEntity();
            return new Object[]{master.hasElectrodes()};
        }

        @Callback(doc="function(electrode:int):table -- returns the specified electrode as an item stack")
        public Object[] getElectrode(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 3) {
                throw new IllegalArgumentException("Electrode slots are 1-3");
            }
            ItemStack stack = ((TileEntityArcFurnace)this.getTileEntity()).inventory[slot + 22];
            Map<String, Object> map = Utils.saveStack(stack);
            if (stack != null && stack.func_77973_b() instanceof ItemGraphiteElectrode) {
                map.put("damage", ItemNBTHelper.getInt(stack, "graphDmg"));
            }
            return new Object[]{map};
        }
    }
}

