/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class CrusherDriver
extends DriverSidedTileEntity {
    public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing facing) {
        TileEntityCrusher crush;
        TileEntityCrusher master;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof TileEntityCrusher && (master = (TileEntityCrusher)(crush = (TileEntityCrusher)te).master()) != null && crush.isRedstonePos()) {
            return new CrusherEnvironment(w, master.func_174877_v(), TileEntityCrusher.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityCrusher.class;
    }

    public class CrusherEnvironment
    extends ManagedEnvironmentIE<TileEntityCrusher> {
        public CrusherEnvironment(World w, BlockPos bp, Class<? extends TileEntityIEBase> teClass) {
            super(w, bp, teClass);
        }

        @Callback(doc="function(enable:boolean) -- enable or disable the crusher")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityCrusher)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():number -- get energy storage capacity")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function():number -- get currently stored energy")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():boolean -- get whether the crusher is currently crushing items")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).shouldRenderAsActive()};
        }

        @Callback(doc="function(n:int):table -- get the n'th stack in the input queue with additional information as described in the manual")
        public Object[] getInputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            TileEntityCrusher master = (TileEntityCrusher)this.getTileEntity();
            if (slot < 1 || slot > master.processQueue.size()) {
                throw new IllegalArgumentException("The requested place in the queue does not exist");
            }
            TileEntityMultiblockMetal.MultiblockProcessInWorld process = (TileEntityMultiblockMetal.MultiblockProcessInWorld)master.processQueue.get(slot - 1);
            Map<String, Object> ret = Utils.saveStack(process.inputItem);
            ret.put("progress", process.processTick);
            ret.put("maxProgress", process.maxTicks);
            return new Object[]{ret};
        }

        public String preferredName() {
            return "ie_crusher";
        }

        public int priority() {
            return 1000;
        }

        public void onConnect(Node node) {
            TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity();
            if (te != null) {
                ++te.controllingComputers;
                te.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity();
            if (te != null) {
                --te.controllingComputers;
            }
        }
    }
}

