/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.waila;

import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.plant.BlockIECrop;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import java.util.List;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class IEWailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        IEWailaDataProvider dataProvider = new IEWailaDataProvider();
        registrar.registerBodyProvider((IWailaDataProvider)dataProvider, BlockIECrop.class);
        registrar.registerBodyProvider((IWailaDataProvider)dataProvider, TileEntityWoodenBarrel.class);
        registrar.registerStackProvider((IWailaDataProvider)dataProvider, TileEntityMultiblockPart.class);
        registrar.registerBodyProvider((IWailaDataProvider)dataProvider, IFluxReceiver.class);
        registrar.registerNBTProvider((IWailaDataProvider)dataProvider, IFluxReceiver.class);
        registrar.registerBodyProvider((IWailaDataProvider)dataProvider, IFluxProvider.class);
        registrar.registerNBTProvider((IWailaDataProvider)dataProvider, IFluxProvider.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() instanceof TileEntityMultiblockPart) {
            return new ItemStack(accessor.getBlock(), 1, accessor.getMetadata());
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block b = accessor.getBlock();
        TileEntity tile = accessor.getTileEntity();
        if (b instanceof BlockIECrop) {
            int max;
            int meta = accessor.getMetadata();
            int min = ((BlockIECrop)b).getMinMeta(meta);
            if (min == (max = ((BlockIECrop)b).getMaxMeta(meta))) {
                currenttip.add(String.format("%s : %s", StatCollector.func_74838_a((String)"hud.msg.growth"), StatCollector.func_74838_a((String)"hud.msg.mature")));
            } else {
                float growth = (float)(meta - min) / (float)(max - min) * 100.0f;
                if ((double)growth < 100.0) {
                    currenttip.add(String.format("%s : %.0f %%", StatCollector.func_74838_a((String)"hud.msg.growth"), Float.valueOf(growth)));
                } else {
                    currenttip.add(String.format("%s : %s", StatCollector.func_74838_a((String)"hud.msg.growth"), StatCollector.func_74838_a((String)"hud.msg.mature")));
                }
            }
            return currenttip;
        }
        if (tile instanceof TileEntityWoodenBarrel) {
            NBTTagCompound tank = accessor.getNBTData().func_74775_l("tank");
            if (!tank.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tank);
                currenttip.add(String.format("%s: %d / %d mB", fluid.getLocalizedName(), fluid.amount, 12000));
            } else {
                currenttip.add(StatCollector.func_74838_a((String)"hud.msg.empty"));
            }
        }
        if (accessor.getNBTData().func_74764_b("Energy")) {
            int cur = accessor.getNBTInteger(accessor.getNBTData(), "Energy");
            int max = accessor.getNBTInteger(accessor.getNBTData(), "MaxStorage");
            if (max > 0 && ((ITaggedList)currenttip).getEntries((Object)"IFEnergyStorage").size() == 0) {
                ((ITaggedList)currenttip).add((Object)String.format("%d / %d IF", cur, max), (Object)"IFEnergyStorage");
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        int cur = -1;
        int max = -1;
        if (te instanceof IFluxReceiver) {
            cur = ((IFluxReceiver)te).getEnergyStored(null);
            max = ((IFluxReceiver)te).getMaxEnergyStored(null);
        } else if (te instanceof IFluxReceiver) {
            cur = ((IFluxProvider)te).getEnergyStored(null);
            max = ((IFluxProvider)te).getMaxEnergyStored(null);
        }
        tag.func_74768_a("Energy", cur);
        tag.func_74768_a("MaxStorage", max);
        return tag;
    }
}

