/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class IEWorldGen
implements IWorldGenerator {
    public static ArrayList<OreGen> orespawnList = new ArrayList();
    public static ArrayList<Integer> oreDimBlacklist = new ArrayList();
    public static ArrayListMultimap<Integer, ChunkCoordIntPair> retrogenChunks = ArrayListMultimap.create();

    public static OreGen addOreGen(String name, IBlockState state, int maxVeinSize, int minY, int maxY, int chunkOccurence, int weight) {
        OreGen gen = new OreGen(name, state, maxVeinSize, Blocks.field_150348_b, minY, maxY, chunkOccurence, weight);
        orespawnList.add(gen);
        return gen;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOres(random, chunkX, chunkZ, world, true);
    }

    public void generateOres(Random random, int chunkX, int chunkZ, World world, boolean newGeneration) {
        if (!oreDimBlacklist.contains(world.field_73011_w.func_177502_q())) {
            for (OreGen gen : orespawnList) {
                if (!newGeneration && !Config.getBoolean("retrogen_" + gen.name)) continue;
                gen.generate(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        NBTTagCompound nbt = new NBTTagCompound();
        event.getData().func_74782_a("ImmersiveEngineering", (NBTBase)nbt);
        nbt.func_74757_a(Config.getString("retrogen_key"), true);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        int dimension = event.world.field_73011_w.func_177502_q();
        if (!event.getData().func_74775_l("ImmersiveEngineering").func_74764_b(Config.getString("retrogen_key")) && (Config.getBoolean("retrogen_copper") || Config.getBoolean("retrogen_bauxite") || Config.getBoolean("retrogen_lead") || Config.getBoolean("retrogen_silver") || Config.getBoolean("retrogen_nickel") || Config.getBoolean("retrogen_uranium"))) {
            if (Config.getBoolean("retrogen_log_flagChunk")) {
                IELogger.info("Chunk " + event.getChunk().func_76632_l() + " has been flagged for Ore RetroGeneration by IE.");
            }
            retrogenChunks.put((Object)dimension, (Object)event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.START) {
            return;
        }
        int dimension = event.world.field_73011_w.func_177502_q();
        int counter = 0;
        List chunks = retrogenChunks.get((Object)dimension);
        if (chunks != null && chunks.size() > 0) {
            for (int i = 0; i < 2 && (chunks = retrogenChunks.get((Object)dimension)) != null && chunks.size() > 0; ++i) {
                ++counter;
                ChunkCoordIntPair loc = (ChunkCoordIntPair)chunks.get(0);
                long worldSeed = event.world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)loc.field_77276_a + zSeed * (long)loc.field_77275_b ^ worldSeed);
                this.generateOres(fmlRandom, loc.field_77276_a, loc.field_77275_b, event.world, false);
                chunks.remove(0);
            }
        }
        if (counter > 0 && Config.getBoolean("retrogen_log_remaining")) {
            IELogger.info("Retrogen was performed on " + counter + " Chunks, " + Math.max(0, chunks.size()) + " chunks remaining");
        }
    }

    public static class OreGen {
        String name;
        WorldGenMinable mineableGen;
        int minY;
        int maxY;
        int chunkOccurence;
        int weight;

        public OreGen(String name, IBlockState state, int maxVeinSize, Block replaceTarget, int minY, int maxY, int chunkOccurence, int weight) {
            this.name = name;
            this.mineableGen = new WorldGenMinable(state, maxVeinSize, (Predicate)BlockHelper.func_177642_a((Block)replaceTarget));
            this.minY = minY;
            this.maxY = maxY;
            this.chunkOccurence = chunkOccurence;
            this.weight = weight;
        }

        public void generate(World world, Random rand, int x, int z) {
            for (int i = 0; i < this.chunkOccurence; ++i) {
                if (rand.nextInt(100) >= this.weight) continue;
                BlockPos pos = new BlockPos(x + rand.nextInt(16), this.minY + rand.nextInt(this.maxY - this.minY), z + rand.nextInt(16));
                this.mineableGen.func_180709_b(world, rand, pos);
            }
        }
    }
}

