/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.core;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import stevekung.mods.indicatia.command.CommandAFK;
import stevekung.mods.indicatia.command.CommandAutoClick;
import stevekung.mods.indicatia.command.CommandAutoLogin;
import stevekung.mods.indicatia.command.CommandChangeLog;
import stevekung.mods.indicatia.command.CommandHideName;
import stevekung.mods.indicatia.command.CommandIndicatia;
import stevekung.mods.indicatia.command.CommandMojangStatusCheck;
import stevekung.mods.indicatia.command.CommandProfile;
import stevekung.mods.indicatia.command.CommandSlimeChunkSeed;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.handler.CapeRendererHandler;
import stevekung.mods.indicatia.handler.CommonHandler;
import stevekung.mods.indicatia.handler.HUDRenderHandler;
import stevekung.mods.indicatia.handler.KeyBindingHandler;
import stevekung.mods.indicatia.handler.PlayerChatHandler;
import stevekung.mods.indicatia.profile.RenderProfileConfig;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.RenderPlayerNew;
import stevekung.mods.indicatia.util.CCMDHandler;
import stevekung.mods.indicatia.util.CapeUtil;
import stevekung.mods.indicatia.util.GameProfileUtil;
import stevekung.mods.indicatia.util.JsonUtil;
import stevekung.mods.indicatia.util.ModLogger;
import stevekung.mods.indicatia.util.VersionChecker;

@Mod(modid="indicatia", name="Indicatia", version="1.1.8", dependencies="after:Forge@[10.13.4.1614,);", guiFactory="stevekung.mods.indicatia.config.ConfigGuiFactory")
public class IndicatiaMod {
    public static final String NAME = "Indicatia";
    public static final String MOD_ID = "indicatia";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    public static final int BUILD_VERSION = 8;
    public static final String VERSION = "1.1.8";
    public static final String MC_VERSION = String.valueOf(FMLInjectionData.data()[4]);
    public static final String GUI_FACTORY = "stevekung.mods.indicatia.config.ConfigGuiFactory";
    public static final String FORGE_VERSION = "after:Forge@[10.13.4.1614,);";
    public static final String URL = "https://minecraft.curseforge.com/projects/indicatia";
    private static boolean DEOBFUSCATED;
    public static Minecraft MC;
    public static boolean CHECK_NO_CONNECTION;
    public static boolean SHOW_ANNOUNCE_MESSAGE;
    public static boolean FOUND_LATEST;
    public static ColoredFontRenderer coloredFontRenderer;
    public static JsonUtil json;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IndicatiaMod.init(event.getModMetadata());
        ConfigManager.init(new File(event.getModConfigurationDirectory(), "indicatia.cfg"));
        KeyBindingHandler.init();
        ExtendedConfig.load();
        RenderProfileConfig.load();
        IndicatiaMod.registerForgeEvent(new HUDRenderHandler(MC));
        IndicatiaMod.registerForgeEvent(new CommonHandler(MC));
        IndicatiaMod.registerForgeEvent(new PlayerChatHandler(MC));
        IndicatiaMod.registerForgeEvent(new CapeRendererHandler());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandMojangStatusCheck());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandChangeLog());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutoLogin());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSlimeChunkSeed());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAFK());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandIndicatia());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandProfile());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandHideName());
        if (IndicatiaMod.isSteveKunG()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutoClick());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ConfigManager.enableVersionChecker) {
            VersionChecker.startCheck();
        }
        CapeUtil.loadCapeTextureAtStartup();
        coloredFontRenderer = new ColoredFontRenderer(IndicatiaMod.MC.field_71474_y, new ResourceLocation("textures/font/ascii.png"), IndicatiaMod.MC.field_71446_o, false);
        ((IReloadableResourceManager)MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)coloredFontRenderer);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayer.class, (Render)new RenderPlayerNew());
    }

    public static boolean isObfuscatedEnvironment() {
        return DEOBFUSCATED;
    }

    public static boolean isSteveKunG() {
        return GameProfileUtil.getUsername().equals("SteveKunG") && GameProfileUtil.getUUID().equals(UUID.fromString("eef3a603-1c1b-4c98-8264-d2f04b231ef4")) || IndicatiaMod.isObfuscatedEnvironment();
    }

    public static void registerForgeEvent(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
        FMLCommonHandler.instance().bus().register(obj);
    }

    public static void unregisterForgeEvent(Object obj) {
        MinecraftForge.EVENT_BUS.unregister(obj);
        FMLCommonHandler.instance().bus().unregister(obj);
    }

    private static void init(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.description = "Simple in-game info and utility!";
        info.url = URL;
        info.authorList = Arrays.asList("SteveKunG");
    }

    private static void overrideClientCommandHandler() {
        try {
            Field field = ClientCommandHandler.class.getDeclaredField("instance");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(ClientCommandHandler.class.cast(ClientCommandHandler.instance), (Object)new CCMDHandler());
            ModLogger.info("Successfully replacing {} instance", ClientCommandHandler.class.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            ModLogger.error("Couldn't replace {} instance!", ClientCommandHandler.class.getName());
        }
    }

    static {
        try {
            DEOBFUSCATED = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MC = Minecraft.func_71410_x();
        json = new JsonUtil();
        IndicatiaMod.overrideClientCommandHandler();
    }
}

