/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import org.lwjgl.opengl.GL11;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.gui.GuiKeystrokeColorSettings;
import stevekung.mods.indicatia.gui.GuiRenderStatusSettings;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.HUDInfo;
import stevekung.mods.indicatia.renderer.KeystrokeRenderer;
import stevekung.mods.indicatia.util.HideNameData;
import stevekung.mods.indicatia.util.InfoUtil;
import stevekung.mods.indicatia.util.JsonUtil;
import stevekung.mods.indicatia.util.ModLogger;
import stevekung.mods.indicatia.util.RenderUtil;

public class HUDRenderHandler {
    private final Minecraft mc;
    public static boolean recordEnable;
    private int recTick;
    private static int readFileTicks;
    public static String topDonator;
    public static String recentDonator;
    private static String topDonatorName;
    private static String topDonatorCount;
    private static String recentDonatorName;
    private static String recentDonatorCount;
    private static final DecimalFormat tpsFormat;

    public HUDRenderHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++readFileTicks;
            this.recTick = recordEnable ? ++this.recTick : 0;
            if (!ExtendedConfig.TOP_DONATOR_FILE_PATH.isEmpty()) {
                HUDRenderHandler.readTopDonatorFile();
            } else {
                topDonator = "";
            }
            if (!ExtendedConfig.RECENT_DONATOR_FILE_PATH.isEmpty()) {
                HUDRenderHandler.readRecentDonatorFile();
            } else {
                recentDonator = "";
            }
        }
    }

    @SubscribeEvent
    public void onPreInfoRender(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            if (ConfigManager.enableRenderInfo && !this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P && this.mc.field_71439_g != null) {
                float yOffset;
                String string;
                int i;
                ArrayList<String> leftInfo = new ArrayList<String>();
                ArrayList<String> rightInfo = new ArrayList<String>();
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (ConfigManager.enablePing && !this.mc.func_71356_B()) {
                    leftInfo.add(HUDInfo.getPing());
                    if (ConfigManager.enablePingToSecond) {
                        leftInfo.add(HUDInfo.getPingToSecond());
                    }
                }
                if (ConfigManager.enableFPS) {
                    leftInfo.add(HUDInfo.getFPS());
                }
                if (ConfigManager.enableXYZ) {
                    leftInfo.add(HUDInfo.getXYZ(this.mc));
                    if (this.mc.field_71439_g.field_71093_bK == -1) {
                        leftInfo.add(HUDInfo.getOverworldXYZFromNether(this.mc));
                    }
                }
                if (ConfigManager.enableDirection) {
                    leftInfo.add(HUDInfo.renderDirection(this.mc));
                }
                if (ConfigManager.enableBiome) {
                    leftInfo.add(HUDInfo.getBiome(this.mc));
                }
                if (ConfigManager.enableServerIP && this.mc.func_147104_D() != null && !this.mc.func_71356_B()) {
                    leftInfo.add(HUDInfo.getServerIP(this.mc));
                }
                if (ConfigManager.enableSlimeChunkFinder && this.mc.field_71439_g.field_71093_bK == 0) {
                    String isSlimeChunk = InfoUtil.INSTANCE.isSlimeChunk(MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v)) ? "Yes" : "No";
                    leftInfo.add("Slime Chunk: " + isSlimeChunk);
                }
                if (ExtendedConfig.CPS_POSITION.equals("left")) {
                    if (ConfigManager.enableCPS) {
                        leftInfo.add(HUDInfo.getCPS());
                    }
                    if (ConfigManager.enableRCPS) {
                        leftInfo.add(HUDInfo.getRCPS());
                    }
                }
                if (ConfigManager.donatorMessagePosition.equals("left")) {
                    String text;
                    if (!topDonator.isEmpty()) {
                        text = ExtendedConfig.TOP_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.TOP_DONATOR_TEXT + EnumChatFormatting.RESET + " ";
                        leftInfo.add(text + topDonator);
                    }
                    if (!recentDonator.isEmpty()) {
                        text = ExtendedConfig.RECENT_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.RECENT_DONATOR_TEXT + EnumChatFormatting.RESET + " ";
                        leftInfo.add(text + recentDonator);
                    }
                }
                if (ConfigManager.enableServerTPS && server != null) {
                    int dimension = this.mc.field_71439_g.field_71093_bK;
                    double overallTPS = (double)HUDRenderHandler.mean(server.field_71311_j) * 1.0E-6;
                    double dimensionTPS = (double)HUDRenderHandler.mean((long[])server.worldTickTimes.get(dimension)) * 1.0E-6;
                    double tps = Math.min(1000.0 / overallTPS, 20.0);
                    leftInfo.add("Overall TPS: " + tpsFormat.format(overallTPS));
                    leftInfo.add("Dimension " + dimension + " TPS: " + tpsFormat.format(dimensionTPS));
                    leftInfo.add("TPS: " + tpsFormat.format(tps));
                }
                if (ConfigManager.enableCurrentRealTime) {
                    rightInfo.add(HUDInfo.getCurrentTime());
                }
                if (ConfigManager.enableCurrentGameTime) {
                    rightInfo.add(HUDInfo.getCurrentGameTime(this.mc));
                }
                if (ConfigManager.enableGameWeather && this.mc.field_71441_e.func_72896_J()) {
                    rightInfo.add(HUDInfo.getGameWeather(this.mc));
                }
                if (ConfigManager.enableMoonPhase) {
                    rightInfo.add(InfoUtil.INSTANCE.getMoonPhase(this.mc));
                }
                if (ExtendedConfig.CPS_POSITION.equals("right")) {
                    if (ConfigManager.enableCPS) {
                        rightInfo.add(HUDInfo.getCPS());
                    }
                    if (ConfigManager.enableRCPS) {
                        rightInfo.add(HUDInfo.getRCPS());
                    }
                }
                if (ConfigManager.donatorMessagePosition.equals("right")) {
                    if (!topDonator.isEmpty()) {
                        String text = ExtendedConfig.TOP_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.TOP_DONATOR_TEXT + EnumChatFormatting.RESET + " ";
                        rightInfo.add(text + topDonator);
                    }
                    if (!recentDonator.isEmpty()) {
                        String text = ExtendedConfig.RECENT_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.RECENT_DONATOR_TEXT + EnumChatFormatting.RESET + " ";
                        rightInfo.add(text + recentDonator);
                    }
                }
                if (ConfigManager.enableRenderEquippedItem) {
                    if (ConfigManager.equipmentPosition.equals("hotbar")) {
                        HUDInfo.renderHotbarEquippedItems(this.mc);
                    } else if (ConfigManager.equipmentDirection.equals("vertical")) {
                        HUDInfo.renderVerticalEquippedItems(this.mc);
                    } else {
                        HUDInfo.renderHorizontalEquippedItems(this.mc);
                    }
                }
                if (ConfigManager.enablePotionStatusHUD) {
                    HUDInfo.renderPotionStatusHUD(this.mc);
                }
                for (i = 0; i < leftInfo.size(); ++i) {
                    ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                    string = (String)leftInfo.get(i);
                    float fontHeight = IndicatiaMod.coloredFontRenderer.field_78288_b + 1;
                    yOffset = 3.0f + fontHeight * (float)i;
                    float xOffset = res.func_78326_a() - 2 - IndicatiaMod.coloredFontRenderer.func_78256_a(string);
                    if (string.isEmpty()) continue;
                    this.mc.field_71424_I.func_76320_a("indicatia_info");
                    IndicatiaMod.coloredFontRenderer.func_85187_a(string, ConfigManager.swapRenderInfoToRight ? (int)xOffset : 3, (int)yOffset, 0xFFFFFF, true);
                    this.mc.field_71424_I.func_76319_b();
                }
                for (i = 0; i < rightInfo.size(); ++i) {
                    ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                    string = (String)rightInfo.get(i);
                    float fontHeight = IndicatiaMod.coloredFontRenderer.field_78288_b + 1;
                    yOffset = 3.0f + fontHeight * (float)i;
                    float xOffset = res.func_78326_a() - 2 - IndicatiaMod.coloredFontRenderer.func_78256_a(string);
                    if (string.isEmpty()) continue;
                    this.mc.field_71424_I.func_76320_a("indicatia_info");
                    IndicatiaMod.coloredFontRenderer.func_85187_a(string, ConfigManager.swapRenderInfoToRight ? 3 : (int)xOffset, (int)yOffset, 0xFFFFFF, true);
                    this.mc.field_71424_I.func_76319_b();
                }
            }
            if (recordEnable) {
                ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                int color = 0xFFFFFF;
                if (this.recTick % 24 >= 0 && this.recTick % 24 <= 12) {
                    color = 0xFF5555;
                }
                IndicatiaMod.coloredFontRenderer.func_85187_a("REC: " + StringUtils.func_76337_a((int)this.recTick), res.func_78326_a() - IndicatiaMod.coloredFontRenderer.func_78256_a("REC: " + StringUtils.func_76337_a((int)this.recTick)) - 2, res.func_78328_b() - 10, color, true);
            }
            if (!this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P) {
                if (ConfigManager.enableKeystroke && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiChat || this.mc.field_71462_r instanceof GuiRenderStatusSettings || this.mc.field_71462_r instanceof GuiKeystrokeColorSettings)) {
                    KeystrokeRenderer.init(this.mc);
                }
                if (ConfigManager.enableRenderInfo && ExtendedConfig.CPS_POSITION.equalsIgnoreCase("custom") && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiChat || this.mc.field_71462_r instanceof GuiRenderStatusSettings || this.mc.field_71462_r instanceof GuiKeystrokeColorSettings)) {
                    String space = ConfigManager.enableRCPS ? " " : "";
                    RenderUtil.drawRect(ExtendedConfig.CPS_X_OFFSET, ExtendedConfig.CPS_Y_OFFSET, ExtendedConfig.CPS_X_OFFSET + this.mc.field_71466_p.func_78256_a(HUDInfo.getCPS() + space + HUDInfo.getRCPS()) + 4, ExtendedConfig.CPS_Y_OFFSET + 11, 0x1000000, ExtendedConfig.CPS_OPACITY);
                    this.mc.field_71466_p.func_85187_a(HUDInfo.getCPS() + space + HUDInfo.getRCPS(), ExtendedConfig.CPS_X_OFFSET + 2, ExtendedConfig.CPS_Y_OFFSET + 2, 0xFFFFFF, true);
                }
            }
        }
        if (event.type == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
            ScoreObjective scoreobjective = this.mc.field_71441_e.func_96441_U().func_96539_a(0);
            NetHandlerPlayClient handler = this.mc.field_71439_g.field_71174_a;
            List players = handler.field_147303_b;
            int maxPlayers = handler.field_147304_c;
            int width = event.resolution.func_78326_a();
            if (this.mc.field_71474_y.field_74321_H.func_151470_d() && (!this.mc.func_71387_A() || handler.field_147303_b.size() > 1 || scoreobjective != null)) {
                int rows = maxPlayers;
                int columns = 1;
                columns = 1;
                while (rows > 20) {
                    rows = (maxPlayers + ++columns - 1) / columns;
                }
                int columnWidth = 300 / columns;
                if (columnWidth > 150) {
                    columnWidth = 150;
                }
                int left = (width - columns * columnWidth) / 2;
                int border = 10;
                Gui.func_73734_a((int)(left - 1), (int)(border - 1), (int)(left + columnWidth * columns), (int)(border + 9 * rows), (int)Integer.MIN_VALUE);
                for (int i = 0; i < maxPlayers; ++i) {
                    int endX;
                    int maxX;
                    int xPos = left + i % columns * columnWidth;
                    int yPos = border + i / columns * 9;
                    Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + columnWidth - 1), (int)(yPos + 8), (int)0x20FFFFFF);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3008);
                    if (i >= players.size()) continue;
                    GuiPlayerInfo player = (GuiPlayerInfo)players.get(i);
                    ScorePlayerTeam team = this.mc.field_71441_e.func_96441_U().func_96509_i(player.field_78831_a);
                    String displayName = ScorePlayerTeam.func_96667_a((Team)team, (String)player.field_78831_a);
                    for (String hide : HideNameData.getHideNameList()) {
                        if (!displayName.contains(hide)) continue;
                        displayName = displayName.replace(hide, EnumChatFormatting.OBFUSCATED + hide + EnumChatFormatting.RESET);
                    }
                    IndicatiaMod.coloredFontRenderer.func_78261_a(displayName, xPos, yPos, 0xFFFFFF);
                    if (scoreobjective != null && (maxX = xPos + columnWidth - 12 - 5) - (endX = xPos + IndicatiaMod.coloredFontRenderer.func_78256_a(displayName) + 5) > 5) {
                        Score score = scoreobjective.func_96682_a().func_96529_a(player.field_78831_a, scoreobjective);
                        String scoreDisplay = EnumChatFormatting.YELLOW + "" + score.func_96652_c();
                        IndicatiaMod.coloredFontRenderer.func_78261_a(scoreDisplay, maxX - IndicatiaMod.coloredFontRenderer.func_78256_a(scoreDisplay), yPos, 0xFFFFFF);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int ping = player.field_78829_b;
                    if (!ConfigManager.enableCustomPlayerList) {
                        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        int pingIndex = 4;
                        if (ping < 0) {
                            pingIndex = 5;
                        } else if (ping < 150) {
                            pingIndex = 0;
                        } else if (ping < 300) {
                            pingIndex = 1;
                        } else if (ping < 600) {
                            pingIndex = 2;
                        } else if (ping < 1000) {
                            pingIndex = 3;
                        }
                        this.mc.field_71456_v.field_73735_i = 100.0f;
                        this.mc.field_71456_v.func_73729_b(xPos + columnWidth - 12, yPos, 0, 176 + pingIndex * 8, 10, 8);
                        this.mc.field_71456_v.field_73735_i = -100.0f;
                        continue;
                    }
                    int color = 0x55FF55;
                    if (ping >= 200 && ping < 301) {
                        color = 0xFFFF55;
                    } else if (ping >= 300 && ping < 500) {
                        color = 0xFF5555;
                    } else if (ping >= 500) {
                        color = 0xAA0000;
                    }
                    IndicatiaMod.coloredFontRenderer.func_85187_a(String.valueOf(ping), xPos + columnWidth - 1 - IndicatiaMod.coloredFontRenderer.func_78256_a(String.valueOf(ping)), (int)((float)yPos + 0.5f), color, true);
                }
            }
        }
        if (event.type == RenderGameOverlayEvent.ElementType.CHAT && ConfigManager.enableChatDepthRender) {
            event.setCanceled(true);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(event.resolution.func_78328_b() - 48), (float)0.0f);
            GL11.glDisable((int)2929);
            IndicatiaMod.MC.field_71456_v.func_146158_b().func_146230_a(IndicatiaMod.MC.field_71456_v.func_73834_c());
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
        if (event.type == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            event.setCanceled(true);
            GL11.glEnable((int)3042);
            if (BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0) {
                --BossStatus.field_82826_b;
                ColoredFontRenderer fontrenderer = IndicatiaMod.coloredFontRenderer;
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                int i = scaledresolution.func_78326_a();
                int short1 = 182;
                int j = i / 2 - short1 / 2;
                int k = (int)(BossStatus.field_82828_a * (float)(short1 + 1));
                int b0 = 12;
                if (ConfigManager.enableRenderBossHealthBar) {
                    this.mc.field_71456_v.func_73729_b(j, b0, 0, 74, short1, 5);
                    this.mc.field_71456_v.func_73729_b(j, b0, 0, 74, short1, 5);
                    if (k > 0) {
                        this.mc.field_71456_v.func_73729_b(j, b0, 0, 79, k, 5);
                    }
                }
                String s = BossStatus.field_82827_c;
                fontrenderer.func_78261_a(s, i / 2 - fontrenderer.func_78256_a(s) / 2, b0 - 10, 0xFFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            }
            GL11.glDisable((int)3042);
        }
    }

    @SubscribeEvent
    public void onRenderHealthStatus(RenderLivingEvent.Specials.Post event) {
        ChatStyle color;
        EntityLivingBase entity = event.entity;
        float health = entity.func_110143_aJ();
        boolean halfHealth = health <= entity.func_110138_aP() / 2.0f;
        boolean halfHealth1 = health <= entity.func_110138_aP() / 4.0f;
        float range = entity.func_70093_af() ? RendererLivingEntity.NAME_TAG_RANGE_SNEAK : RendererLivingEntity.NAME_TAG_RANGE;
        double distance = entity.func_70068_e((Entity)this.mc.field_71451_h);
        String mode = ConfigManager.healthStatusMode;
        boolean flag = mode.equals("disable") ? false : (mode.equals("pointed") ? entity == InfoUtil.INSTANCE.extendedPointedEntity : true);
        JsonUtil json = IndicatiaMod.json;
        ChatStyle chatStyle = halfHealth ? json.red() : (color = halfHealth1 ? json.darkRed() : json.green());
        if (distance < (double)(range * range) && !this.mc.field_71474_y.field_74319_N && !entity.func_82150_aj() && flag && !(entity instanceof EntityPlayerSP)) {
            String heart = json.text("\u2764 ").func_150255_a(color).func_150254_d();
            RenderUtil.renderEntityHealth(entity, heart + String.format("%.1f", Float.valueOf(health)), event.x, event.y, event.z);
        }
    }

    private static void readTopDonatorFile() {
        File file = new File("/" + ExtendedConfig.TOP_DONATOR_FILE_PATH);
        String text = "";
        if (readFileTicks % ConfigManager.readFileInterval == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    text = line.replace("\r", "");
                }
                String[] textSplit = text.split(" ");
                topDonatorName = textSplit[0];
                topDonatorCount = textSplit[1];
            }
            catch (Exception e) {
                ModLogger.error("Couldn't read text file from path {}", file.getPath());
                e.printStackTrace();
                topDonator = EnumChatFormatting.RED + "Cannot read text file!";
            }
        }
        topDonator = ColoredFontRenderer.color(ExtendedConfig.TOP_DONATE_NAME_COLOR_R, ExtendedConfig.TOP_DONATE_NAME_COLOR_G, ExtendedConfig.TOP_DONATE_NAME_COLOR_B) + topDonatorName + ColoredFontRenderer.color(ExtendedConfig.TOP_DONATE_COUNT_COLOR_R, ExtendedConfig.TOP_DONATE_COUNT_COLOR_G, ExtendedConfig.TOP_DONATE_COUNT_COLOR_B) + " " + topDonatorCount.replace("THB", "") + "THB";
    }

    private static void readRecentDonatorFile() {
        File file = new File("/" + ExtendedConfig.RECENT_DONATOR_FILE_PATH);
        String text = "";
        if (readFileTicks % ConfigManager.readFileInterval == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    text = line.replace("\r", "");
                }
                String[] textSplit = text.split(" ");
                recentDonatorName = textSplit[0];
                recentDonatorCount = textSplit[1];
            }
            catch (Exception e) {
                ModLogger.error("Couldn't read text file from path {}", file.getPath());
                e.printStackTrace();
                recentDonator = EnumChatFormatting.RED + "Cannot read text file!";
            }
        }
        recentDonator = ColoredFontRenderer.color(ExtendedConfig.RECENT_DONATE_NAME_COLOR_R, ExtendedConfig.RECENT_DONATE_NAME_COLOR_G, ExtendedConfig.RECENT_DONATE_NAME_COLOR_B) + recentDonatorName + ColoredFontRenderer.color(ExtendedConfig.RECENT_DONATE_COUNT_COLOR_R, ExtendedConfig.RECENT_DONATE_COUNT_COLOR_G, ExtendedConfig.RECENT_DONATE_COUNT_COLOR_B) + " " + recentDonatorCount.replace("THB", "") + "THB";
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    static {
        topDonator = "";
        recentDonator = "";
        topDonatorName = "";
        topDonatorCount = "";
        recentDonatorName = "";
        recentDonatorCount = "";
        tpsFormat = new DecimalFormat("########0.00");
    }
}

