/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.util.AutoLogin;
import stevekung.mods.indicatia.util.AutoLoginFunction;
import stevekung.mods.indicatia.util.Base64Util;
import stevekung.mods.indicatia.util.GameProfileUtil;

public class PlayerChatHandler {
    private final Minecraft mc;

    public PlayerChatHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.mc.func_152344_a(() -> IndicatiaMod.registerForgeEvent(new PlayerRunCommandHandler()));
    }

    public class PlayerRunCommandHandler {
        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent event) {
            if (event.entity instanceof EntityClientPlayerMP) {
                EntityClientPlayerMP player = (EntityClientPlayerMP)event.entity;
                ServerData data = PlayerChatHandler.this.mc.func_147104_D();
                this.runAutoLoginCommand(player, data);
                this.runAutoLoginFunction((EntityPlayerSP)player, data);
                IndicatiaMod.unregisterForgeEvent(this);
            }
        }

        private void runAutoLoginCommand(EntityClientPlayerMP player, ServerData data) {
            if (data != null) {
                for (AutoLogin.AutoLoginData login : ExtendedConfig.loginData.getAutoLoginList()) {
                    if (!data.field_78845_b.equalsIgnoreCase(login.getServerIP()) || !GameProfileUtil.getUUID().equals(login.getUUID())) continue;
                    player.func_71165_d(login.getCommand() + Base64Util.decode(login.getValue()));
                }
            }
        }

        private void runAutoLoginFunction(EntityPlayerSP player, ServerData data) {
            if (data != null) {
                for (AutoLogin.AutoLoginData login : ExtendedConfig.loginData.getAutoLoginList()) {
                    if (!data.field_78845_b.equalsIgnoreCase(login.getServerIP()) || !GameProfileUtil.getUUID().equals(login.getUUID()) || login.getFunction().isEmpty()) continue;
                    AutoLoginFunction.functionValue = login.getFunction();
                    AutoLoginFunction.run = true;
                }
            }
        }
    }
}

