/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.profile;

import java.io.File;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.profile.ProfileData;
import stevekung.mods.indicatia.util.ModLogger;

public class RenderProfileConfig {
    public static ProfileData profileData = new ProfileData();
    private static final File FILE = new File(IndicatiaMod.MC.field_71412_D, "indicatia_profile.dat");

    public static void load() {
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)FILE);
            if (nbt == null) {
                return;
            }
            RenderProfileConfig.readProfileData(nbt.func_150295_c("ProfileData", 10));
            ModLogger.info("Loading profile data {}", FILE.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("ProfileData", (NBTBase)RenderProfileConfig.writeProfileData());
            CompressedStreamTools.func_74793_a((NBTTagCompound)nbt, (File)FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static NBTTagList writeProfileData() {
        NBTTagList list = new NBTTagList();
        for (ProfileData.ProfileSettingData login : profileData.getProfileList()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Name", login.getProfileName());
            nbt.func_74757_a("FPS", ((Boolean)login.getObjects()[0]).booleanValue());
            nbt.func_74757_a("XYZ", ((Boolean)login.getObjects()[1]).booleanValue());
            nbt.func_74757_a("Biome", ((Boolean)login.getObjects()[2]).booleanValue());
            nbt.func_74757_a("Ping", ((Boolean)login.getObjects()[3]).booleanValue());
            nbt.func_74757_a("IP", ((Boolean)login.getObjects()[4]).booleanValue());
            nbt.func_74757_a("Equipments", ((Boolean)login.getObjects()[5]).booleanValue());
            nbt.func_74757_a("PotionHUD", ((Boolean)login.getObjects()[6]).booleanValue());
            nbt.func_74757_a("Keystroke", ((Boolean)login.getObjects()[7]).booleanValue());
            nbt.func_74757_a("CPS", ((Boolean)login.getObjects()[8]).booleanValue());
            nbt.func_74757_a("RCPS", ((Boolean)login.getObjects()[9]).booleanValue());
            nbt.func_74757_a("SlimeChunk", ((Boolean)login.getObjects()[10]).booleanValue());
            nbt.func_74757_a("RealTime", ((Boolean)login.getObjects()[11]).booleanValue());
            nbt.func_74757_a("GameTime", ((Boolean)login.getObjects()[12]).booleanValue());
            nbt.func_74757_a("Weather", ((Boolean)login.getObjects()[13]).booleanValue());
            nbt.func_74757_a("MoonPhase", ((Boolean)login.getObjects()[14]).booleanValue());
            nbt.func_74778_a("KeystokePos", (String)login.getObjects()[15]);
            nbt.func_74778_a("EquipOrder", (String)login.getObjects()[16]);
            nbt.func_74778_a("EquipDirection", (String)login.getObjects()[17]);
            nbt.func_74778_a("EquipStatus", (String)login.getObjects()[18]);
            nbt.func_74778_a("EquipPos", (String)login.getObjects()[19]);
            nbt.func_74778_a("PotionStyle", (String)login.getObjects()[20]);
            nbt.func_74778_a("PotionPos", (String)login.getObjects()[21]);
            nbt.func_74768_a("ArmorOffset", ((Integer)login.getObjects()[22]).intValue());
            nbt.func_74768_a("PotionOffset", ((Integer)login.getObjects()[23]).intValue());
            nbt.func_74768_a("KeystrokeY", ((Integer)login.getObjects()[24]).intValue());
            nbt.func_74768_a("CPSX", ((Integer)login.getObjects()[25]).intValue());
            nbt.func_74768_a("CPSY", ((Integer)login.getObjects()[26]).intValue());
            nbt.func_74778_a("TopDonatePath", (String)login.getObjects()[27]);
            nbt.func_74778_a("RecentDonatePath", (String)login.getObjects()[28]);
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    private static void readProfileData(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            profileData.addProfileData(nbt.func_74779_i("Name"), nbt.func_74767_n("FPS"), nbt.func_74767_n("XYZ"), nbt.func_74767_n("Biome"), nbt.func_74767_n("Ping"), nbt.func_74767_n("IP"), nbt.func_74767_n("Equipments"), nbt.func_74767_n("PotionHUD"), nbt.func_74767_n("Keystroke"), nbt.func_74767_n("CPS"), nbt.func_74767_n("RCPS"), nbt.func_74767_n("SlimeChunk"), nbt.func_74767_n("RealTime"), nbt.func_74767_n("GameTime"), nbt.func_74767_n("Weather"), nbt.func_74767_n("MoonPhase"), nbt.func_74779_i("KeystokePos"), nbt.func_74779_i("EquipOrder"), nbt.func_74779_i("EquipDirection"), nbt.func_74779_i("EquipStatus"), nbt.func_74779_i("EquipPos"), nbt.func_74779_i("PotionStyle"), nbt.func_74779_i("PotionPos"), nbt.func_74762_e("ArmorOffset"), nbt.func_74762_e("PotionOffset"), nbt.func_74762_e("KeystrokeY"), nbt.func_74762_e("CPSX"), nbt.func_74762_e("CPSY"), nbt.func_74779_i("TopDonatePath"), nbt.func_74779_i("RecentDonatePath"));
        }
    }
}

