/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.renderer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.handler.CommonHandler;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.HorizontalEquipment;
import stevekung.mods.indicatia.util.InfoUtil;
import stevekung.mods.indicatia.util.LangUtil;

public class HUDInfo {
    private static final RenderItem renderItem = new RenderItem();
    private static final ResourceLocation inventoryBackground = new ResourceLocation("textures/gui/container/inventory.png");

    public static String getFPS() {
        int fps = Minecraft.field_71470_ab;
        String color = ColoredFontRenderer.color(ExtendedConfig.FPS_M40_COLOR_R, ExtendedConfig.FPS_M40_COLOR_G, ExtendedConfig.FPS_M40_COLOR_B);
        if (fps > 25 && fps <= 40) {
            color = ColoredFontRenderer.color(ExtendedConfig.FPS_26_40_COLOR_R, ExtendedConfig.FPS_26_40_COLOR_G, ExtendedConfig.FPS_26_40_COLOR_B);
        } else if (fps <= 25) {
            color = ColoredFontRenderer.color(ExtendedConfig.FPS_L25_COLOR_R, ExtendedConfig.FPS_L25_COLOR_G, ExtendedConfig.FPS_L25_COLOR_B);
        }
        return ColoredFontRenderer.color(ExtendedConfig.FPS_COLOR_R, ExtendedConfig.FPS_COLOR_G, ExtendedConfig.FPS_COLOR_B) + "FPS: " + color + fps;
    }

    public static String getXYZ(Minecraft mc) {
        int x = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
        int y = MathHelper.func_76128_c((double)mc.field_71439_g.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
        String nether = mc.field_71439_g.field_71093_bK == -1 ? "Nether " : "";
        return ColoredFontRenderer.color(ExtendedConfig.XYZ_COLOR_R, ExtendedConfig.XYZ_COLOR_G, ExtendedConfig.XYZ_COLOR_B) + nether + "XYZ: " + ColoredFontRenderer.color(ExtendedConfig.XYZ_VALUE_COLOR_R, ExtendedConfig.XYZ_VALUE_COLOR_G, ExtendedConfig.XYZ_VALUE_COLOR_B) + x + " " + y + " " + z;
    }

    public static String getOverworldXYZFromNether(Minecraft mc) {
        int x = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
        int y = MathHelper.func_76128_c((double)mc.field_71439_g.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
        return ColoredFontRenderer.color(ExtendedConfig.XYZ_COLOR_R, ExtendedConfig.XYZ_COLOR_G, ExtendedConfig.XYZ_COLOR_B) + "Overworld XYZ: " + ColoredFontRenderer.color(ExtendedConfig.XYZ_VALUE_COLOR_R, ExtendedConfig.XYZ_VALUE_COLOR_G, ExtendedConfig.XYZ_VALUE_COLOR_B) + x * 8 + " " + y + " " + z * 8;
    }

    public static String getBiome(Minecraft mc) {
        int x = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
        int y = MathHelper.func_76128_c((double)mc.field_71439_g.field_70163_u);
        int z = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
        if (mc.field_71441_e != null && mc.field_71441_e.func_72899_e(x, y, z)) {
            Chunk chunk = mc.field_71441_e.func_72938_d(x, z);
            if (!chunk.func_76621_g()) {
                String biomeName = chunk.func_76591_a((int)(x & 0xF), (int)(z & 0xF), (WorldChunkManager)mc.field_71441_e.func_72959_q()).field_76791_y.replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
                return ColoredFontRenderer.color(ExtendedConfig.BIOME_COLOR_R, ExtendedConfig.BIOME_COLOR_G, ExtendedConfig.BIOME_COLOR_B) + "Biome: " + ColoredFontRenderer.color(ExtendedConfig.BIOME_VALUE_COLOR_R, ExtendedConfig.BIOME_VALUE_COLOR_G, ExtendedConfig.BIOME_VALUE_COLOR_B) + biomeName;
            }
            return "Waiting for chunk...";
        }
        return "Outside of world...";
    }

    public static String getPing() {
        int responseTime = CommonHandler.currentServerPing;
        return ColoredFontRenderer.color(ExtendedConfig.PING_COLOR_R, ExtendedConfig.PING_COLOR_G, ExtendedConfig.PING_COLOR_B) + "Ping: " + HUDInfo.getResponseTimeColor(responseTime) + responseTime + "ms";
    }

    public static String getPingToSecond() {
        double responseTime = (double)CommonHandler.currentServerPing / 1000.0;
        return ColoredFontRenderer.color(ExtendedConfig.PING_COLOR_R, ExtendedConfig.PING_COLOR_G, ExtendedConfig.PING_COLOR_B) + "Delay: " + HUDInfo.getResponseTimeColor((int)(responseTime * 1000.0)) + responseTime + "s";
    }

    public static String getServerIP(Minecraft mc) {
        String ip = ColoredFontRenderer.color(ExtendedConfig.IP_COLOR_R, ExtendedConfig.IP_COLOR_G, ExtendedConfig.IP_COLOR_B) + "IP: " + ColoredFontRenderer.color(ExtendedConfig.IP_VALUE_COLOR_R, ExtendedConfig.IP_VALUE_COLOR_G, ExtendedConfig.IP_VALUE_COLOR_B) + mc.func_147104_D().field_78845_b;
        if (ConfigManager.enableServerIPMCVersion) {
            ip = ip + "/" + IndicatiaMod.MC_VERSION;
        }
        return ip;
    }

    public static String renderDirection(Minecraft mc) {
        String direction;
        int facing;
        EntityLivingBase entity = mc.field_71451_h;
        int yaw = (int)entity.field_70177_z + 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        if ((facing = yaw / 45) < 0) {
            facing = 7;
        }
        switch (facing) {
            case 0: {
                direction = "South";
                break;
            }
            case 1: {
                direction = "South West";
                break;
            }
            case 2: {
                direction = "West";
                break;
            }
            case 3: {
                direction = "North West";
                break;
            }
            case 4: {
                direction = "North";
                break;
            }
            case 5: {
                direction = "North East";
                break;
            }
            case 6: {
                direction = "East";
                break;
            }
            case 7: {
                direction = "South East";
                break;
            }
            default: {
                direction = "Unknown";
            }
        }
        return ColoredFontRenderer.color(ExtendedConfig.DIRECTION_COLOR_R, ExtendedConfig.DIRECTION_COLOR_G, ExtendedConfig.DIRECTION_COLOR_B) + "Direction: " + ColoredFontRenderer.color(ExtendedConfig.DIRECTION_VALUE_COLOR_R, ExtendedConfig.DIRECTION_VALUE_COLOR_G, ExtendedConfig.DIRECTION_VALUE_COLOR_B) + direction;
    }

    public static String getCPS() {
        return ColoredFontRenderer.color(ExtendedConfig.CPS_COLOR_R, ExtendedConfig.CPS_COLOR_G, ExtendedConfig.CPS_COLOR_B) + "CPS: " + ColoredFontRenderer.color(ExtendedConfig.CPS_VALUE_COLOR_R, ExtendedConfig.CPS_VALUE_COLOR_G, ExtendedConfig.CPS_VALUE_COLOR_B) + InfoUtil.INSTANCE.getCPS();
    }

    public static String getRCPS() {
        return ColoredFontRenderer.color(ExtendedConfig.RCPS_COLOR_R, ExtendedConfig.RCPS_COLOR_G, ExtendedConfig.RCPS_COLOR_B) + "RCPS: " + ColoredFontRenderer.color(ExtendedConfig.RCPS_VALUE_COLOR_R, ExtendedConfig.RCPS_VALUE_COLOR_G, ExtendedConfig.RCPS_VALUE_COLOR_B) + InfoUtil.INSTANCE.getRCPS();
    }

    public static String getCurrentTime() {
        String currentTime = new SimpleDateFormat("d/M/yyyy HH:mm:ss a", Locale.ENGLISH).format(new Date());
        currentTime = "Time: " + currentTime.replace("\u0e2b\u0e25\u0e31\u0e07\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", "PM").replace("\u0e01\u0e48\u0e2d\u0e19\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", "AM");
        return currentTime;
    }

    public static String getCurrentGameTime(Minecraft mc) {
        return InfoUtil.INSTANCE.getCurrentGameTime(mc.field_71441_e.func_72820_D() % 24000L);
    }

    public static String getGameWeather(Minecraft mc) {
        String weather = mc.field_71441_e.func_72896_J() && !mc.field_71441_e.func_72911_I() ? "Raining" : (mc.field_71441_e.func_72896_J() && mc.field_71441_e.func_72911_I() ? "Thunder" : "");
        return "Weather: " + weather;
    }

    public static void renderHorizontalEquippedItems(Minecraft mc) {
        String ordering = ConfigManager.equipmentOrdering;
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        boolean isRightSide = ConfigManager.equipmentPosition.equals("right");
        int baseXOffset = 2;
        int baseYOffset = ExtendedConfig.ARMOR_STATUS_OFFSET;
        ItemStack mainHandItem = mc.field_71439_g.func_71045_bC();
        ArrayList<HorizontalEquipment> element = new ArrayList<HorizontalEquipment>();
        int prevX = 0;
        int rightWidth = 0;
        element.clear();
        if (ordering.equals("reverse") && mainHandItem != null) {
            element.add(new HorizontalEquipment(mainHandItem, false));
        }
        switch (ordering) {
            case "default": {
                int i;
                for (i = 3; i >= 0; --i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    element.add(new HorizontalEquipment(mc.field_71439_g.field_71071_by.field_70460_b[i], mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f()));
                }
                break;
            }
            case "reverse": {
                int i;
                for (i = 0; i <= 3; ++i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    element.add(new HorizontalEquipment(mc.field_71439_g.field_71071_by.field_70460_b[i], mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f()));
                }
                break;
            }
        }
        if (ordering.equals("default") && mainHandItem != null) {
            element.add(new HorizontalEquipment(mainHandItem, false));
        }
        for (HorizontalEquipment equipment : element) {
            rightWidth += equipment.getWidth();
        }
        for (HorizontalEquipment equipment : element) {
            int xBaseRight = res.func_78326_a() - rightWidth - baseXOffset;
            equipment.render(isRightSide ? xBaseRight + prevX + equipment.getWidth() : baseXOffset + prevX, baseYOffset);
            prevX += equipment.getWidth();
        }
    }

    public static void renderVerticalEquippedItems(Minecraft mc) {
        String string;
        int i;
        String itemCount;
        String ordering = ConfigManager.equipmentOrdering;
        String status = ConfigManager.equipmentStatus;
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        ArrayList<String> itemStatusList = new ArrayList<String>();
        ArrayList<String> arrowCountList = new ArrayList<String>();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        boolean isRightSide = ConfigManager.equipmentPosition.equals("right");
        int baseXOffset = isRightSide ? res.func_78326_a() - 18 : 2;
        int baseYOffset = ExtendedConfig.ARMOR_STATUS_OFFSET;
        ItemStack mainHandItem = mc.field_71439_g.func_70694_bm();
        int arrowCount = HUDInfo.getInventoryArrowCount(mc.field_71439_g.field_71071_by);
        if (ordering.equals("reverse") && mainHandItem != null) {
            itemStackList.add(mainHandItem);
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
            itemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount))));
            if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                arrowCountList.add("");
            }
        }
        switch (ordering) {
            case "default": {
                String itemCount2;
                for (i = 3; i >= 0; --i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i], Integer.parseInt(itemCount2)));
                    arrowCountList.add("");
                }
                break;
            }
            case "reverse": {
                String itemCount2;
                for (i = 0; i <= 3; ++i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i], Integer.parseInt(itemCount2)));
                    arrowCountList.add("");
                }
                break;
            }
        }
        if (ordering.equals("default") && mainHandItem != null) {
            itemStackList.add(mainHandItem);
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
            itemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount))));
            if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                arrowCountList.add("");
            }
        }
        for (int i2 = 0; i2 < itemStackList.size(); ++i2) {
            ItemStack itemStack = (ItemStack)itemStackList.get(i2);
            mc.field_71424_I.func_76320_a("item_stack_render");
            if (!itemStackList.isEmpty()) {
                int yOffset = baseYOffset + 16 * i2;
                HUDInfo.renderItem(itemStack, baseXOffset, yOffset);
                yOffset += 16;
            }
            mc.field_71424_I.func_76319_b();
        }
        float yOffset = 0.0f;
        float fontHeight = 0.0f;
        for (i = 0; i < itemStatusList.size(); ++i) {
            string = (String)itemStatusList.get(i);
            fontHeight = (float)IndicatiaMod.coloredFontRenderer.field_78288_b + 7.0625f;
            if (string.isEmpty()) continue;
            yOffset = (float)(baseYOffset + 4) + fontHeight * (float)i;
            mc.field_71424_I.func_76320_a("armor_durability_info");
            float xOffset = isRightSide ? (float)(res.func_78326_a() - mc.field_71466_p.func_78256_a(string)) - 20.0625f : (float)baseXOffset + 18.0625f;
            IndicatiaMod.coloredFontRenderer.func_85187_a(ColoredFontRenderer.color(ExtendedConfig.EQUIPMENT_COLOR_R, ExtendedConfig.EQUIPMENT_COLOR_G, ExtendedConfig.EQUIPMENT_COLOR_B) + string, (int)xOffset, (int)yOffset, 0xFFFFFF, true);
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < arrowCountList.size(); ++i) {
            string = (String)arrowCountList.get(i);
            yOffset = (float)(baseYOffset + 8) + fontHeight * (float)i;
            if (string.isEmpty()) continue;
            mc.field_71424_I.func_76320_a("arrow_count");
            GL11.glDisable((int)2929);
            IndicatiaMod.coloredFontRenderer.func_78264_a(true);
            IndicatiaMod.coloredFontRenderer.func_85187_a(ColoredFontRenderer.color(ExtendedConfig.ARROW_COUNT_COLOR_R, ExtendedConfig.ARROW_COUNT_COLOR_G, ExtendedConfig.ARROW_COUNT_COLOR_B) + string, (int)(isRightSide ? (float)(res.func_78326_a() - mc.field_71466_p.func_78256_a(string)) - 2.0625f : (float)baseXOffset + 8.0625f), (int)yOffset, 0xFFFFFF, true);
            IndicatiaMod.coloredFontRenderer.func_78264_a(false);
            GL11.glEnable((int)2929);
            mc.field_71424_I.func_76319_b();
        }
    }

    public static void renderHotbarEquippedItems(Minecraft mc) {
        int yOffset;
        String string;
        int yOffset2;
        int baseXOffset;
        ItemStack itemStack;
        int i;
        String itemCount;
        int i2;
        ArrayList<ItemStack> leftItemStackList = new ArrayList<ItemStack>();
        ArrayList<String> leftItemStatusList = new ArrayList<String>();
        ArrayList<String> leftArrowCountList = new ArrayList<String>();
        ArrayList<ItemStack> rightItemStackList = new ArrayList<ItemStack>();
        ArrayList<String> rightItemStatusList = new ArrayList<String>();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        ItemStack mainHandItem = mc.field_71439_g.func_70694_bm();
        int arrowCount = HUDInfo.getInventoryArrowCount(mc.field_71439_g.field_71071_by);
        String status = ConfigManager.equipmentStatus;
        for (i2 = 2; i2 <= 3; ++i2) {
            if (mc.field_71439_g.field_71071_by.field_70460_b[i2] == null) continue;
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            leftItemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            leftItemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i2]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i2], Integer.parseInt(itemCount)));
            leftArrowCountList.add("");
        }
        for (i2 = 0; i2 <= 1; ++i2) {
            if (mc.field_71439_g.field_71071_by.field_70460_b[i2] == null) continue;
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            rightItemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            rightItemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i2]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i2], Integer.parseInt(itemCount)));
        }
        if (mainHandItem != null) {
            leftItemStackList.add(mainHandItem);
            String itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
            leftItemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount2))));
            if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                leftArrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                leftArrowCountList.add("");
            }
        }
        for (i = 0; i < leftItemStackList.size(); ++i) {
            itemStack = (ItemStack)leftItemStackList.get(i);
            mc.field_71424_I.func_76320_a("item_stack_render");
            if (!leftItemStackList.isEmpty()) {
                baseXOffset = res.func_78326_a() / 2 - 91 - 20;
                yOffset2 = res.func_78328_b() - 16 * i - 18;
                HUDInfo.renderItem(itemStack, baseXOffset, yOffset2);
            }
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < rightItemStackList.size(); ++i) {
            itemStack = (ItemStack)rightItemStackList.get(i);
            mc.field_71424_I.func_76320_a("item_stack_render");
            if (!rightItemStackList.isEmpty()) {
                baseXOffset = res.func_78326_a() / 2 + 95;
                yOffset2 = res.func_78328_b() - 16 * i - 18;
                HUDInfo.renderItem(itemStack, baseXOffset, yOffset2);
            }
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < leftItemStatusList.size(); ++i) {
            string = (String)leftItemStatusList.get(i);
            mc.field_71424_I.func_76320_a("armor_durability_info");
            int stringWidth = mc.field_71466_p.func_78256_a(string);
            float xOffset = res.func_78326_a() / 2 - 114 - stringWidth;
            yOffset = res.func_78328_b() - 16 * i - 14;
            IndicatiaMod.coloredFontRenderer.func_85187_a(ColoredFontRenderer.color(ExtendedConfig.EQUIPMENT_COLOR_R, ExtendedConfig.EQUIPMENT_COLOR_G, ExtendedConfig.EQUIPMENT_COLOR_B) + string, (int)xOffset, yOffset, 0xFFFFFF, true);
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < rightItemStatusList.size(); ++i) {
            string = (String)rightItemStatusList.get(i);
            mc.field_71424_I.func_76320_a("armor_durability_info");
            float xOffset = res.func_78326_a() / 2 + 114;
            int yOffset3 = res.func_78328_b() - 16 * i - 14;
            IndicatiaMod.coloredFontRenderer.func_85187_a(ColoredFontRenderer.color(ExtendedConfig.EQUIPMENT_COLOR_R, ExtendedConfig.EQUIPMENT_COLOR_G, ExtendedConfig.EQUIPMENT_COLOR_B) + string, (int)xOffset, yOffset3, 0xFFFFFF, true);
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < leftArrowCountList.size(); ++i) {
            string = (String)leftArrowCountList.get(i);
            int stringWidth = mc.field_71466_p.func_78256_a(string);
            float xOffset = res.func_78326_a() / 2 - 90 - stringWidth;
            yOffset = res.func_78328_b() - 16 * i - 10;
            if (string.isEmpty()) continue;
            mc.field_71424_I.func_76320_a("arrow_count");
            GL11.glDisable((int)2929);
            IndicatiaMod.coloredFontRenderer.func_78264_a(true);
            IndicatiaMod.coloredFontRenderer.func_85187_a(ColoredFontRenderer.color(ExtendedConfig.ARROW_COUNT_COLOR_R, ExtendedConfig.ARROW_COUNT_COLOR_G, ExtendedConfig.ARROW_COUNT_COLOR_B) + string, (int)xOffset, yOffset, 0xFFFFFF, true);
            IndicatiaMod.coloredFontRenderer.func_78264_a(false);
            GL11.glEnable((int)2929);
            mc.field_71424_I.func_76319_b();
        }
    }

    public static void renderPotionStatusHUD(Minecraft mc) {
        block28: {
            Collection collection;
            int lengthOverlap;
            int length;
            int size;
            ScaledResolution scaledRes;
            boolean showIcon;
            boolean iconAndTime;
            block30: {
                block29: {
                    if (!ConfigManager.enablePotionStatusHUD) break block28;
                    iconAndTime = ConfigManager.potionStatusHUDStyle.equals("icon_and_time");
                    showIcon = ConfigManager.enablePotionHUDIcon;
                    scaledRes = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                    size = ExtendedConfig.MAX_POTION_DISPLAY;
                    length = ExtendedConfig.POTION_LENGTH_Y_OFFSET;
                    lengthOverlap = ExtendedConfig.POTION_LENGTH_Y_OFFSET_OVERLAP;
                    collection = mc.field_71439_g.func_70651_bq();
                    if (!ConfigManager.potionStatusHUDPosition.equals("hotbar_left")) break block29;
                    int xPotion = scaledRes.func_78326_a() / 2 - 91 - 35;
                    int yPotion = scaledRes.func_78328_b() - 46;
                    if (collection.isEmpty()) break block28;
                    if (collection.size() > size) {
                        length = lengthOverlap / (collection.size() - 1);
                    }
                    for (PotionEffect potioneffect : mc.field_71439_g.func_70651_bq()) {
                        Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                        String s = Potion.func_76389_a((PotionEffect)potioneffect);
                        String s1 = LangUtil.translate(potion.func_76393_a());
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (showIcon) {
                            mc.func_110434_K().func_110577_a(inventoryBackground);
                            int i1 = potion.func_76392_e();
                            mc.field_71456_v.func_73729_b(xPotion + 12, yPotion + 6, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                        }
                        if (potioneffect.func_76458_c() == 1) {
                            s1 = s1 + " " + LangUtil.translate("enchantment.level.2");
                        } else if (potioneffect.func_76458_c() == 2) {
                            s1 = s1 + " " + LangUtil.translate("enchantment.level.3");
                        } else if (potioneffect.func_76458_c() == 3) {
                            s1 = s1 + " " + LangUtil.translate("enchantment.level.4");
                        }
                        int stringwidth1 = IndicatiaMod.coloredFontRenderer.func_78256_a(s);
                        int stringwidth2 = IndicatiaMod.coloredFontRenderer.func_78256_a(s1);
                        if (!iconAndTime) {
                            IndicatiaMod.coloredFontRenderer.func_85187_a(s1, showIcon ? xPotion + 8 - stringwidth2 : xPotion + 28 - stringwidth2, yPotion + 6, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                        }
                        IndicatiaMod.coloredFontRenderer.func_85187_a(s, showIcon ? xPotion + 8 - stringwidth1 : xPotion + 28 - stringwidth1, iconAndTime ? yPotion + 11 : yPotion + 16, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                        yPotion -= length;
                    }
                    break block28;
                }
                if (!ConfigManager.potionStatusHUDPosition.equals("hotbar_right")) break block30;
                int xPotion = scaledRes.func_78326_a() / 2 + 91 - 20;
                int yPotion = scaledRes.func_78328_b() - 42;
                if (collection.isEmpty()) break block28;
                if (collection.size() > size) {
                    length = lengthOverlap / (collection.size() - 1);
                }
                for (PotionEffect potioneffect : mc.field_71439_g.func_70651_bq()) {
                    Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                    String s = Potion.func_76389_a((PotionEffect)potioneffect);
                    String s1 = LangUtil.translate(potion.func_76393_a());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (showIcon) {
                        mc.func_110434_K().func_110577_a(inventoryBackground);
                        int i1 = potion.func_76392_e();
                        mc.field_71456_v.func_73729_b(xPotion + 24, yPotion + 6, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                    }
                    if (potioneffect.func_76458_c() == 1) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.2");
                    } else if (potioneffect.func_76458_c() == 2) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.3");
                    } else if (potioneffect.func_76458_c() == 3) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.4");
                    }
                    if (!iconAndTime) {
                        IndicatiaMod.coloredFontRenderer.func_85187_a(s1, showIcon ? xPotion + 46 : xPotion + 28, yPotion + 6, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    }
                    IndicatiaMod.coloredFontRenderer.func_85187_a(s, showIcon ? xPotion + 46 : xPotion + 28, iconAndTime ? yPotion + 11 : yPotion + 16, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    yPotion -= length;
                }
                break block28;
            }
            boolean right = ConfigManager.potionStatusHUDPosition.equals("right");
            int xPotion = right ? scaledRes.func_78326_a() - 32 : -24;
            int yPotion = scaledRes.func_78328_b() - 220 + ExtendedConfig.POTION_STATUS_OFFSET + 90;
            if (!collection.isEmpty()) {
                if (collection.size() > size) {
                    length = lengthOverlap / (collection.size() - 1);
                }
                for (PotionEffect potioneffect : mc.field_71439_g.func_70651_bq()) {
                    Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                    String s = Potion.func_76389_a((PotionEffect)potioneffect);
                    String s1 = LangUtil.translate(potion.func_76393_a());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (showIcon) {
                        mc.func_110434_K().func_110577_a(inventoryBackground);
                        int i1 = potion.func_76392_e();
                        mc.field_71456_v.func_73729_b(right ? xPotion + 12 : xPotion + 28, yPotion + 6, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                    }
                    if (potioneffect.func_76458_c() == 1) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.2");
                    } else if (potioneffect.func_76458_c() == 2) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.3");
                    } else if (potioneffect.func_76458_c() == 3) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.4");
                    }
                    int stringwidth1 = IndicatiaMod.coloredFontRenderer.func_78256_a(s);
                    int stringwidth2 = IndicatiaMod.coloredFontRenderer.func_78256_a(s1);
                    if (!iconAndTime) {
                        IndicatiaMod.coloredFontRenderer.func_85187_a(s1, right ? (showIcon ? xPotion + 8 - stringwidth2 : xPotion + 28 - stringwidth2) : (showIcon ? xPotion + 50 : xPotion + 28), yPotion + 6, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    }
                    IndicatiaMod.coloredFontRenderer.func_85187_a(s, right ? (showIcon ? xPotion + 8 - stringwidth1 : xPotion + 28 - stringwidth1) : (showIcon ? xPotion + 50 : xPotion + 28), iconAndTime ? yPotion + 11 : yPotion + 16, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    yPotion += length;
                }
            }
        }
    }

    static String getArmorDurabilityStatus(ItemStack itemStack) {
        String status;
        switch (status = ConfigManager.equipmentStatus) {
            default: {
                return itemStack.func_77958_k() - itemStack.func_77960_j() + "/" + itemStack.func_77958_k();
            }
            case "percent": {
                return HUDInfo.calculateItemDurabilityPercent(itemStack) + "%";
            }
            case "damage": {
                return String.valueOf(itemStack.func_77958_k() - itemStack.func_77960_j());
            }
            case "none": 
        }
        return "";
    }

    private static int calculateItemDurabilityPercent(ItemStack itemStack) {
        return itemStack.func_77958_k() <= 0 ? 0 : 100 - itemStack.func_77960_j() * 100 / itemStack.func_77958_k();
    }

    private static String getResponseTimeColor(int responseTime) {
        if (responseTime >= 200 && responseTime < 300) {
            return ColoredFontRenderer.color(ExtendedConfig.PING_200_300_COLOR_R, ExtendedConfig.PING_200_300_COLOR_G, ExtendedConfig.PING_200_300_COLOR_B);
        }
        if (responseTime >= 300 && responseTime < 500) {
            return ColoredFontRenderer.color(ExtendedConfig.PING_300_500_COLOR_R, ExtendedConfig.PING_300_500_COLOR_G, ExtendedConfig.PING_300_500_COLOR_B);
        }
        if (responseTime >= 500) {
            return ColoredFontRenderer.color(ExtendedConfig.PING_M500_COLOR_R, ExtendedConfig.PING_M500_COLOR_G, ExtendedConfig.PING_M500_COLOR_B);
        }
        return ColoredFontRenderer.color(ExtendedConfig.PING_L200_COLOR_R, ExtendedConfig.PING_L200_COLOR_G, ExtendedConfig.PING_L200_COLOR_B);
    }

    static void renderItem(ItemStack itemStack, int x, int y) {
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        renderItem.func_82406_b((FontRenderer)IndicatiaMod.coloredFontRenderer, IndicatiaMod.MC.func_110434_K(), itemStack, x, y);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        RenderHelper.func_74518_a();
        if (itemStack.func_77984_f()) {
            RenderHelper.func_74520_c();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)2884);
            renderItem.func_77021_b((FontRenderer)IndicatiaMod.coloredFontRenderer, IndicatiaMod.MC.func_110434_K(), itemStack, x, y);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
        }
        GL11.glBlendFunc((int)770, (int)771);
    }

    static String getInventoryItemCount(InventoryPlayer inventory, ItemStack other) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack playerItems = inventory.func_70301_a(i);
            if (playerItems == null || playerItems.func_77973_b() != other.func_77973_b() || playerItems.func_77960_j() != other.func_77960_j() || !ItemStack.func_77970_a((ItemStack)playerItems, (ItemStack)other)) continue;
            count += playerItems.field_77994_a;
        }
        return String.valueOf(count);
    }

    static int getInventoryArrowCount(InventoryPlayer inventory) {
        int arrowCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.func_77973_b() != Items.field_151032_g) continue;
            arrowCount += itemStack.field_77994_a;
        }
        return arrowCount;
    }

    static String getItemStackCount(ItemStack itemStack, int count) {
        return count == 0 || count == 1 || count == 1 && itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("Unbreakable") ? "" : String.valueOf(count);
    }

    static String getArrowStackCount(int count) {
        return count == 0 ? "" : String.valueOf(count);
    }
}

