/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.util.EnumMCVersion;

public class VersionChecker
implements Runnable {
    private static boolean LATEST;
    private static boolean NO_CONNECTION;
    private static String LATEST_VERSION;
    private static String EXCEPTION_MESSAGE;
    private static List<String> ANNOUNCE_MESSAGE;
    public static final VersionChecker INSTANCE;

    public static void startCheck() {
        Thread thread = new Thread(INSTANCE);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String latestVersion;
        InputStream version = null;
        InputStream desc = null;
        try {
            version = new URL("https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/indicatia/indicatia_version.txt").openStream();
            desc = new URL("https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/indicatia/indicatia_desc.txt").openStream();
        }
        catch (MalformedURLException e) {
            EXCEPTION_MESSAGE = e.getClass().getName() + " " + e.getMessage();
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            EXCEPTION_MESSAGE = e.getClass().getName() + " " + e.getMessage();
            e.printStackTrace();
        }
        catch (Exception e) {
            EXCEPTION_MESSAGE = e.getClass().getName() + " " + e.getMessage();
            e.printStackTrace();
        }
        if (version == null && desc == null) {
            NO_CONNECTION = true;
            return;
        }
        try {
            for (EnumMCVersion mcVersion : EnumMCVersion.valuesCached()) {
                if (!IndicatiaMod.MC_VERSION.equals(mcVersion.getVersion())) continue;
                LATEST_VERSION = (String)IOUtils.readLines((InputStream)version).get(mcVersion.ordinal());
            }
            ANNOUNCE_MESSAGE = IOUtils.readLines((InputStream)desc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)version);
            IOUtils.closeQuietly((InputStream)desc);
        }
        int major = 0;
        int minor = 0;
        int build = 0;
        String latest = LATEST_VERSION;
        if (latest.contains("[" + IndicatiaMod.MC_VERSION + "]=")) {
            latest = latest.replace("[" + IndicatiaMod.MC_VERSION + "]=", "").replace(".", "");
            try {
                major = Integer.parseInt(String.valueOf(latest.charAt(0)));
                minor = Integer.parseInt(String.valueOf(latest.charAt(1)));
                build = Integer.parseInt(String.valueOf(latest.charAt(2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LATEST = !"1.1.8".equals(latestVersion = major + "." + minor + "." + build) && (major > 1 || minor > 1 || build > 8);
    }

    public boolean isLatestVersion() {
        return LATEST;
    }

    public boolean noConnection() {
        return NO_CONNECTION;
    }

    public String getLatestVersion() {
        return LATEST_VERSION;
    }

    public String getLatestVersionReplaceMC() {
        return LATEST_VERSION.replace("[" + IndicatiaMod.MC_VERSION + "]=", "");
    }

    public String getExceptionMessage() {
        return EXCEPTION_MESSAGE;
    }

    public List<String> getAnnounceMessage() {
        return ANNOUNCE_MESSAGE;
    }

    static {
        ANNOUNCE_MESSAGE = new ArrayList<String>();
        INSTANCE = new VersionChecker();
    }
}

