/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.command;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.gui.GuiAutoLoginFunction;
import stevekung.mods.indicatia.gui.GuiAutoLoginFunctionHelp;
import stevekung.mods.indicatia.utils.AutoLogin;
import stevekung.mods.indicatia.utils.Base64Utils;
import stevekung.mods.indicatia.utils.InfoUtils;
import stevekung.mods.stevekunglib.utils.GameProfileUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.client.ClientCommandBase;

public class CommandAutoLogin
extends ClientCommandBase {
    public String func_71517_b() {
        return "autologin";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Minecraft mc = Minecraft.func_71410_x();
        ServerData data = mc.func_147104_D();
        UUID uuid = GameProfileUtils.getUUID();
        if (InfoUtils.INSTANCE.isHypixel()) {
            throw new CommandException("commands.not_allowed_hypixel", new Object[0]);
        }
        if (mc.func_71356_B()) {
            sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.auto_login_singleplayer")).func_150255_a(JsonUtils.red()));
            return;
        }
        if (mc.func_181540_al()) {
            sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.auto_login_realms")).func_150255_a(JsonUtils.red()));
            return;
        }
        if (args.length < 1) {
            throw new WrongUsageException("commands.autologin.usage", new Object[0]);
        }
        if ("add".equalsIgnoreCase(args[0])) {
            if (args.length <= 2) {
                throw new WrongUsageException("commands.autologin.usage", new Object[0]);
            }
            if (data == null) return;
            if (ExtendedConfig.loginData.getAutoLogin(uuid.toString() + data.field_78845_b) != null) {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.auto_login_already_add")).func_150255_a(JsonUtils.red()));
                return;
            }
            ITextComponent component = ClientCommandBase.getChatComponentFromNthArg((String[])args, (int)2);
            String value = component.func_150259_f().func_150260_c();
            ExtendedConfig.loginData.addAutoLogin(data.field_78845_b, "/" + args[1] + " ", Base64Utils.encode(value), uuid, "");
            sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.auto_login_set")));
            ExtendedConfig.instance.save();
            return;
        } else if ("remove".equalsIgnoreCase(args[0])) {
            if (data == null) return;
            if (ExtendedConfig.loginData.getAutoLogin(uuid.toString() + data.field_78845_b) != null) {
                ExtendedConfig.loginData.removeAutoLogin(uuid + data.field_78845_b);
                sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.auto_login_remove")));
                return;
            } else {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.auto_login_not_set")).func_150255_a(JsonUtils.red()));
            }
            return;
        } else if ("list".equalsIgnoreCase(args[0])) {
            Collection<AutoLogin.AutoLoginData> collection = ExtendedConfig.loginData.getAutoLoginList();
            if (collection.isEmpty()) {
                throw new CommandException("commands.autologin.list.empty", new Object[0]);
            }
            TextComponentTranslation component = new TextComponentTranslation("commands.autologin.list.count", new Object[]{collection.size()});
            component.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
            sender.func_145747_a((ITextComponent)component);
            collection.forEach(loginData -> sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.autologin.list.entry", new Object[]{loginData.getServerIP(), loginData.getUUID()})));
            return;
        } else {
            if (!"function".equalsIgnoreCase(args[0])) throw new WrongUsageException("commands.autologin.usage", new Object[0]);
            if (args.length == 1) {
                GuiAutoLoginFunction gui = new GuiAutoLoginFunction();
                gui.display();
                return;
            } else {
                if (args.length != 2) return;
                if (!"help".equalsIgnoreCase(args[1])) throw new WrongUsageException("commands.autologin.function.usage", new Object[0]);
                GuiAutoLoginFunctionHelp gui = new GuiAutoLoginFunctionHelp(false);
                gui.display();
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (Minecraft.func_71410_x().func_71356_B() || Minecraft.func_71410_x().func_181540_al()) {
            return super.func_184883_a(server, sender, args, pos);
        }
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "list", "function"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("function")) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"help"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

