/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;
import stevekung.mods.stevekunglib.utils.client.ClientCommandBase;

public class CommandProfile
extends ClientCommandBase {
    public String func_71517_b() {
        return "inprofile";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.inprofile.usage", new Object[0]);
        }
        if ("add".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.inprofile.add.usage", new Object[0]);
            }
            String name = args[1];
            boolean exist = false;
            if (name.equalsIgnoreCase("default")) {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.create_profile_default")).func_150255_a(JsonUtils.red()));
                return;
            }
            for (File file2 : ExtendedConfig.userDir.listFiles()) {
                if (!name.equalsIgnoreCase(file2.getName().replace(".dat", ""))) continue;
                exist = file2.getName().equalsIgnoreCase(name + ".dat") && file2.exists();
            }
            if (exist) {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.already_created", (Object[])new Object[]{name})).func_150255_a(JsonUtils.red()));
            } else {
                sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.profile_added", (Object[])new Object[]{name})));
                ExtendedConfig.instance.save(name);
            }
        } else if ("load".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.inprofile.load.usage", new Object[0]);
            }
            String name = args[1];
            for (File file3 : ExtendedConfig.userDir.listFiles()) {
                if (!file3.getName().contains(name) || !file3.getName().endsWith(".dat") || file3.exists()) continue;
                sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.cant_load_profile")));
                return;
            }
            ExtendedConfig.instance.setCurrentProfile(name);
            ExtendedConfig.saveProfileFile(name);
            ExtendedConfig.instance.load();
            sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.load_profile", (Object[])new Object[]{name})));
            ExtendedConfig.instance.save(name);
        } else if ("save".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.inprofile.save.usage", new Object[0]);
            }
            String name = args[1];
            boolean exist = false;
            for (File file4 : ExtendedConfig.userDir.listFiles()) {
                if (!name.equalsIgnoreCase(file4.getName().replace(".dat", ""))) continue;
                exist = file4.getName().equalsIgnoreCase(name + ".dat") && file4.exists();
            }
            if (exist) {
                ExtendedConfig.instance.save(name);
                sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.save_profile", (Object[])new Object[]{name})));
            } else {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.cant_save_profile", (Object[])new Object[]{name})).func_150255_a(JsonUtils.red()));
            }
        } else if ("remove".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.inprofile.remove.usage", new Object[0]);
            }
            String name = args[1];
            if (name.equals("default")) {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.cannot_remove_default")).func_150255_a(JsonUtils.red()));
                return;
            }
            boolean exist = false;
            for (File file5 : ExtendedConfig.userDir.listFiles()) {
                if (!name.equalsIgnoreCase(file5.getName().replace(".dat", ""))) continue;
                exist = file5.getName().equalsIgnoreCase(name + ".dat") && file5.exists();
            }
            if (exist) {
                File toDel = new File(ExtendedConfig.userDir, name + ".dat");
                toDel.delete();
                ExtendedConfig.instance.setCurrentProfile("default");
                ExtendedConfig.instance.load();
                sender.func_145747_a((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"message.remove_profile", (Object[])new Object[]{name})));
            } else {
                sender.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"message.cant_remove_profile", (Object[])new Object[]{name})).func_150255_a(JsonUtils.red()));
            }
        } else if ("list".equalsIgnoreCase(args[0])) {
            ArrayList<File> collection = new ArrayList<File>(Arrays.asList(ExtendedConfig.userDir.listFiles()));
            if (collection.isEmpty()) {
                throw new CommandException("commands.inprofile.list.empty", new Object[0]);
            }
            int realSize = 0;
            for (File file6 : collection) {
                if (!file6.getName().endsWith(".dat")) continue;
                ++realSize;
            }
            TextComponentTranslation translation = new TextComponentTranslation("commands.inprofile.list.count", new Object[]{realSize});
            translation.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
            sender.func_145747_a((ITextComponent)translation);
            collection.forEach(file -> {
                String name = file.getName();
                String realName = name.replace(".dat", "");
                boolean current = realName.equals(ExtendedConfig.currentProfile);
                if (name.endsWith(".dat")) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.inprofile.list.entry", new Object[]{realName, current ? "- " + TextFormatting.RED + LangUtils.translate((String)"commands.inprofile.current_profile") : ""}));
                }
            });
        } else {
            throw new WrongUsageException("commands.inprofile.usage", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "load", "save", "remove", "list"});
        }
        if (args.length == 2 && ("load".equalsIgnoreCase(args[0]) || "remove".equalsIgnoreCase(args[0]) || "save".equalsIgnoreCase(args[0])) && ExtendedConfig.userDir.exists()) {
            LinkedList<String> list = new LinkedList<String>();
            for (File file : ExtendedConfig.userDir.listFiles()) {
                String name = file.getName();
                if (!"load".equalsIgnoreCase(args[0]) && !"save".equalsIgnoreCase(args[0]) && name.equals("default.dat") || !name.endsWith(".dat")) continue;
                list.add(name.replace(".dat", ""));
            }
            return CommandBase.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

