/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;
import stevekung.mods.indicatia.command.CommandAFK;
import stevekung.mods.indicatia.command.CommandAutoFish;
import stevekung.mods.indicatia.command.CommandAutoLogin;
import stevekung.mods.indicatia.command.CommandHideName;
import stevekung.mods.indicatia.command.CommandIndicatia;
import stevekung.mods.indicatia.command.CommandMojangStatusCheck;
import stevekung.mods.indicatia.command.CommandPingAll;
import stevekung.mods.indicatia.command.CommandProfile;
import stevekung.mods.indicatia.command.CommandRealmsMessage;
import stevekung.mods.indicatia.command.CommandSlimeChunkSeed;
import stevekung.mods.indicatia.command.CommandSwedenTime;
import stevekung.mods.indicatia.config.ConfigManagerIN;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.event.ChatMessageEventHandler;
import stevekung.mods.indicatia.event.HUDRenderEventHandler;
import stevekung.mods.indicatia.event.HypixelEventHandler;
import stevekung.mods.indicatia.event.IndicatiaEventHandler;
import stevekung.mods.indicatia.gui.GuiIndicatiaChat;
import stevekung.mods.indicatia.handler.KeyBindingHandler;
import stevekung.mods.indicatia.utils.CapeUtils;
import stevekung.mods.indicatia.utils.LoggerIN;
import stevekung.mods.indicatia.utils.ThreadMinigameData;
import stevekung.mods.stevekunglib.client.gui.GuiChatRegistry;
import stevekung.mods.stevekunglib.client.gui.IGuiChat;
import stevekung.mods.stevekunglib.utils.CommonUtils;
import stevekung.mods.stevekunglib.utils.VersionChecker;
import stevekung.mods.stevekunglib.utils.client.ClientCommandBase;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

@Mod(modid="indicatia", name="Indicatia", version="1.3.3", dependencies="required-after:stevekung's_lib@[1.1.5,); after:forge@[14.23.5.2768,);", updateJSON="https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/indicatia_version.json", clientSideOnly=true, certificateFingerprint="b3468b224a74e296555ad7efeb35f482e6f445de", acceptedMinecraftVersions="[1.12.2]")
public class IndicatiaMod {
    protected static final String NAME = "Indicatia";
    public static final String MOD_ID = "indicatia";
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 3;
    private static final int BUILD_VERSION = 3;
    public static final String VERSION = "1.3.3";
    private static final String FORGE_VERSION = "after:forge@[14.23.5.2768,);";
    protected static final String DEPENDENCIES = "required-after:stevekung's_lib@[1.1.5,); after:forge@[14.23.5.2768,);";
    private static final String URL = "https://minecraft.curseforge.com/projects/indicatia";
    protected static final String JSON_URL = "https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/indicatia_version.json";
    protected static final String CERTIFICATE = "b3468b224a74e296555ad7efeb35f482e6f445de";
    @Mod.Instance(value="indicatia")
    public static IndicatiaMod INSTANCE;
    public static boolean isDevelopment;
    public static final File profile;
    public static VersionChecker CHECKER;
    public static final boolean isGalacticraftLoaded;
    public static final boolean isYoutubeChatLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IndicatiaMod.init(event.getModMetadata());
        KeyBindingHandler.init();
        CommonUtils.registerEventHandler((Object)this);
        CommonUtils.registerEventHandler((Object)new HUDRenderEventHandler());
        CommonUtils.registerEventHandler((Object)new IndicatiaEventHandler());
        CommonUtils.registerEventHandler((Object)new ChatMessageEventHandler());
        CommonUtils.registerEventHandler((Object)new HypixelEventHandler());
        if (ConfigManagerIN.indicatia_general.enableFishingRodOldRender) {
            ModelLoader.setCustomModelResourceLocation((Item)Items.field_151112_aM, (int)0, (ModelResourceLocation)new ModelResourceLocation("indicatia:fishing_rod", "inventory"));
            LoggerIN.info("Successfully replacing vanilla Fishing Rod item model");
        }
        ClientUtils.registerCommand((ClientCommandBase)new CommandMojangStatusCheck());
        ClientUtils.registerCommand((ClientCommandBase)new CommandAutoLogin());
        ClientUtils.registerCommand((ClientCommandBase)new CommandSlimeChunkSeed());
        ClientUtils.registerCommand((ClientCommandBase)new CommandAFK());
        ClientUtils.registerCommand((ClientCommandBase)new CommandIndicatia());
        ClientUtils.registerCommand((ClientCommandBase)new CommandProfile());
        ClientUtils.registerCommand((ClientCommandBase)new CommandRealmsMessage());
        ClientUtils.registerCommand((ClientCommandBase)new CommandHideName());
        ClientUtils.registerCommand((ClientCommandBase)new CommandPingAll());
        ClientUtils.registerCommand((ClientCommandBase)new CommandAutoFish());
        ClientUtils.registerCommand((ClientCommandBase)new CommandSwedenTime());
        CHECKER = new VersionChecker((Object)INSTANCE, NAME, URL);
        if (ConfigManagerIN.indicatia_general.enableVersionChecker) {
            CHECKER.startCheck();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        IndicatiaMod.loadProfileOption();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CapeUtils.loadCapeTextureAtStartup();
        GuiChatRegistry.register((IGuiChat)new GuiIndicatiaChat());
        new ThreadMinigameData().run();
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!isDevelopment) {
            throw new RuntimeException("Invalid fingerprint detected! This version will NOT be supported by the author!");
        }
        LoggerIN.info("Development environment detected! Ignore certificate check.");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    private static void init(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.description = "Simple in-game info and utilities!";
        info.url = URL;
        info.authorList = Arrays.asList("SteveKunG");
    }

    private static void loadProfileOption() {
        if (!profile.exists()) {
            return;
        }
        if (!ExtendedConfig.defaultConfig.exists()) {
            LoggerIN.info("Initializing created default Indicatia profile...");
            ExtendedConfig.instance.setCurrentProfile("default");
            ExtendedConfig.instance.save();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            List list = IOUtils.readLines((InputStream)new FileInputStream(profile), (Charset)StandardCharsets.UTF_8);
            list.forEach(option -> {
                Iterator iterator = GameSettings.field_189990_a.omitEmptyStrings().limit(2).split((CharSequence)option).iterator();
                nbt.func_74778_a((String)iterator.next(), (String)iterator.next());
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        nbt.func_150296_c().forEach(property -> {
            String key = nbt.func_74779_i(property);
            if ("profile".equals(property)) {
                LoggerIN.info("Loaded current profile by name '{}'", key);
                ExtendedConfig.instance.setCurrentProfile(key);
                ExtendedConfig.instance.load();
            }
        });
    }

    private static void initProfileFile() {
        if (!ExtendedConfig.indicatiaDir.exists()) {
            ExtendedConfig.indicatiaDir.mkdirs();
        } else if (!ExtendedConfig.userDir.exists()) {
            ExtendedConfig.userDir.mkdirs();
        }
        File profile = new File(ExtendedConfig.userDir, "profile.txt");
        if (!profile.exists()) {
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(profile), StandardCharsets.UTF_8));){
                writer.println("profile:default");
                LoggerIN.info("Creating profile option at {}", profile.getPath());
            }
            catch (IOException e) {
                LoggerIN.error("Failed to save profile");
                e.printStackTrace();
            }
        }
    }

    static {
        profile = new File(ExtendedConfig.userDir, "profile.txt");
        isGalacticraftLoaded = Loader.isModLoaded((String)"galacticraftcore");
        isYoutubeChatLoaded = Loader.isModLoaded((String)"youtube_chat");
        try {
            isDevelopment = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IndicatiaMod.initProfileFile();
    }
}

