/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.util.Strings;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.utils.AutoLoginFunction;
import stevekung.mods.indicatia.utils.Base64Utils;
import stevekung.mods.stevekunglib.utils.CommonUtils;
import stevekung.mods.stevekunglib.utils.GameProfileUtils;

public class ChatMessageEventHandler {
    private Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.mc.func_152344_a(() -> MinecraftForge.EVENT_BUS.register((Object)new PlayerSendMessageHandler()));
    }

    public class PlayerSendMessageHandler {
        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof EntityPlayerSP) {
                EntityPlayerSP player = (EntityPlayerSP)event.getEntity();
                ServerData data = ChatMessageEventHandler.this.mc.func_147104_D();
                this.runAutoLoginCommand(player, data);
                this.runRealmsCommand(player);
                this.runAutoLoginFunction(player, data);
                CommonUtils.unregisterEventHandler((Object)this);
            }
        }

        private void runAutoLoginCommand(EntityPlayerSP player, ServerData data) {
            if (data != null) {
                ExtendedConfig.loginData.getAutoLoginList().forEach(login -> {
                    if (data.field_78845_b.equalsIgnoreCase(login.getServerIP()) && GameProfileUtils.getUUID().equals(login.getUUID())) {
                        player.func_71165_d(login.getCommand() + Base64Utils.decode(login.getValue()));
                    }
                });
            }
        }

        private void runRealmsCommand(EntityPlayerSP player) {
            if (Minecraft.func_71410_x().func_181540_al() && Strings.isNotEmpty((CharSequence)ExtendedConfig.instance.realmsMessage)) {
                player.func_71165_d(ExtendedConfig.instance.realmsMessage);
            }
        }

        private void runAutoLoginFunction(EntityPlayerSP player, ServerData data) {
            if (data != null) {
                ExtendedConfig.loginData.getAutoLoginList().forEach(login -> {
                    if (data.field_78845_b.equalsIgnoreCase(login.getServerIP()) && GameProfileUtils.getUUID().equals(login.getUUID()) && !login.getFunction().isEmpty()) {
                        AutoLoginFunction.functionValue = login.getFunction();
                        AutoLoginFunction.run = true;
                    }
                });
            }
        }
    }
}

