/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.event;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import stevekung.mods.indicatia.config.CPSPosition;
import stevekung.mods.indicatia.config.ConfigManagerIN;
import stevekung.mods.indicatia.config.EnumEquipment;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.config.HealthStatusMode;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.gui.config.GuiRenderPreview;
import stevekung.mods.indicatia.renderer.HUDInfo;
import stevekung.mods.indicatia.renderer.KeystrokeRenderer;
import stevekung.mods.indicatia.utils.InfoUtils;
import stevekung.mods.indicatia.utils.LoggerIN;
import stevekung.mods.indicatia.utils.RenderUtilsIN;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;

public class HUDRenderEventHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    public static boolean recordEnable;
    private int recTick;
    private static int readFileTicks;
    public static String topDonator;
    public static String recentDonator;
    private static String topDonatorName;
    private static String topDonatorCount;
    private static String recentDonatorName;
    private static String recentDonatorCount;
    public static final DecimalFormat tpsFormat;
    public static String currentLiveViewCount;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++readFileTicks;
            this.recTick = recordEnable ? ++this.recTick : 0;
            if (!ExtendedConfig.instance.topDonatorFilePath.isEmpty()) {
                HUDRenderEventHandler.readTopDonatorFile();
            } else {
                topDonator = "";
            }
            if (!ExtendedConfig.instance.recentDonatorFilePath.isEmpty()) {
                HUDRenderEventHandler.readRecentDonatorFile();
            } else {
                recentDonator = "";
            }
            if (IndicatiaMod.isYoutubeChatLoaded) {
                try {
                    Class<?> clazz = Class.forName("stevekung.mods.ytchat.utils.YouTubeChatService");
                    currentLiveViewCount = (String)clazz.getField("currentLiveViewCount").get(null);
                }
                catch (Exception e) {
                    currentLiveViewCount = TextFormatting.RED + "unavailable";
                }
            }
        }
    }

    @SubscribeEvent
    public void onPreInfoRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            event.setCanceled(!ConfigManagerIN.indicatia_general.enableRenderBossHealthStatus);
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        if ((event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR || event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) && this.mc.field_71462_r instanceof GuiRenderPreview) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            if (ConfigManagerIN.indicatia_general.enableRenderInfo && !this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P && this.mc.field_71439_g != null && this.mc.field_71441_e != null && !(this.mc.field_71462_r instanceof GuiRenderPreview)) {
                float yOffset;
                String string;
                int i;
                LinkedList<String> leftInfo = new LinkedList<String>();
                LinkedList<String> rightInfo = new LinkedList<String>();
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (ExtendedConfig.instance.ping && !this.mc.func_71356_B()) {
                    leftInfo.add(HUDInfo.getPing());
                    if (ExtendedConfig.instance.pingToSecond) {
                        leftInfo.add(HUDInfo.getPingToSecond());
                    }
                }
                if (ExtendedConfig.instance.serverIP && !this.mc.func_71356_B()) {
                    if (this.mc.func_181540_al()) {
                        leftInfo.add(HUDInfo.getRealmName(this.mc));
                    }
                    if (this.mc.func_147104_D() != null) {
                        leftInfo.add(HUDInfo.getServerIP(this.mc));
                    }
                }
                if (ExtendedConfig.instance.fps) {
                    leftInfo.add(HUDInfo.getFPS());
                }
                if (ExtendedConfig.instance.xyz) {
                    leftInfo.add(HUDInfo.getXYZ(this.mc));
                    if (this.mc.field_71439_g.field_71093_bK == -1) {
                        leftInfo.add(HUDInfo.getOverworldXYZFromNether(this.mc));
                    }
                }
                if (ExtendedConfig.instance.direction) {
                    leftInfo.add(HUDInfo.renderDirection(this.mc));
                }
                if (ExtendedConfig.instance.biome) {
                    leftInfo.add(HUDInfo.getBiome(this.mc));
                }
                if (ExtendedConfig.instance.slimeChunkFinder && this.mc.field_71439_g.field_71093_bK == 0) {
                    String isSlimeChunk = InfoUtils.INSTANCE.isSlimeChunk(this.mc.field_71439_g.func_180425_c()) ? "Yes" : "No";
                    leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.slimeChunkColor).toColoredFont() + "Slime Chunk: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.slimeChunkValueColor).toColoredFont() + isSlimeChunk);
                }
                if (CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("left")) {
                    if (ExtendedConfig.instance.cps) {
                        leftInfo.add(HUDInfo.getCPS());
                    }
                    if (ExtendedConfig.instance.rcps) {
                        leftInfo.add(HUDInfo.getRCPS());
                    }
                }
                if (ConfigManagerIN.indicatia_donation.donatorMessagePosition == ConfigManagerIN.Donation.DonatorMessagePos.LEFT) {
                    String text;
                    if (!topDonator.isEmpty()) {
                        text = ExtendedConfig.instance.topDonatorText.isEmpty() ? "" : ExtendedConfig.instance.topDonatorText + TextFormatting.RESET + " ";
                        leftInfo.add(text + topDonator);
                    }
                    if (!recentDonator.isEmpty()) {
                        text = ExtendedConfig.instance.recentDonatorText.isEmpty() ? "" : ExtendedConfig.instance.recentDonatorText + TextFormatting.RESET + " ";
                        leftInfo.add(text + recentDonator);
                    }
                }
                if (ExtendedConfig.instance.tps && server != null) {
                    int dimension = 0;
                    double overallTPS = (double)HUDRenderEventHandler.mean(server.field_71311_j) * 1.0E-6;
                    double overworldTPS = (double)HUDRenderEventHandler.mean((long[])server.worldTickTimes.get(dimension)) * 1.0E-6;
                    double tps = Math.min(1000.0 / overallTPS, 20.0);
                    leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "Overall TPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + tpsFormat.format(overallTPS));
                    if (ExtendedConfig.instance.tpsAllDims) {
                        for (Integer dimensionIds : DimensionManager.getIDs()) {
                            long[] values = (long[])server.worldTickTimes.get(dimensionIds);
                            if (values == null) {
                                LoggerIN.error("Got null Dimension ID {}! Skipped TPS from dimension", new Object[]{values});
                                return;
                            }
                            double dimensionTPS = (double)HUDRenderEventHandler.mean(values) * 1.0E-6;
                            leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "Dimension " + server.func_71218_a((int)dimensionIds.intValue()).field_73011_w.func_186058_p().func_186065_b() + " " + dimensionIds + ": " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + tpsFormat.format(dimensionTPS));
                        }
                    } else {
                        leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "Overworld TPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + tpsFormat.format(overworldTPS));
                    }
                    leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "TPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + tpsFormat.format(tps));
                }
                if (ExtendedConfig.instance.realTime) {
                    rightInfo.add(HUDInfo.getCurrentTime());
                }
                if (ExtendedConfig.instance.gameTime) {
                    rightInfo.add(HUDInfo.getCurrentGameTime(this.mc));
                }
                if (ExtendedConfig.instance.gameWeather && this.mc.field_71441_e.func_72896_J()) {
                    rightInfo.add(HUDInfo.getGameWeather(this.mc));
                }
                if (ExtendedConfig.instance.moonPhase) {
                    rightInfo.add(InfoUtils.INSTANCE.getMoonPhase(this.mc));
                }
                if (CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("right")) {
                    if (ExtendedConfig.instance.cps) {
                        rightInfo.add(HUDInfo.getCPS());
                    }
                    if (ExtendedConfig.instance.rcps) {
                        rightInfo.add(HUDInfo.getRCPS());
                    }
                }
                if (ConfigManagerIN.indicatia_donation.donatorMessagePosition == ConfigManagerIN.Donation.DonatorMessagePos.RIGHT) {
                    if (!topDonator.isEmpty()) {
                        String text = ExtendedConfig.instance.topDonatorText.isEmpty() ? "" : ExtendedConfig.instance.topDonatorText + TextFormatting.RESET + " ";
                        rightInfo.add(text + topDonator);
                    }
                    if (!recentDonator.isEmpty()) {
                        String text = ExtendedConfig.instance.recentDonatorText.isEmpty() ? "" : ExtendedConfig.instance.recentDonatorText + TextFormatting.RESET + " ";
                        rightInfo.add(text + recentDonator);
                    }
                }
                if (IndicatiaMod.isYoutubeChatLoaded && !currentLiveViewCount.isEmpty()) {
                    rightInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.ytChatViewCountColor).toColoredFont() + "Current watched: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.ytChatViewCountValueColor).toColoredFont() + currentLiveViewCount);
                }
                if (!this.mc.field_71439_g.func_175149_v() && ExtendedConfig.instance.equipmentHUD) {
                    if (EnumEquipment.Position.getById(ExtendedConfig.instance.equipmentPosition).equalsIgnoreCase("hotbar")) {
                        HUDInfo.renderHotbarEquippedItems(this.mc);
                    } else if (EnumEquipment.Direction.getById(ExtendedConfig.instance.equipmentDirection).equalsIgnoreCase("vertical")) {
                        HUDInfo.renderVerticalEquippedItems(this.mc);
                    } else {
                        HUDInfo.renderHorizontalEquippedItems(this.mc);
                    }
                }
                if (ExtendedConfig.instance.potionHUD) {
                    HUDInfo.renderPotionHUD(this.mc);
                }
                for (i = 0; i < leftInfo.size(); ++i) {
                    ScaledResolution res = new ScaledResolution(this.mc);
                    string = (String)leftInfo.get(i);
                    float fontHeight = this.mc.field_71466_p.field_78288_b + 1;
                    yOffset = 3.0f + fontHeight * (float)i;
                    float xOffset = res.func_78326_a() - 2 - this.mc.field_71466_p.func_78256_a(string);
                    if (StringUtils.func_151246_b((String)string)) continue;
                    this.mc.field_71466_p.func_175065_a(string, ExtendedConfig.instance.swapRenderInfo ? xOffset : 3.0625f, yOffset, 0xFFFFFF, true);
                }
                for (i = 0; i < rightInfo.size(); ++i) {
                    ScaledResolution res = new ScaledResolution(this.mc);
                    string = (String)rightInfo.get(i);
                    float fontHeight = this.mc.field_71466_p.field_78288_b + 1;
                    yOffset = 3.0f + fontHeight * (float)i;
                    float xOffset = res.func_78326_a() - 2 - this.mc.field_71466_p.func_78256_a(string);
                    if (StringUtils.func_151246_b((String)string)) continue;
                    this.mc.field_71466_p.func_175065_a(string, ExtendedConfig.instance.swapRenderInfo ? 3.0625f : xOffset, yOffset, 0xFFFFFF, true);
                }
            }
            if (recordEnable) {
                ScaledResolution res = new ScaledResolution(this.mc);
                int color = 0xFFFFFF;
                if (this.recTick % 24 >= 0 && this.recTick % 24 <= 12) {
                    color = 0xFF5555;
                }
                this.mc.field_71466_p.func_175065_a("REC: " + StringUtils.func_76337_a((int)this.recTick), (float)(res.func_78326_a() - this.mc.field_71466_p.func_78256_a("REC: " + StringUtils.func_76337_a((int)this.recTick)) - 2), (float)(res.func_78328_b() - 10), color, true);
            }
            if (!this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P) {
                if (ExtendedConfig.instance.keystroke && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiChat)) {
                    KeystrokeRenderer.render(this.mc);
                }
                if (ConfigManagerIN.indicatia_general.enableRenderInfo && ExtendedConfig.instance.cps && CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("custom") && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiChat)) {
                    String rcps = ExtendedConfig.instance.rcps ? " " + HUDInfo.getRCPS() : "";
                    RenderUtilsIN.drawRect(ExtendedConfig.instance.cpsCustomXOffset, ExtendedConfig.instance.cpsCustomYOffset, ExtendedConfig.instance.cpsCustomXOffset + this.mc.field_71466_p.func_78256_a(HUDInfo.getCPS() + rcps) + 4, ExtendedConfig.instance.cpsCustomYOffset + 11, 0x1000000, ExtendedConfig.instance.cpsOpacity / 100.0f);
                    this.mc.field_71466_p.func_175065_a(HUDInfo.getCPS() + rcps, (float)(ExtendedConfig.instance.cpsCustomXOffset + 2), (float)(ExtendedConfig.instance.cpsCustomYOffset + 2), 0xFFFFFF, true);
                }
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT && this.mc.field_71462_r instanceof GuiRenderPreview) {
            event.setCanceled(true);
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && (!ConfigManagerIN.indicatia_general.enableVanillaPotionHUD || this.mc.field_71462_r instanceof GuiRenderPreview)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderHealthStatus(RenderLivingEvent.Specials.Post event) {
        Style color;
        boolean flag;
        EntityLivingBase entity = event.getEntity();
        float health = entity.func_110143_aJ();
        boolean halfHealth = health <= entity.func_110138_aP() / 2.0f;
        boolean halfHealth1 = health <= entity.func_110138_aP() / 4.0f;
        float range = entity.func_70093_af() ? RenderLivingBase.NAME_TAG_RANGE_SNEAK : RenderLivingBase.NAME_TAG_RANGE;
        double distance = entity.func_70068_e(this.mc.func_175598_ae().field_78734_h);
        String mode = HealthStatusMode.getById(ExtendedConfig.instance.healthStatusMode);
        boolean bl = mode.equalsIgnoreCase("disabled") ? false : (mode.equalsIgnoreCase("pointed") ? entity == InfoUtils.INSTANCE.extendedPointedEntity : (flag = true));
        Style style = halfHealth ? JsonUtils.red() : (color = halfHealth1 ? JsonUtils.darkRed() : JsonUtils.green());
        if (!(!(distance < (double)(range * range)) || this.mc.field_71474_y.field_74319_N || entity.func_82150_aj() || !flag || entity instanceof EntityPlayerSP || entity instanceof EntityArmorStand || InfoUtils.INSTANCE.isHypixel())) {
            String heart = JsonUtils.create((String)"\u2764 ").func_150255_a(color).func_150254_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            RenderUtilsIN.renderEntityHealth(entity, heart + String.format("%.1f", Float.valueOf(health)), event.getX(), event.getY(), event.getZ());
        }
    }

    private static void readTopDonatorFile() {
        File file = new File("/" + ExtendedConfig.instance.topDonatorFilePath);
        String text = "";
        if (readFileTicks % ConfigManagerIN.indicatia_donation.readFileInterval == 0) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    text = line.replace("\r", "");
                }
                String[] textSplit = text.split(" ");
                topDonatorName = textSplit[0];
                topDonatorCount = textSplit[1];
            }
            catch (Exception e) {
                LoggerIN.error("Couldn't read text file from path {}", file.getPath());
                e.printStackTrace();
                topDonator = TextFormatting.RED + "Cannot read text file!";
            }
        }
        topDonator = ColorUtils.stringToRGB((String)ExtendedConfig.instance.topDonatorNameColor).toColoredFont() + topDonatorName + ColorUtils.stringToRGB((String)ExtendedConfig.instance.topDonatorValueColor).toColoredFont() + " " + topDonatorCount.replace("THB", "") + "THB";
    }

    private static void readRecentDonatorFile() {
        File file = new File("/" + ExtendedConfig.instance.recentDonatorFilePath);
        String text = "";
        if (readFileTicks % ConfigManagerIN.indicatia_donation.readFileInterval == 0) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    text = line.replace("\r", "");
                }
                String[] textSplit = text.split(" ");
                recentDonatorName = textSplit[0];
                recentDonatorCount = textSplit[1];
            }
            catch (Exception e) {
                LoggerIN.error("Couldn't read text file from path {}", file.getPath());
                e.printStackTrace();
                recentDonator = TextFormatting.RED + "Cannot read text file!";
            }
        }
        recentDonator = ColorUtils.stringToRGB((String)ExtendedConfig.instance.recentDonatorNameColor).toColoredFont() + recentDonatorName + ColorUtils.stringToRGB((String)ExtendedConfig.instance.recentDonatorValueColor).toColoredFont() + " " + recentDonatorCount.replace("THB", "") + "THB";
    }

    public static long mean(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    static {
        topDonator = "";
        recentDonator = "";
        topDonatorName = "";
        topDonatorCount = "";
        recentDonatorName = "";
        recentDonatorCount = "";
        tpsFormat = new DecimalFormat("########0.00");
        currentLiveViewCount = "";
    }
}

