/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;
import stevekung.mods.indicatia.config.CPSPosition;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.gui.GuiButtonCustomize;
import stevekung.mods.indicatia.gui.GuiDropdownMinigames;
import stevekung.mods.indicatia.minigames.MinigameCommand;
import stevekung.mods.indicatia.minigames.MinigameData;
import stevekung.mods.indicatia.renderer.HUDInfo;
import stevekung.mods.indicatia.utils.HideNameData;
import stevekung.mods.indicatia.utils.InfoUtils;
import stevekung.mods.stevekunglib.client.gui.IEntityHoverChat;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class GuiIndicatiaChat
implements IEntityHoverChat,
GuiDropdownMinigames.IDropboxCallback {
    private boolean isDragging;
    private int lastPosX;
    private int lastPosY;
    private GuiDropdownMinigames dropdown;
    private int prevSelect = -1;

    public void initGui(List<GuiButton> buttonList, int width, int height) {
        this.updateButton(buttonList, width, height);
    }

    public void drawScreen(List<GuiButton> buttonList, int mouseX, int mouseY, float partialTicks) {
        buttonList.forEach(button -> {
            if (button instanceof GuiButtonCustomize) {
                GuiButtonCustomize customButton = (GuiButtonCustomize)((Object)button);
                customButton.drawRegion(mouseX, mouseY);
            }
        });
    }

    public void updateScreen(List<GuiButton> buttonList, int width, int height) {
        if (InfoUtils.INSTANCE.isHypixel()) {
            if (this.prevSelect != ExtendedConfig.instance.selectedHypixelMinigame) {
                this.updateButton(buttonList, width, height);
                this.prevSelect = ExtendedConfig.instance.selectedHypixelMinigame;
            }
            boolean clicked = !this.dropdown.dropdownClicked;
            buttonList.forEach(button -> {
                if (button instanceof GuiButtonCustomize) {
                    GuiButtonCustomize buttonCustom = (GuiButtonCustomize)((Object)button);
                    buttonCustom.field_146125_m = clicked;
                }
            });
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (ExtendedConfig.instance.cps && CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("custom")) {
            String space = ExtendedConfig.instance.rcps ? " " : "";
            int minX = ExtendedConfig.instance.cpsCustomXOffset;
            int minY = ExtendedConfig.instance.cpsCustomYOffset;
            int maxX = ExtendedConfig.instance.cpsCustomXOffset + Minecraft.func_71410_x().field_71466_p.func_78256_a(HUDInfo.getCPS() + space + HUDInfo.getRCPS()) + 4;
            int maxY = ExtendedConfig.instance.cpsCustomYOffset + 12;
            if (mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
                this.isDragging = true;
                this.lastPosX = mouseX;
                this.lastPosY = mouseY;
            }
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (ExtendedConfig.instance.cps && CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("custom") && state == 0 && this.isDragging) {
            this.isDragging = false;
            ExtendedConfig.instance.save();
        }
    }

    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (ExtendedConfig.instance.cps && CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("custom") && this.isDragging) {
            ExtendedConfig.instance.cpsCustomXOffset += mouseX - this.lastPosX;
            ExtendedConfig.instance.cpsCustomYOffset += mouseY - this.lastPosY;
            this.lastPosX = mouseX;
            this.lastPosY = mouseY;
        }
    }

    public void actionPerformed(GuiButton button) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || !(mc.field_71462_r instanceof GuiChat)) {
            return;
        }
        if (button instanceof GuiButtonCustomize) {
            GuiButtonCustomize buttomCustom = (GuiButtonCustomize)button;
            if (button.field_146127_k == buttomCustom.field_146127_k) {
                player.func_71165_d(buttomCustom.command);
            }
        }
        switch (button.field_146127_k) {
            case 0: {
                ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
                ExtendedConfig.instance.cpsCustomXOffset = res.func_78326_a() / 2 - (ExtendedConfig.instance.rcps ? 36 : 16);
                ExtendedConfig.instance.cpsCustomYOffset = res.func_78328_b() / 2 - 5;
                ExtendedConfig.instance.save();
                break;
            }
            case 200: {
                player.func_71165_d("/chat a");
                player.func_145747_a((ITextComponent)JsonUtils.create((String)"Reset Hypixel Chat"));
                break;
            }
            case 201: {
                player.func_71165_d("/chat p");
                player.func_145747_a((ITextComponent)JsonUtils.create((String)"Set chat mode to Hypixel Party Chat"));
                break;
            }
            case 202: {
                player.func_71165_d("/chat g");
                player.func_145747_a((ITextComponent)JsonUtils.create((String)"Set chat mode to Hypixel Guild Chat"));
            }
        }
    }

    public String addEntityComponent(String name) {
        for (String hide : HideNameData.getHideNameList()) {
            if (!name.contains(hide)) continue;
            name = name.replace(hide, TextFormatting.OBFUSCATED + hide + TextFormatting.RESET);
        }
        return name;
    }

    public void onGuiClosed() {
        ExtendedConfig.instance.save();
    }

    public void handleMouseInput(int width, int height) {
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        int mouseX = Mouse.getEventX() * width / mc.field_71443_c;
        int mouseY = height - Mouse.getEventY() * height / mc.field_71440_d - 1;
        if (this.dropdown != null && this.dropdown.dropdownClicked && this.dropdown.isHoverDropdown(mouseX, mouseY) && (i = Mouse.getEventDWheel()) != 0) {
            if (i > 1) {
                i = -1;
            }
            if (i < -1) {
                i = 1;
            }
            if (GuiScreen.func_146271_m()) {
                i *= 7;
            }
            this.dropdown.scroll(i);
        }
    }

    public void pageUp() {
    }

    public void pageDown() {
    }

    public void getSentHistory(int msgPos) {
    }

    @Override
    public void onSelectionChanged(GuiDropdownMinigames dropdown, int selection) {
        ExtendedConfig.instance.selectedHypixelMinigame = selection;
        ExtendedConfig.instance.save();
    }

    @Override
    public int getInitialSelection(GuiDropdownMinigames dropdown) {
        return ExtendedConfig.instance.selectedHypixelMinigame;
    }

    private void updateButton(List<GuiButton> buttonList, int width, int height) {
        boolean enableCPS;
        Minecraft mc = Minecraft.func_71410_x();
        buttonList.clear();
        boolean bl = enableCPS = ExtendedConfig.instance.cps && CPSPosition.getById(ExtendedConfig.instance.cpsPosition).equalsIgnoreCase("custom");
        if (enableCPS) {
            buttonList.add(new GuiButton(0, width - 63, height - 35, 60, 20, LangUtils.translate((String)"message.reset_cps")));
        }
        if (InfoUtils.INSTANCE.isHypixel()) {
            LinkedList<String> list = new LinkedList<String>();
            for (MinigameData data : MinigameData.getMinigameData()) {
                list.add(data.getName());
            }
            String max = Collections.max(list, Comparator.comparing(text -> text.length()));
            int length = mc.field_71466_p.func_78256_a(max) + 32;
            buttonList.add(new GuiButton(200, width - 63, enableCPS ? height - 56 : height - 35, 60, 20, "Reset Chat"));
            buttonList.add(new GuiButton(201, width - 63, enableCPS ? height - 77 : height - 56, 60, 20, "Party Chat"));
            buttonList.add(new GuiButton(202, width - 63, enableCPS ? height - 98 : height - 77, 60, 20, "Guild Chat"));
            this.dropdown = new GuiDropdownMinigames(this, width - length, 2, list);
            buttonList.add(this.dropdown);
            this.dropdown.field_146120_f = length;
            this.prevSelect = ExtendedConfig.instance.selectedHypixelMinigame;
            LinkedList<GuiButtonCustomize> gameBtn = new LinkedList<GuiButtonCustomize>();
            int xPos2 = width - 99;
            if (this.prevSelect > list.size()) {
                this.prevSelect = 0;
                ExtendedConfig.instance.selectedHypixelMinigame = 0;
            }
            for (MinigameData data : MinigameData.getMinigameData()) {
                for (MinigameCommand command : data.getCommands()) {
                    if (!data.getName().equals(list.get(this.prevSelect))) continue;
                    gameBtn.add(new GuiButtonCustomize(width, command.getName(), command.getCommand(), command.isMinigame()));
                }
            }
            for (int i = 0; i < gameBtn.size(); ++i) {
                GuiButtonCustomize button2 = (GuiButtonCustomize)((Object)gameBtn.get(i));
                if (i >= 6 && i <= 10) {
                    button2.field_146128_h = xPos2 - 136;
                    button2.field_146129_i = 41;
                } else if (i >= 11 && i <= 15) {
                    button2.field_146128_h = xPos2 - 241;
                    button2.field_146129_i = 62;
                } else if (i >= 16 && i <= 20) {
                    button2.field_146128_h = xPos2 - 346;
                    button2.field_146129_i = 83;
                } else if (i >= 21) {
                    button2.field_146128_h = xPos2 - 451;
                    button2.field_146129_i = 104;
                }
                button2.field_146128_h += 21 * i;
                buttonList.add(button2);
            }
        }
        buttonList.forEach(button -> {
            if (!(button.getClass().equals(GuiDropdownMinigames.class) || button.field_146127_k >= 0 && button.field_146127_k <= 202)) {
                button.field_146125_m = false;
            }
        });
    }
}

