/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.gui.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.gui.config.GuiConfigButton;
import stevekung.mods.indicatia.gui.config.GuiTextFieldExtended;
import stevekung.mods.stevekunglib.utils.ColorUtils;

@SideOnly(value=Side.CLIENT)
public class GuiConfigTextFieldRowList
extends GuiListExtended {
    private final List<Row> options = new ArrayList<Row>();
    private final GuiScreen parent;
    public int selected = -1;

    public GuiConfigTextFieldRowList(GuiScreen parent, int width, int height, int top, int bottom, int slotHeight, ExtendedConfig.Options[] options) {
        super(parent.field_146297_k, width, height, top, bottom, slotHeight);
        this.parent = parent;
        this.field_148163_i = false;
        Arrays.stream(options).forEach(option -> {
            int buttonWidth = option.isBoolean() ? width / 2 - 80 : this.field_148155_a / 2 + 40;
            Gui gui = this.createButton(buttonWidth, 0, (ExtendedConfig.Options)((Object)option));
            this.options.add(new Row(option.getTranslation(), gui));
        });
    }

    private Gui createButton(int x, int y, ExtendedConfig.Options options) {
        if (options == null) {
            return null;
        }
        int i = options.getOrdinal();
        return options.isBoolean() ? new GuiConfigButton(i, x, y, 160, options, ExtendedConfig.instance.getKeyBinding(options)) : new GuiTextFieldExtended(i, x, y, 80, options);
    }

    public Row getListEntry(int index) {
        return this.options.get(index);
    }

    protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        boolean flag;
        boolean bl = flag = this.options.get(slotIndex).getTextField() != null && mouseX >= this.options.get((int)slotIndex).getTextField().field_146209_f && mouseX < this.options.get((int)slotIndex).getTextField().field_146209_f + this.options.get((int)slotIndex).getTextField().field_146218_h && mouseY >= this.options.get((int)slotIndex).getTextField().field_146210_g && mouseY < this.options.get((int)slotIndex).getTextField().field_146210_g + this.options.get((int)slotIndex).getTextField().field_146219_i;
        if (flag) {
            this.selected = slotIndex;
        }
    }

    protected int func_148127_b() {
        return this.options.size();
    }

    public int func_148139_c() {
        return 400;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 40;
    }

    public void saveCurrentValue() {
        this.options.forEach(row -> row.saveCurrentValue());
    }

    public void mouseClickedText(int mouseX, int mouseY, int mouseEvent) {
        this.options.forEach(row -> row.mouseClicked(mouseX, mouseY, mouseEvent));
    }

    public void updateCursorCounter() {
        this.options.forEach(row -> row.updateCursorCounter());
    }

    public void textboxKeyTyped(char typedChar, int keyCode) {
        if (keyCode == 28) {
            this.saveCurrentValue();
            ExtendedConfig.instance.save();
            this.field_148161_k.func_147108_a(this.parent);
        }
        this.options.forEach(row -> row.textboxKeyTyped(typedChar, keyCode));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Row
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft mc = Minecraft.func_71410_x();
        private final Gui gui;
        private final String name;

        public Row(String name, Gui gui) {
            this.gui = gui;
            this.name = name;
            if (this.gui instanceof GuiTextFieldExtended) {
                GuiTextFieldExtended text = (GuiTextFieldExtended)this.gui;
                text.func_146180_a(ExtendedConfig.instance.getKeyBinding(ExtendedConfig.Options.byOrdinal(text.func_175206_d())));
            }
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            if (this.gui != null) {
                if (this.gui instanceof GuiTextFieldExtended) {
                    GuiTextFieldExtended text = (GuiTextFieldExtended)this.gui;
                    text.field_146210_g = y;
                    text.func_146194_f();
                    this.mc.field_71466_p.func_78276_b(this.name, x + 64, y + 5, ColorUtils.rgbToDecimal((int)255, (int)255, (int)255));
                }
                if (this.gui instanceof GuiConfigButton) {
                    GuiConfigButton button = (GuiConfigButton)this.gui;
                    button.field_146129_i = y;
                    button.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
                }
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.gui != null && this.gui instanceof GuiConfigButton) {
                GuiConfigButton button = (GuiConfigButton)this.gui;
                if (button.func_146116_c(this.mc, mouseX, mouseY) && mouseEvent == 0) {
                    ExtendedConfig.instance.setOptionValue(button.getOption(), 1);
                    button.field_146126_j = ExtendedConfig.instance.getKeyBinding(ExtendedConfig.Options.byOrdinal(button.field_146127_k));
                    button.func_146113_a(this.mc.func_147118_V());
                }
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.gui != null && this.gui instanceof GuiConfigButton) {
                GuiConfigButton button = (GuiConfigButton)this.gui;
                button.func_146118_a(x, y);
            }
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void saveCurrentValue() {
            if (this.gui != null && this.gui instanceof GuiTextFieldExtended) {
                GuiTextFieldExtended text = (GuiTextFieldExtended)this.gui;
                ExtendedConfig.instance.setOptionStringValue(text.getOption(), text.func_146179_b());
                ColorUtils.stringToRGB((String)text.func_146179_b(), (boolean)true, (String)text.getOption().getTranslation());
            }
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseEvent) {
            if (this.gui != null && this.gui instanceof GuiTextFieldExtended) {
                GuiTextFieldExtended text = (GuiTextFieldExtended)this.gui;
                text.func_146192_a(mouseX, mouseY, mouseEvent);
            }
        }

        public void updateCursorCounter() {
            if (this.gui != null && this.gui instanceof GuiTextFieldExtended) {
                GuiTextFieldExtended text = (GuiTextFieldExtended)this.gui;
                text.func_146178_a();
            }
        }

        public void textboxKeyTyped(char typedChar, int keyCode) {
            if (this.gui != null && this.gui instanceof GuiTextFieldExtended) {
                GuiTextFieldExtended text = (GuiTextFieldExtended)this.gui;
                text.func_146201_a(typedChar, keyCode);
            }
        }

        public GuiTextFieldExtended getTextField() {
            if (this.gui instanceof GuiTextFieldExtended) {
                return (GuiTextFieldExtended)this.gui;
            }
            return null;
        }
    }
}

