/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.gui.config;

import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stevekung.mods.indicatia.config.EnumEquipment;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.event.HUDRenderEventHandler;
import stevekung.mods.indicatia.renderer.HUDInfo;
import stevekung.mods.indicatia.renderer.KeystrokeRenderer;
import stevekung.mods.indicatia.utils.InfoUtils;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class GuiRenderPreview
extends GuiScreen {
    private final GuiScreen parent;
    private final String type;

    public GuiRenderPreview(GuiScreen parent, String type) {
        this.parent = parent;
        this.type = type;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.type.equals("offset")) {
            KeystrokeRenderer.render(this.field_146297_k);
            HUDInfo.renderPotionHUD(this.field_146297_k);
            if (EnumEquipment.Direction.getById(ExtendedConfig.instance.equipmentDirection).equalsIgnoreCase("vertical")) {
                HUDInfo.renderVerticalEquippedItems(this.field_146297_k);
            } else {
                HUDInfo.renderHorizontalEquippedItems(this.field_146297_k);
            }
        }
        if (this.type.equals("render_info")) {
            float fontHeight;
            ScaledResolution res;
            int i;
            String text;
            LinkedList<String> leftInfo = new LinkedList<String>();
            LinkedList<String> rightInfo = new LinkedList<String>();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            HUDInfo.renderVerticalEquippedItems(this.field_146297_k);
            if (!this.field_146297_k.func_71356_B()) {
                leftInfo.add(HUDInfo.getPing());
                leftInfo.add(HUDInfo.getPingToSecond());
                if (this.field_146297_k.func_181540_al()) {
                    leftInfo.add(HUDInfo.getRealmName(this.field_146297_k));
                }
                if (this.field_146297_k.func_147104_D() != null) {
                    leftInfo.add(HUDInfo.getServerIP(this.field_146297_k));
                }
            }
            leftInfo.add(HUDInfo.getFPS());
            leftInfo.add(HUDInfo.getXYZ(this.field_146297_k));
            if (this.field_146297_k.field_71439_g.field_71093_bK == -1) {
                leftInfo.add(HUDInfo.getOverworldXYZFromNether(this.field_146297_k));
            }
            leftInfo.add(HUDInfo.renderDirection(this.field_146297_k));
            leftInfo.add(HUDInfo.getBiome(this.field_146297_k));
            if (this.field_146297_k.field_71439_g.field_71093_bK == 0) {
                String isSlimeChunk = InfoUtils.INSTANCE.isSlimeChunk(this.field_146297_k.field_71439_g.func_180425_c()) ? "Yes" : "No";
                leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.slimeChunkColor).toColoredFont() + "Slime Chunk: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.slimeChunkValueColor).toColoredFont() + isSlimeChunk);
            }
            leftInfo.add(HUDInfo.getCPS());
            leftInfo.add(HUDInfo.getRCPS());
            if (!HUDRenderEventHandler.topDonator.isEmpty()) {
                text = ExtendedConfig.instance.topDonatorText.isEmpty() ? "" : ExtendedConfig.instance.topDonatorText + TextFormatting.RESET + " ";
                leftInfo.add(text + HUDRenderEventHandler.topDonator);
            }
            if (!HUDRenderEventHandler.recentDonator.isEmpty()) {
                text = ExtendedConfig.instance.recentDonatorText.isEmpty() ? "" : ExtendedConfig.instance.recentDonatorText + TextFormatting.RESET + " ";
                leftInfo.add(text + HUDRenderEventHandler.recentDonator);
            }
            if (server != null) {
                double overallTPS = (double)HUDRenderEventHandler.mean(server.field_71311_j) * 1.0E-6;
                double tps = Math.min(1000.0 / overallTPS, 20.0);
                leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "Overall TPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + HUDRenderEventHandler.tpsFormat.format(overallTPS));
                for (Integer dimensionIds : DimensionManager.getIDs()) {
                    double dimensionTPS = (double)HUDRenderEventHandler.mean((long[])server.worldTickTimes.get(dimensionIds)) * 1.0E-6;
                    leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "Dimension " + server.func_71218_a((int)dimensionIds.intValue()).field_73011_w.func_186058_p().func_186065_b() + " " + dimensionIds + ": " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + HUDRenderEventHandler.tpsFormat.format(dimensionTPS));
                }
                leftInfo.add(ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsColor).toColoredFont() + "TPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.tpsValueColor).toColoredFont() + HUDRenderEventHandler.tpsFormat.format(tps));
            }
            rightInfo.add(HUDInfo.getCurrentTime());
            rightInfo.add(HUDInfo.getCurrentGameTime(this.field_146297_k));
            if (this.field_146297_k.field_71441_e.func_72896_J()) {
                rightInfo.add(HUDInfo.getGameWeather(this.field_146297_k));
            }
            rightInfo.add(InfoUtils.INSTANCE.getMoonPhase(this.field_146297_k));
            for (i = 0; i < leftInfo.size(); ++i) {
                res = new ScaledResolution(this.field_146297_k);
                String string = (String)leftInfo.get(i);
                fontHeight = this.field_146289_q.field_78288_b + 1;
                float yOffset = 3.0f + fontHeight * (float)i;
                float xOffset = res.func_78326_a() - 2 - this.field_146289_q.func_78256_a(string);
                if (StringUtils.func_151246_b((String)string)) continue;
                this.field_146289_q.func_175065_a(string, ExtendedConfig.instance.swapRenderInfo ? xOffset : 3.0625f, yOffset, 0xFFFFFF, true);
            }
            for (i = 0; i < rightInfo.size(); ++i) {
                res = new ScaledResolution(this.field_146297_k);
                String string = (String)rightInfo.get(i);
                fontHeight = this.field_146289_q.field_78288_b + 1;
                float yOffset = 3.0f + fontHeight * (float)i;
                float xOffset = res.func_78326_a() - 2 - this.field_146289_q.func_78256_a(string);
                if (StringUtils.func_151246_b((String)string)) continue;
                this.field_146289_q.func_175065_a(string, ExtendedConfig.instance.swapRenderInfo ? 3.0625f : xOffset, yOffset, 0xFFFFFF, true);
            }
        }
        if (this.type.equals("keystroke")) {
            KeystrokeRenderer.render(this.field_146297_k);
        }
    }

    public boolean func_73868_f() {
        return true;
    }
}

