/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.renderer;

import com.google.common.collect.Ordering;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import stevekung.mods.indicatia.config.EnumEquipment;
import stevekung.mods.indicatia.config.EnumPotionStatus;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.integration.GalacticraftPlanetTime;
import stevekung.mods.indicatia.renderer.HorizontalEquipment;
import stevekung.mods.indicatia.utils.InfoUtils;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class HUDInfo {
    public static String getFPS() {
        int fps = Minecraft.func_175610_ah();
        String color = ColorUtils.stringToRGB((String)ExtendedConfig.instance.fpsValueColor).toColoredFont();
        if (fps >= 26 && fps <= 49) {
            color = ColorUtils.stringToRGB((String)ExtendedConfig.instance.fps26And49Color).toColoredFont();
        } else if (fps <= 25) {
            color = ColorUtils.stringToRGB((String)ExtendedConfig.instance.fpsLow25Color).toColoredFont();
        }
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.fpsColor).toColoredFont() + "FPS: " + color + fps;
    }

    public static String getXYZ(Minecraft mc) {
        BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        String nether = mc.field_71439_g.field_71093_bK == -1 ? "Nether " : "";
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.xyzColor).toColoredFont() + nether + "XYZ: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.xyzValueColor).toColoredFont() + x + " " + y + " " + z;
    }

    public static String getOverworldXYZFromNether(Minecraft mc) {
        BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.xyzColor).toColoredFont() + "Overworld XYZ: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.xyzValueColor).toColoredFont() + x * 8 + " " + y + " " + z * 8;
    }

    public static String getBiome(Minecraft mc) {
        BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
        Chunk chunk = mc.field_71441_e.func_175726_f(pos);
        if (mc.field_71441_e.func_175667_e(pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            if (!chunk.func_76621_g()) {
                String biomeName = chunk.func_177411_a(pos, mc.field_71441_e.func_72959_q()).func_185359_l().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
                return ColorUtils.stringToRGB((String)ExtendedConfig.instance.biomeColor).toColoredFont() + "Biome: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.biomeValueColor).toColoredFont() + biomeName;
            }
            return "Waiting for chunk...";
        }
        return "Outside of world...";
    }

    public static String getPing() {
        int responseTime = InfoUtils.INSTANCE.getPing();
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.pingColor).toColoredFont() + "Ping: " + HUDInfo.getResponseTimeColor(responseTime) + responseTime + "ms";
    }

    public static String getPingToSecond() {
        double responseTime = (double)InfoUtils.INSTANCE.getPing() / 1000.0;
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.pingToSecondColor).toColoredFont() + "Delay: " + HUDInfo.getResponseTimeColor((int)(responseTime * 1000.0)) + responseTime + "s";
    }

    public static String getServerIP(Minecraft mc) {
        String ip = ColorUtils.stringToRGB((String)ExtendedConfig.instance.serverIPColor).toColoredFont() + "IP: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.serverIPValueColor).toColoredFont() + mc.func_147104_D().field_78845_b;
        if (ExtendedConfig.instance.serverIPMCVersion) {
            ip = ip + "/" + "1.12.2";
        }
        return ip;
    }

    public static String getRealmName(Minecraft mc) {
        String text = "Realms Server";
        GuiScreen screen = mc.func_147114_u().field_147307_j;
        GuiScreenRealmsProxy screenProxy = (GuiScreenRealmsProxy)screen;
        RealmsScreen realmsScreen = screenProxy.func_154321_a();
        if (!(realmsScreen instanceof RealmsMainScreen)) {
            return text;
        }
        RealmsMainScreen realmsMainScreen = (RealmsMainScreen)realmsScreen;
        RealmsServer realmsServer = null;
        try {
            Field selectedServerId = realmsMainScreen.getClass().getDeclaredField("selectedServerId");
            selectedServerId.setAccessible(true);
            if (!selectedServerId.getType().equals(Long.TYPE)) {
                return text;
            }
            long id = selectedServerId.getLong(realmsMainScreen);
            Method findServer = realmsMainScreen.getClass().getDeclaredMethod("findServer", Long.TYPE);
            findServer.setAccessible(true);
            Object obj = findServer.invoke((Object)realmsMainScreen, id);
            if (!(obj instanceof RealmsServer)) {
                return text;
            }
            realmsServer = (RealmsServer)obj;
        }
        catch (Exception e) {
            return text;
        }
        String name = ColorUtils.stringToRGB((String)ExtendedConfig.instance.serverIPColor).toColoredFont() + "Realms: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.serverIPValueColor).toColoredFont() + realmsServer.getName();
        return name;
    }

    public static String renderDirection(Minecraft mc) {
        String direction;
        int facing;
        Entity entity = mc.func_175606_aa();
        int yaw = (int)entity.field_70177_z + 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        if ((facing = yaw / 45) < 0) {
            facing = 7;
        }
        EnumFacing coordFacing = entity.func_174811_aO();
        String coord = "";
        switch (coordFacing) {
            default: {
                coord = "-Z";
                break;
            }
            case SOUTH: {
                coord = "+Z";
                break;
            }
            case WEST: {
                coord = "-X";
                break;
            }
            case EAST: {
                coord = "+X";
            }
        }
        switch (facing) {
            case 0: {
                direction = "South";
                break;
            }
            case 1: {
                direction = "South West";
                break;
            }
            case 2: {
                direction = "West";
                break;
            }
            case 3: {
                direction = "North West";
                break;
            }
            case 4: {
                direction = "North";
                break;
            }
            case 5: {
                direction = "North East";
                break;
            }
            case 6: {
                direction = "East";
                break;
            }
            case 7: {
                direction = "South East";
                break;
            }
            default: {
                direction = "Unknown";
            }
        }
        direction = direction + " (" + coord + ")";
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.directionColor).toColoredFont() + "Direction: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.directionValueColor).toColoredFont() + direction;
    }

    public static String getCPS() {
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.cpsColor).toColoredFont() + "CPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.cpsValueColor).toColoredFont() + InfoUtils.INSTANCE.getCPS();
    }

    public static String getRCPS() {
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.rcpsColor).toColoredFont() + "RCPS: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.rcpsValueColor).toColoredFont() + InfoUtils.INSTANCE.getRCPS();
    }

    public static String getCurrentTime() {
        Date date = new Date();
        boolean isThai = Calendar.getInstance().getTimeZone().getID().equals("Asia/Bangkok");
        String dateFormat = DateFormat.getDateInstance(2, isThai ? new Locale("th", "TH") : Locale.getDefault()).format(date);
        String timeFormat = DateFormat.getTimeInstance(2, isThai ? new Locale("th", "TH") : Locale.getDefault()).format(date);
        String currentTime = ColorUtils.stringToRGB((String)ExtendedConfig.instance.realTimeDDMMYYValueColor).toColoredFont() + dateFormat + " " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.realTimeHHMMSSValueColor).toColoredFont() + timeFormat;
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.realTimeColor).toColoredFont() + "Time: " + currentTime;
    }

    public static String getCurrentGameTime(Minecraft mc) {
        boolean isSpace = false;
        try {
            Class<?> worldProvider = mc.field_71439_g.field_70170_p.field_73011_w.getClass();
            Class<?> spaceWorld = Class.forName("micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace");
            isSpace = IndicatiaMod.isGalacticraftLoaded && spaceWorld.isAssignableFrom(worldProvider);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isSpace ? GalacticraftPlanetTime.getTime(mc) : InfoUtils.INSTANCE.getCurrentGameTime(mc.field_71441_e.func_72820_D() % 24000L);
    }

    public static String getGameWeather(Minecraft mc) {
        String weather = mc.field_71441_e.func_72896_J() && !mc.field_71441_e.func_72911_I() ? "Raining" : (mc.field_71441_e.func_72896_J() && mc.field_71441_e.func_72911_I() ? "Thunder" : "");
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.gameWeatherColor).toColoredFont() + "Weather: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.gameWeatherValueColor).toColoredFont() + weather;
    }

    public static void renderHorizontalEquippedItems(Minecraft mc) {
        String ordering = EnumEquipment.Ordering.getById(ExtendedConfig.instance.equipmentOrdering);
        ScaledResolution res = new ScaledResolution(mc);
        boolean isRightSide = EnumEquipment.Position.getById(ExtendedConfig.instance.equipmentPosition).equalsIgnoreCase("right");
        int baseXOffset = 2;
        int baseYOffset = ExtendedConfig.instance.armorHUDYOffset;
        ItemStack mainHandItem = mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = mc.field_71439_g.func_184592_cb();
        LinkedList<HorizontalEquipment> element = new LinkedList<HorizontalEquipment>();
        int prevX = 0;
        int rightWidth = 0;
        element.clear();
        switch (ordering) {
            case "default": {
                int i;
                if (!mainHandItem.func_190926_b()) {
                    element.add(new HorizontalEquipment(mainHandItem, false));
                }
                if (!offHandItem.func_190926_b()) {
                    element.add(new HorizontalEquipment(offHandItem, false));
                }
                for (i = 3; i >= 0; --i) {
                    if (((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_190926_b()) continue;
                    element.add(new HorizontalEquipment((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), ((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_77984_f()));
                }
                break;
            }
            case "reverse": {
                int i;
                for (i = 0; i <= 3; ++i) {
                    if (((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_190926_b()) continue;
                    element.add(new HorizontalEquipment((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), ((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_77984_f()));
                }
                if (!mainHandItem.func_190926_b()) {
                    element.add(new HorizontalEquipment(mainHandItem, false));
                }
                if (offHandItem.func_190926_b()) break;
                element.add(new HorizontalEquipment(offHandItem, false));
            }
        }
        for (HorizontalEquipment equipment : element) {
            rightWidth += equipment.getWidth();
        }
        for (HorizontalEquipment equipment : element) {
            int xBaseRight = res.func_78326_a() - rightWidth - baseXOffset;
            equipment.render(isRightSide ? xBaseRight + prevX + equipment.getWidth() : baseXOffset + prevX, baseYOffset);
            prevX += equipment.getWidth();
        }
    }

    public static void renderVerticalEquippedItems(Minecraft mc) {
        String string;
        int i;
        String itemCount;
        String ordering = EnumEquipment.Ordering.getById(ExtendedConfig.instance.equipmentOrdering);
        String status = EnumEquipment.Status.getById(ExtendedConfig.instance.equipmentStatus);
        LinkedList<Object> itemStackList = new LinkedList<Object>();
        LinkedList<String> itemStatusList = new LinkedList<String>();
        LinkedList<String> arrowCountList = new LinkedList<String>();
        ScaledResolution res = new ScaledResolution(mc);
        boolean isRightSide = EnumEquipment.Position.getById(ExtendedConfig.instance.equipmentPosition).equalsIgnoreCase("right");
        int baseXOffset = isRightSide ? res.func_78326_a() - 18 : 2;
        int baseYOffset = ExtendedConfig.instance.armorHUDYOffset;
        ItemStack mainHandItem = mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = mc.field_71439_g.func_184592_cb();
        int arrowCount = HUDInfo.getInventoryArrowCount(mc.field_71439_g.field_71071_by);
        if (ordering.equalsIgnoreCase("reverse")) {
            if (!mainHandItem.func_190926_b()) {
                itemStackList.add(mainHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
                itemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equalsIgnoreCase("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount))));
                if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
            if (!offHandItem.func_190926_b()) {
                itemStackList.add(offHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, offHandItem);
                itemStatusList.add(offHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(offHandItem) : (status.equalsIgnoreCase("none") ? "" : HUDInfo.getItemStackCount(offHandItem, Integer.parseInt(itemCount))));
                if (offHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
        }
        switch (ordering) {
            case "default": {
                String itemCount2;
                for (i = 3; i >= 0; --i) {
                    if (((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_190926_b()) continue;
                    itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, (ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i));
                    itemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b.get(i));
                    itemStatusList.add(((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_77984_f() ? HUDInfo.getArmorDurabilityStatus((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)) : HUDInfo.getItemStackCount((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), Integer.parseInt(itemCount2)));
                    arrowCountList.add("");
                }
                break;
            }
            case "reverse": {
                String itemCount2;
                for (i = 0; i <= 3; ++i) {
                    if (((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_190926_b()) continue;
                    itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, (ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i));
                    itemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b.get(i));
                    itemStatusList.add(((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)).func_77984_f() ? HUDInfo.getArmorDurabilityStatus((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)) : HUDInfo.getItemStackCount((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), Integer.parseInt(itemCount2)));
                    arrowCountList.add("");
                }
                break;
            }
        }
        if (ordering.equalsIgnoreCase("default")) {
            if (!mainHandItem.func_190926_b()) {
                itemStackList.add(mainHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
                itemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equalsIgnoreCase("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount))));
                if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
            if (!offHandItem.func_190926_b()) {
                itemStackList.add(offHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, offHandItem);
                itemStatusList.add(offHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(offHandItem) : (status.equalsIgnoreCase("none") ? "" : HUDInfo.getItemStackCount(offHandItem, Integer.parseInt(itemCount))));
                if (offHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
        }
        for (int i2 = 0; i2 < itemStackList.size(); ++i2) {
            ItemStack itemStack = (ItemStack)itemStackList.get(i2);
            if (itemStackList.isEmpty()) continue;
            int yOffset = baseYOffset + 16 * i2;
            HUDInfo.renderItem(itemStack, baseXOffset, yOffset);
            yOffset += 16;
        }
        float yOffset = 0.0f;
        float fontHeight = 0.0f;
        for (i = 0; i < itemStatusList.size(); ++i) {
            string = (String)itemStatusList.get(i);
            fontHeight = (float)mc.field_71466_p.field_78288_b + 7.0625f;
            if (string.isEmpty()) continue;
            yOffset = (float)(baseYOffset + 4) + fontHeight * (float)i;
            float xOffset = isRightSide ? (float)(res.func_78326_a() - mc.field_71466_p.func_78256_a(string)) - 20.0625f : (float)baseXOffset + 18.0625f;
            mc.field_71466_p.func_175065_a(ColorUtils.stringToRGB((String)ExtendedConfig.instance.equipmentStatusColor).toColoredFont() + string, xOffset, yOffset, 0xFFFFFF, true);
        }
        for (i = 0; i < arrowCountList.size(); ++i) {
            string = (String)arrowCountList.get(i);
            yOffset = (float)(baseYOffset + 8) + fontHeight * (float)i;
            if (string.isEmpty()) continue;
            GlStateManager.func_179097_i();
            ColorUtils.unicodeFontRenderer.func_175065_a(ColorUtils.stringToRGB((String)ExtendedConfig.instance.arrowCountColor).toColoredFont() + string, isRightSide ? (float)(res.func_78326_a() - ColorUtils.unicodeFontRenderer.func_78256_a(string)) - 2.0625f : (float)baseXOffset + 8.0625f, yOffset, 0xFFFFFF, true);
            GlStateManager.func_179126_j();
        }
    }

    public static void renderHotbarEquippedItems(Minecraft mc) {
        int yOffset;
        String string;
        int yOffset2;
        int baseXOffset;
        ItemStack itemStack;
        int i;
        String itemCount;
        int i2;
        LinkedList<Object> leftItemStackList = new LinkedList<Object>();
        LinkedList<String> leftItemStatusList = new LinkedList<String>();
        LinkedList<String> leftArrowCountList = new LinkedList<String>();
        LinkedList<Object> rightItemStackList = new LinkedList<Object>();
        LinkedList<String> rightItemStatusList = new LinkedList<String>();
        LinkedList<String> rightArrowCountList = new LinkedList<String>();
        ScaledResolution res = new ScaledResolution(mc);
        ItemStack mainHandItem = mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = mc.field_71439_g.func_184592_cb();
        int arrowCount = HUDInfo.getInventoryArrowCount(mc.field_71439_g.field_71071_by);
        String status = EnumEquipment.Status.getById(ExtendedConfig.instance.equipmentStatus);
        for (i2 = 2; i2 <= 3; ++i2) {
            if (((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2)).func_190926_b()) continue;
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, (ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2));
            leftItemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b.get(i2));
            leftItemStatusList.add(((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2)).func_77984_f() ? HUDInfo.getArmorDurabilityStatus((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2)) : HUDInfo.getItemStackCount((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2), Integer.parseInt(itemCount)));
            leftArrowCountList.add("");
        }
        for (i2 = 0; i2 <= 1; ++i2) {
            if (((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2)).func_190926_b()) continue;
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, (ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2));
            rightItemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b.get(i2));
            rightItemStatusList.add(((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2)).func_77984_f() ? HUDInfo.getArmorDurabilityStatus((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2)) : HUDInfo.getItemStackCount((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i2), Integer.parseInt(itemCount)));
            rightArrowCountList.add("");
        }
        if (!mainHandItem.func_190926_b()) {
            leftItemStackList.add(mainHandItem);
            String itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
            leftItemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equalsIgnoreCase("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount2))));
            if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                leftArrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                leftArrowCountList.add("");
            }
        }
        if (!offHandItem.func_190926_b()) {
            rightItemStackList.add(offHandItem);
            String itemCount3 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, offHandItem);
            rightItemStatusList.add(offHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(offHandItem) : (status.equalsIgnoreCase("none") ? "" : HUDInfo.getItemStackCount(offHandItem, Integer.parseInt(itemCount3))));
            if (offHandItem.func_77973_b() == Items.field_151031_f) {
                rightArrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                rightArrowCountList.add("");
            }
        }
        for (i = 0; i < leftItemStackList.size(); ++i) {
            itemStack = (ItemStack)leftItemStackList.get(i);
            if (leftItemStackList.isEmpty()) continue;
            baseXOffset = res.func_78326_a() / 2 - 91 - 20;
            yOffset2 = res.func_78328_b() - 16 * i - 40;
            HUDInfo.renderItem(itemStack, baseXOffset, yOffset2);
        }
        for (i = 0; i < rightItemStackList.size(); ++i) {
            itemStack = (ItemStack)rightItemStackList.get(i);
            if (rightItemStackList.isEmpty()) continue;
            baseXOffset = res.func_78326_a() / 2 + 95;
            yOffset2 = res.func_78328_b() - 16 * i - 40;
            HUDInfo.renderItem(itemStack, baseXOffset, yOffset2);
        }
        for (i = 0; i < leftItemStatusList.size(); ++i) {
            string = (String)leftItemStatusList.get(i);
            int stringWidth = mc.field_71466_p.func_78256_a(string);
            float xOffset = res.func_78326_a() / 2 - 114 - stringWidth;
            yOffset = res.func_78328_b() - 16 * i - 36;
            mc.field_71466_p.func_175065_a(ColorUtils.stringToRGB((String)ExtendedConfig.instance.equipmentStatusColor).toColoredFont() + string, xOffset, (float)yOffset, 0xFFFFFF, true);
        }
        for (i = 0; i < rightItemStatusList.size(); ++i) {
            string = (String)rightItemStatusList.get(i);
            float xOffset = res.func_78326_a() / 2 + 114;
            int yOffset3 = res.func_78328_b() - 16 * i - 36;
            mc.field_71466_p.func_175065_a(ColorUtils.stringToRGB((String)ExtendedConfig.instance.equipmentStatusColor).toColoredFont() + string, xOffset, (float)yOffset3, 0xFFFFFF, true);
        }
        for (i = 0; i < leftArrowCountList.size(); ++i) {
            string = (String)leftArrowCountList.get(i);
            int stringWidth = ColorUtils.unicodeFontRenderer.func_78256_a(string);
            float xOffset = res.func_78326_a() / 2 - 90 - stringWidth;
            yOffset = res.func_78328_b() - 16 * i - 32;
            if (string.isEmpty()) continue;
            GlStateManager.func_179097_i();
            ColorUtils.unicodeFontRenderer.func_175065_a(ColorUtils.stringToRGB((String)ExtendedConfig.instance.arrowCountColor).toColoredFont() + string, xOffset, (float)yOffset, 0xFFFFFF, true);
            GlStateManager.func_179126_j();
        }
        for (i = 0; i < rightArrowCountList.size(); ++i) {
            string = (String)rightArrowCountList.get(i);
            float xOffset = res.func_78326_a() / 2 + 104;
            int yOffset4 = res.func_78328_b() - 16 * i - 32;
            if (string.isEmpty()) continue;
            GlStateManager.func_179097_i();
            ColorUtils.unicodeFontRenderer.func_175065_a(ColorUtils.stringToRGB((String)ExtendedConfig.instance.arrowCountColor).toColoredFont() + string, xOffset, (float)yOffset4, 0xFFFFFF, true);
            GlStateManager.func_179126_j();
        }
    }

    public static void renderPotionHUD(Minecraft mc) {
        boolean iconAndTime = EnumPotionStatus.Style.getById(ExtendedConfig.instance.potionHUDStyle).equalsIgnoreCase("icon_and_time");
        boolean right = EnumPotionStatus.Position.getById(ExtendedConfig.instance.potionHUDPosition).equalsIgnoreCase("right");
        boolean showIcon = ExtendedConfig.instance.potionHUDIcon;
        String potionPos = EnumPotionStatus.Position.getById(ExtendedConfig.instance.potionHUDPosition);
        ScaledResolution scaledRes = new ScaledResolution(mc);
        int size = ExtendedConfig.instance.maximumPotionDisplay;
        int length = ExtendedConfig.instance.potionLengthYOffset;
        int lengthOverlap = ExtendedConfig.instance.potionLengthYOffsetOverlap;
        Collection collection = mc.field_71439_g.func_70651_bq();
        int xPotion = 0;
        int yPotion = 0;
        if (potionPos.equalsIgnoreCase("hotbar_left")) {
            xPotion = scaledRes.func_78326_a() / 2 - 91 - 35;
            yPotion = scaledRes.func_78328_b() - 46;
        } else if (potionPos.equalsIgnoreCase("hotbar_right")) {
            xPotion = scaledRes.func_78326_a() / 2 + 91 - 20;
            yPotion = scaledRes.func_78328_b() - 42;
        } else {
            xPotion = right ? scaledRes.func_78326_a() - 32 : -24;
            yPotion = scaledRes.func_78328_b() - 220 + ExtendedConfig.instance.potionHUDYOffset + 90;
        }
        if (!collection.isEmpty()) {
            if (collection.size() > size) {
                length = lengthOverlap / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                float alpha = 1.0f;
                Potion potion = potioneffect.func_188419_a();
                String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                String s1 = LangUtils.translate((String)potion.func_76393_a());
                if (!potioneffect.func_82720_e() && potioneffect.func_76459_b() <= 200) {
                    int j1 = 10 - potioneffect.func_76459_b() / 20;
                    alpha = MathHelper.func_76131_a((float)((float)potioneffect.func_76459_b() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + MathHelper.func_76134_b((float)((float)potioneffect.func_76459_b() * (float)Math.PI / 5.0f)) * MathHelper.func_76131_a((float)((float)j1 / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                if (showIcon) {
                    mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                    potion.renderHUDEffect(potioneffect, (Gui)mc.field_71456_v, xPotion, yPotion, mc.field_71456_v.field_73735_i, alpha);
                    int index = potion.func_76392_e();
                    if (potionPos.equalsIgnoreCase("hotbar_left")) {
                        mc.field_71456_v.func_73729_b(xPotion + 12, yPotion + 6, index % 8 * 18, 198 + index / 8 * 18, 18, 18);
                    } else if (potionPos.equalsIgnoreCase("hotbar_right")) {
                        mc.field_71456_v.func_73729_b(xPotion + 24, yPotion + 6, index % 8 * 18, 198 + index / 8 * 18, 18, 18);
                    } else {
                        mc.field_71456_v.func_73729_b(right ? xPotion + 12 : xPotion + 28, yPotion + 6, index % 8 * 18, 198 + index / 8 * 18, 18, 18);
                    }
                }
                if (potioneffect.func_76458_c() == 1) {
                    s1 = s1 + " " + LangUtils.translate((String)"enchantment.level.2");
                } else if (potioneffect.func_76458_c() == 2) {
                    s1 = s1 + " " + LangUtils.translate((String)"enchantment.level.3");
                } else if (potioneffect.func_76458_c() == 3) {
                    s1 = s1 + " " + LangUtils.translate((String)"enchantment.level.4");
                }
                int stringwidth1 = mc.field_71466_p.func_78256_a(s);
                int stringwidth2 = mc.field_71466_p.func_78256_a(s1);
                if (potionPos.equalsIgnoreCase("hotbar_left")) {
                    if (!iconAndTime) {
                        mc.field_71466_p.func_175065_a(s1, showIcon ? (float)(xPotion + 8 - stringwidth2) : (float)(xPotion + 28 - stringwidth2), (float)(yPotion + 6), ExtendedConfig.instance.alternatePotionHUDTextColor ? potion.func_76401_j() : 0xFFFFFF, true);
                    }
                    mc.field_71466_p.func_175065_a(s, showIcon ? (float)(xPotion + 8 - stringwidth1) : (float)(xPotion + 28 - stringwidth1), iconAndTime ? (float)(yPotion + 11) : (float)(yPotion + 16), ExtendedConfig.instance.alternatePotionHUDTextColor ? potion.func_76401_j() : 0xFFFFFF, true);
                } else if (potionPos.equalsIgnoreCase("hotbar_right")) {
                    if (!iconAndTime) {
                        mc.field_71466_p.func_175065_a(s1, showIcon ? (float)(xPotion + 46) : (float)(xPotion + 28), (float)(yPotion + 6), ExtendedConfig.instance.alternatePotionHUDTextColor ? potion.func_76401_j() : 0xFFFFFF, true);
                    }
                    mc.field_71466_p.func_175065_a(s, showIcon ? (float)(xPotion + 46) : (float)(xPotion + 28), iconAndTime ? (float)(yPotion + 11) : (float)(yPotion + 16), ExtendedConfig.instance.alternatePotionHUDTextColor ? potion.func_76401_j() : 0xFFFFFF, true);
                } else {
                    if (!iconAndTime) {
                        mc.field_71466_p.func_175065_a(s1, right ? (showIcon ? (float)(xPotion + 8 - stringwidth2) : (float)(xPotion + 28 - stringwidth2)) : (showIcon ? (float)(xPotion + 50) : (float)(xPotion + 28)), (float)(yPotion + 6), ExtendedConfig.instance.alternatePotionHUDTextColor ? potion.func_76401_j() : 0xFFFFFF, true);
                    }
                    mc.field_71466_p.func_175065_a(s, right ? (showIcon ? (float)(xPotion + 8 - stringwidth1) : (float)(xPotion + 28 - stringwidth1)) : (showIcon ? (float)(xPotion + 50) : (float)(xPotion + 28)), iconAndTime ? (float)(yPotion + 11) : (float)(yPotion + 16), ExtendedConfig.instance.alternatePotionHUDTextColor ? potion.func_76401_j() : 0xFFFFFF, true);
                }
                yPotion -= length;
            }
        }
    }

    static String getArmorDurabilityStatus(ItemStack itemStack) {
        String status;
        switch (status = EnumEquipment.Status.getById(ExtendedConfig.instance.equipmentStatus)) {
            default: {
                return itemStack.func_77958_k() - itemStack.func_77952_i() + "/" + itemStack.func_77958_k();
            }
            case "percent": {
                return HUDInfo.calculateItemDurabilityPercent(itemStack) + "%";
            }
            case "only_damage": {
                return String.valueOf(itemStack.func_77958_k() - itemStack.func_77952_i());
            }
            case "none": 
        }
        return "";
    }

    private static int calculateItemDurabilityPercent(ItemStack itemStack) {
        return itemStack.func_77958_k() <= 0 ? 0 : 100 - itemStack.func_77952_i() * 100 / itemStack.func_77958_k();
    }

    private static String getResponseTimeColor(int responseTime) {
        if (responseTime >= 200 && responseTime < 300) {
            return ColorUtils.stringToRGB((String)ExtendedConfig.instance.ping200And300Color).toColoredFont();
        }
        if (responseTime >= 300 && responseTime < 500) {
            return ColorUtils.stringToRGB((String)ExtendedConfig.instance.ping300And500Color).toColoredFont();
        }
        if (responseTime >= 500) {
            return ColorUtils.stringToRGB((String)ExtendedConfig.instance.pingMax500Color).toColoredFont();
        }
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.pingValueColor).toColoredFont();
    }

    static void renderItem(ItemStack itemStack, int x, int y) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(itemStack, x, y);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
        if (itemStack.func_77984_f()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179140_f();
            GlStateManager.func_179089_o();
            Minecraft.func_71410_x().func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, itemStack, x, y);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
        }
    }

    static String getInventoryItemCount(InventoryPlayer inventory, ItemStack other) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack playerItems = inventory.func_70301_a(i);
            if (playerItems.func_190926_b() || playerItems.func_77973_b() != other.func_77973_b() || playerItems.func_77952_i() != other.func_77952_i() || !ItemStack.func_77970_a((ItemStack)playerItems, (ItemStack)other)) continue;
            count += playerItems.func_190916_E();
        }
        return String.valueOf(count);
    }

    static int getInventoryArrowCount(InventoryPlayer inventory) {
        int arrowCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemArrow)) continue;
            arrowCount += itemStack.func_190916_E();
        }
        return arrowCount;
    }

    static String getItemStackCount(ItemStack itemStack, int count) {
        return count == 0 || count == 1 || count == 1 && itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("Unbreakable") ? "" : String.valueOf(count);
    }

    static String getArrowStackCount(int count) {
        return count == 0 ? "" : String.valueOf(count);
    }
}

