/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.event.IndicatiaEventHandler;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class InfoUtils {
    public static final InfoUtils INSTANCE = new InfoUtils();
    public Entity extendedPointedEntity;
    private Entity pointedEntity;

    private InfoUtils() {
    }

    public int getPing() {
        NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175102_a(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        if (info != null) {
            if (info.func_178853_c() > 0) {
                return info.func_178853_c();
            }
            return IndicatiaEventHandler.currentServerPing;
        }
        return 0;
    }

    public boolean isHypixel() {
        ServerData server = Minecraft.func_71410_x().func_147104_D();
        return server != null && server.field_78845_b.equals("mc.hypixel.net");
    }

    public int getCPS() {
        Iterator<Long> iterator = IndicatiaEventHandler.LEFT_CLICK.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() >= System.currentTimeMillis() - 1000L) continue;
            iterator.remove();
        }
        return IndicatiaEventHandler.LEFT_CLICK.size();
    }

    public int getRCPS() {
        Iterator<Long> iterator = IndicatiaEventHandler.RIGHT_CLICK.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() >= System.currentTimeMillis() - 1000L) continue;
            iterator.remove();
        }
        return IndicatiaEventHandler.RIGHT_CLICK.size();
    }

    public String getCurrentGameTime(long worldTicks) {
        String ampm;
        int hours = (int)((worldTicks / 1000L + 6L) % 24L);
        int minutes = (int)(60L * (worldTicks % 1000L) / 1000L);
        String sminutes = "" + minutes;
        String shours = "" + hours;
        String string = ampm = hours >= 12 ? "PM" : "AM";
        if (hours <= 9) {
            shours = "0" + hours;
        }
        if (minutes <= 9) {
            sminutes = "0" + minutes;
        }
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.gameTimeColor).toColoredFont() + "Game: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.gameTimeValueColor).toColoredFont() + shours + ":" + sminutes + " " + ampm;
    }

    public String getMoonPhase(Minecraft mc) {
        String status;
        int[] moonPhaseFactors = new int[]{4, 3, 2, 1, 0, -1, -2, -3};
        int phase = moonPhaseFactors[mc.field_71441_e.field_73011_w.func_76559_b(mc.field_71441_e.func_72820_D())];
        switch (phase) {
            default: {
                status = "Full Moon";
                break;
            }
            case 3: {
                status = "Waning Gibbous";
                break;
            }
            case 2: {
                status = "Last Quarter";
                break;
            }
            case 1: {
                status = "Waning Crescent";
                break;
            }
            case 0: {
                status = "New Moon";
                break;
            }
            case -1: {
                status = "Waxing Crescent";
                break;
            }
            case -2: {
                status = "First Quarter";
                break;
            }
            case -3: {
                status = "Waxing Gibbous";
            }
        }
        return ColorUtils.stringToRGB((String)ExtendedConfig.instance.moonPhaseColor).toColoredFont() + "Moon Phase: " + ColorUtils.stringToRGB((String)ExtendedConfig.instance.moonPhaseValueColor).toColoredFont() + status;
    }

    public boolean isSlimeChunk(BlockPos pos) {
        int z;
        int x = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        Random rnd = new Random(ExtendedConfig.instance.slimeChunkSeed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)((z = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16)) * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return rnd.nextInt(10) == 0;
    }

    public void processMouseOverEntity(Minecraft mc) {
        Entity entity = mc.func_175606_aa();
        double distance = 12.0;
        if (entity != null && mc.field_71441_e != null) {
            this.extendedPointedEntity = null;
            mc.field_71476_x = entity.func_174822_a(distance, mc.func_184121_ak());
            Vec3d vec3d = entity.func_174824_e(mc.func_184121_ak());
            boolean flag = false;
            double d1 = distance;
            if (mc.field_71442_b.func_78749_i()) {
                distance = d1 = distance;
            } else if (distance > distance) {
                flag = true;
            }
            if (mc.field_71476_x != null) {
                d1 = mc.field_71476_x.field_72307_f.func_72438_d(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
            this.pointedEntity = null;
            Vec3d vec3d3 = null;
            List list = mc.field_71441_e.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, entry -> entry != null && entry.func_70067_L()));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    this.pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity1.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    this.pointedEntity = entity1;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                this.pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (this.pointedEntity != null && flag && vec3d.func_72438_d(vec3d3) > distance) {
                this.pointedEntity = null;
                mc.field_71476_x = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, null, new BlockPos(vec3d3));
            }
            if (this.pointedEntity != null && (d2 < d1 || mc.field_71476_x == null)) {
                mc.field_71476_x = new RayTraceResult(this.pointedEntity, vec3d3);
                if (this.pointedEntity instanceof EntityLivingBase || this.pointedEntity instanceof EntityItemFrame) {
                    this.extendedPointedEntity = this.pointedEntity;
                }
            }
        }
    }
}

