/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.stevekunglib.client.event.ClientEventHandler;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LoggerSL;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

public class ColorUtils {
    public static FontRenderer unicodeFontRenderer;

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        Minecraft mc = Minecraft.func_71410_x();
        unicodeFontRenderer = new FontRenderer(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.field_71446_o, true);
        if (mc.field_71474_y.field_74363_ab != null) {
            unicodeFontRenderer.func_78264_a(true);
            unicodeFontRenderer.func_78275_b(mc.func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)unicodeFontRenderer);
    }

    public static int rgbToDecimal(int r, int g, int b) {
        return b + 256 * g + 65536 * r;
    }

    public static float[] rgbToFloatArray(int r, int g, int b) {
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int hexToRgb(String color) {
        return ColorUtils.rgbToDecimal(Integer.valueOf(color.substring(1, 3), 16), Integer.valueOf(color.substring(3, 5), 16), Integer.valueOf(color.substring(5, 7), 16));
    }

    public static int to32BitColor(int a, int r, int g, int b) {
        return (a <<= 24) | (r <<= 16) | (g <<= 8) | b;
    }

    public static RGB stringToRGB(String color) {
        return ColorUtils.stringToRGB(color, false, null);
    }

    public static RGB stringToFullRGB(String color) {
        return ColorUtils.stringToFullRGB(color, false, null);
    }

    public static RGB intToRGB(int red, int green, int blue, int alpha) {
        return new RGB(red, green, blue, alpha);
    }

    public static RGB stringToRGB(String color, boolean printException, String optionName) {
        try {
            String[] colorArray = color.split(",");
            float red = Float.parseFloat(colorArray[0]);
            float green = Float.parseFloat(colorArray[1]);
            float blue = Float.parseFloat(colorArray[2]);
            return new RGB(red, green, blue, 255.0f);
        }
        catch (Exception e) {
            if (printException) {
                LoggerSL.error("Invalid RGB Color format at option {}!", optionName);
                ClientUtils.printClientMessage("Invalid RGB Color format at option " + optionName + "!", JsonUtils.red());
                e.printStackTrace();
            }
            return new RGB(true);
        }
    }

    public static RGB stringToFullRGB(String color, boolean printException, String optionName) {
        try {
            String[] colorArray = color.split(",");
            float red = Float.parseFloat(colorArray[0]);
            float green = Float.parseFloat(colorArray[1]);
            float blue = Float.parseFloat(colorArray[2]);
            float alpha = Float.parseFloat(colorArray[3]);
            return new RGB(red, green, blue, alpha);
        }
        catch (Exception e) {
            if (printException) {
                LoggerSL.error("Invalid RGB Color format at option {}!", optionName);
                ClientUtils.printClientMessage("Invalid RGB Color format at option " + optionName + "!", JsonUtils.red());
                e.printStackTrace();
            }
            return new RGB(true);
        }
    }

    public static RGB toRGB(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return new RGB(red, green, blue, alpha);
    }

    public static class RGB {
        float red;
        float green;
        float blue;
        float alpha;
        boolean error;

        public RGB(float red, float green, float blue, float alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        RGB(boolean error) {
            this.error = error;
        }

        public int packedRed() {
            return (int)(this.red * 255.0f);
        }

        public int packedGreen() {
            return (int)(this.green * 255.0f);
        }

        public int packedBlue() {
            return (int)(this.blue * 255.0f);
        }

        public int packedAlpha() {
            return (int)(this.alpha * 255.0f);
        }

        public float floatRed() {
            return this.red / 255.0f;
        }

        public float floatGreen() {
            return this.green / 255.0f;
        }

        public float floatBlue() {
            return this.blue / 255.0f;
        }

        public float floatAlpha() {
            return this.alpha / 255.0f;
        }

        public int red() {
            return (int)this.red;
        }

        public int green() {
            return (int)this.green;
        }

        public int blue() {
            return (int)this.blue;
        }

        public int alpha() {
            return (int)this.alpha;
        }

        public String toColoredFont() {
            if (this.error) {
                if (ClientEventHandler.ticks % 16 >= 0 && ClientEventHandler.ticks % 16 <= 8) {
                    return this.formatColored(255, 85, 85);
                }
                return this.formatColored(255, 255, 255);
            }
            return this.formatColored(this.red(), this.green(), this.blue());
        }

        public int to32Bit() {
            return ColorUtils.to32BitColor(255, this.red(), this.green(), this.blue());
        }

        private String formatColored(int r, int g, int b) {
            int marker = 59136;
            return String.format("%c%c%c", Character.valueOf((char)(marker + (r & 0xFF))), Character.valueOf((char)(marker + (g & 0xFF))), Character.valueOf((char)(marker + (b & 0xFF))));
        }
    }
}

