/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.utils.client;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import stevekung.mods.stevekunglib.utils.enums.EnumStateMapper;

public class ClientRegistryUtils {
    private final String resourcePath;

    public ClientRegistryUtils(@Nonnull String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void registerVariantsName(Item item, String ... variant) {
        for (String name : variant) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.resourcePath + ":" + name, "inventory")});
        }
    }

    public void registerVariantsName(Block block, String ... variant) {
        this.registerVariantsName(Item.func_150898_a((Block)block), variant);
    }

    public void registerModelRender(Block block, String variantName) {
        this.registerModelRender(Item.func_150898_a((Block)block), variantName);
    }

    public void registerModelRender(Item item, String variantName) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(this.resourcePath + ":" + variantName, "inventory"));
    }

    public void registerSpriteTexture(TextureStitchEvent.Pre event, String texture) {
        event.getMap().func_174942_a(new ResourceLocation(this.resourcePath + ":" + texture));
    }

    public static <E extends Entity> void registerEntityRendering(Class<E> entity, IRenderFactory<E> render) {
        RenderingRegistry.registerEntityRenderingHandler(entity, render);
    }

    public static <T extends TileEntity> void registerTileEntityRendering(Class<T> tile, TileEntitySpecialRenderer<? super T> render) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, render);
    }

    public static void registerStateMapper(Block block, IStateMapper mapper) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    public static void registerStateMapper(Block block, EnumStateMapper mapper) {
        ClientRegistryUtils.registerStateMapper(block, (IStateMapper)new StateMap.Builder().func_178442_a(mapper.getProperty()).func_178441_a());
    }

    public static void registerStateMapperSplitVariants(Block block, IProperty property) {
        ClientRegistryUtils.registerStateMapper(block, (IStateMapper)new StateMap.Builder().func_178440_a(property).func_178441_a());
    }

    public static void registerStateMapper(Block block, IProperty ... property) {
        ClientRegistryUtils.registerStateMapper(block, (IStateMapper)new StateMap.Builder().func_178442_a(property).func_178441_a());
    }

    public static void renderTESR(TileEntity tile) {
        ClientRegistryUtils.renderTESR(tile, 0.0);
    }

    public static void renderTESR(TileEntity tile, double yOffset) {
        TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, 0.0, yOffset, 0.0, 0.0f);
    }

    public static void registerBlockColor(IBlockColor blockColor, Block block) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(blockColor, new Block[]{block});
    }

    public static void registerItemColor(IItemColor blockColor, Block block) {
        Minecraft.func_71410_x().getItemColors().func_186731_a(blockColor, new Block[]{block});
    }

    public static void registerItemColor(IItemColor blockColor, Item item) {
        Minecraft.func_71410_x().getItemColors().func_186730_a(blockColor, new Item[]{item});
    }
}

