/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.handler;

import com.google.common.base.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stevekung.mods.indicatia.config.ConfigManager;

public class BlockhitAnimationHandler {
    private final Minecraft mc;
    private KeyBinding zoomKey;

    public BlockhitAnimationHandler(Minecraft mc) {
        this.mc = mc;
        for (KeyBinding key : this.mc.field_71474_y.field_74324_K) {
            if (!key.func_151464_g().contains("of.key.zoom")) continue;
            this.zoomKey = key;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderFirstHand(RenderHandEvent event) {
        if (ConfigManager.enableBlockhitAnimation) {
            event.setCanceled(true);
            if (!this.isZoomed()) {
                boolean isSleep;
                boolean bl = isSleep = this.mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.mc.func_175606_aa()).func_70608_bn();
                if (!(this.mc.field_71474_y.field_74320_O != 0 || isSleep || this.mc.field_71474_y.field_74319_N || this.mc.field_71442_b.func_78747_a())) {
                    this.mc.field_71460_t.func_180436_i();
                    this.renderItemInFirstPerson(event.getPartialTicks());
                    this.mc.field_71460_t.func_175072_h();
                }
            }
        }
    }

    private void renderItemInFirstPerson(float partialTicks) {
        ItemStack itemstack;
        EntityPlayerSP player = this.mc.field_71439_g;
        float swingProgress = player.func_70678_g(partialTicks);
        EnumHand hand = (EnumHand)Objects.firstNonNull((Object)player.field_184622_au, (Object)EnumHand.MAIN_HAND);
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks;
        boolean mainHand = true;
        boolean offHand = true;
        if (player.func_184587_cr() && (itemstack = player.func_184607_cu()) != null && itemstack.func_77973_b() == Items.field_151031_f) {
            EnumHand enumhand1 = player.func_184600_cs();
            mainHand = enumhand1 == EnumHand.MAIN_HAND;
            offHand = !mainHand;
        }
        this.mc.func_175597_ag().func_178101_a(pitch, yaw);
        this.mc.func_175597_ag().func_187464_b();
        this.mc.func_175597_ag().func_187458_c(partialTicks);
        GlStateManager.func_179091_B();
        if (mainHand) {
            float mainHandSwing = hand == EnumHand.MAIN_HAND ? swingProgress : 0.0f;
            float equipProgress = 1.0f - (this.mc.func_175597_ag().field_187470_g + (this.mc.func_175597_ag().field_187469_f - this.mc.func_175597_ag().field_187470_g) * partialTicks);
            this.renderItemInFirstPerson((AbstractClientPlayer)player, partialTicks, pitch, EnumHand.MAIN_HAND, mainHandSwing, this.mc.func_175597_ag().field_187467_d, equipProgress);
        }
        if (offHand) {
            float offHandSwing = hand == EnumHand.OFF_HAND ? swingProgress : 0.0f;
            float equipProgress = 1.0f - (this.mc.func_175597_ag().field_187472_i + (this.mc.func_175597_ag().field_187471_h - this.mc.func_175597_ag().field_187472_i) * partialTicks);
            this.renderItemInFirstPerson((AbstractClientPlayer)player, partialTicks, pitch, EnumHand.OFF_HAND, offHandSwing, this.mc.func_175597_ag().field_187468_e, equipProgress);
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    private void renderItemInFirstPerson(AbstractClientPlayer player, float partialTicks, float rotationPitch, EnumHand hand, float swingProgress, ItemStack itemStack, float equipProgress) {
        boolean mainHand = hand == EnumHand.MAIN_HAND;
        EnumHandSide handSide = mainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        if (itemStack == null) {
            if (mainHand && !player.func_82150_aj()) {
                this.mc.func_175597_ag().func_187456_a(equipProgress, swingProgress, handSide);
            }
        } else if (itemStack.func_77973_b() instanceof ItemMap) {
            if (mainHand && this.mc.func_175597_ag().field_187468_e == null) {
                this.mc.func_175597_ag().func_187463_a(rotationPitch, equipProgress, swingProgress);
            } else {
                this.mc.func_175597_ag().func_187465_a(equipProgress, handSide, swingProgress, itemStack);
            }
        } else {
            boolean rightSide;
            boolean bl = rightSide = handSide == EnumHandSide.RIGHT;
            if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == hand) {
                int handType = rightSide ? 1 : -1;
                float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
                float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                switch (itemStack.func_77975_n()) {
                    case NONE: {
                        this.mc.func_175597_ag().func_187459_b(handSide, equipProgress);
                        this.swingHandOldAnimation(equipProgress, f, f1);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.mc.func_175597_ag().func_187454_a(partialTicks, handSide, itemStack);
                        this.mc.func_175597_ag().func_187459_b(handSide, equipProgress);
                        this.swingHandOldAnimation(equipProgress, f, f1);
                        break;
                    }
                    case BLOCK: {
                        this.mc.func_175597_ag().func_187459_b(handSide, equipProgress);
                        this.swingHandOldAnimation(equipProgress, f, f1);
                        break;
                    }
                    case BOW: {
                        this.mc.func_175597_ag().func_187459_b(handSide, equipProgress);
                        this.swingHandOldAnimation(equipProgress, f, f1);
                        GlStateManager.func_179109_b((float)((float)handType * -0.2785682f), (float)0.18344387f, (float)0.15731531f);
                        GlStateManager.func_179114_b((float)-13.935f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)handType * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)handType * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                        float f5 = (float)itemStack.func_77988_m() - ((float)this.mc.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f6 = f5 / 20.0f;
                        f6 = (f6 * f6 + f6 * 2.0f) / 3.0f;
                        if (f6 > 1.0f) {
                            f6 = 1.0f;
                        }
                        if (f6 > 0.1f) {
                            float f7 = MathHelper.func_76126_a((float)((f5 - 0.1f) * 1.3f));
                            float f3 = f6 - 0.1f;
                            float f4 = f7 * f3;
                            GlStateManager.func_179109_b((float)(f4 * 0.0f), (float)(f4 * 0.004f), (float)(f4 * 0.0f));
                        }
                        GlStateManager.func_179109_b((float)(f6 * 0.0f), (float)(f6 * 0.0f), (float)(f6 * 0.04f));
                        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)(1.0f + f6 * 0.2f));
                        GlStateManager.func_179114_b((float)((float)handType * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                    }
                }
            } else {
                float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
                float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
                int i = rightSide ? 1 : -1;
                GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
                this.mc.func_175597_ag().func_187459_b(handSide, equipProgress);
                this.mc.func_175597_ag().func_187453_a(handSide, swingProgress);
            }
            this.mc.func_175597_ag().func_187462_a((EntityLivingBase)player, itemStack, rightSide ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !rightSide);
        }
        GlStateManager.func_179121_F();
    }

    private boolean isZoomed() {
        return FMLClientHandler.instance().hasOptifine() && this.zoomKey.func_151470_d();
    }

    private void swingHandOldAnimation(float equipProgress, float f, float f1) {
        GlStateManager.func_179109_b((float)0.0f, (float)(equipProgress * 0.6f), (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f1 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
    }
}

