/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.gui.GuiBossOverlayNew;
import stevekung.mods.indicatia.gui.GuiKeystrokeColorSettings;
import stevekung.mods.indicatia.gui.GuiRenderStatusSettings;
import stevekung.mods.indicatia.handler.CommonHandler;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.HUDInfo;
import stevekung.mods.indicatia.renderer.KeystrokeRenderer;
import stevekung.mods.indicatia.util.InfoUtil;
import stevekung.mods.indicatia.util.JsonUtil;
import stevekung.mods.indicatia.util.ModLogger;
import stevekung.mods.indicatia.util.RenderUtil;

public class HUDRenderHandler {
    private final Minecraft mc;
    private GuiBossOverlayNew overlayBoss;
    public static boolean recordEnable;
    private int recTick;
    private static int readFileTicks;
    public static String topDonator;
    public static String recentDonator;
    private static String topDonatorName;
    private static String topDonatorCount;
    private static String recentDonatorName;
    private static String recentDonatorCount;
    private static final DecimalFormat tpsFormat;

    public HUDRenderHandler(Minecraft mc) {
        this.mc = mc;
        this.overlayBoss = new GuiBossOverlayNew();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++readFileTicks;
            this.recTick = recordEnable ? ++this.recTick : 0;
            if (!ExtendedConfig.TOP_DONATOR_FILE_PATH.isEmpty()) {
                HUDRenderHandler.readTopDonatorFile();
            } else {
                topDonator = "";
            }
            if (!ExtendedConfig.RECENT_DONATOR_FILE_PATH.isEmpty()) {
                HUDRenderHandler.readRecentDonatorFile();
            } else {
                recentDonator = "";
            }
        }
    }

    @SubscribeEvent
    public void onPreInfoRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            if (ConfigManager.enableRenderInfo && !this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P && this.mc.field_71439_g != null) {
                float yOffset;
                String string;
                int i;
                ArrayList<String> leftInfo = new ArrayList<String>();
                ArrayList<String> rightInfo = new ArrayList<String>();
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (ConfigManager.enablePing && !this.mc.func_71356_B()) {
                    leftInfo.add(HUDInfo.getPing());
                    if (ConfigManager.enablePingToSecond) {
                        leftInfo.add(HUDInfo.getPingToSecond());
                    }
                }
                if (ConfigManager.enableFPS) {
                    leftInfo.add(HUDInfo.getFPS());
                }
                if (ConfigManager.enableXYZ) {
                    leftInfo.add(HUDInfo.getXYZ(this.mc));
                    if (this.mc.field_71439_g.field_71093_bK == -1) {
                        leftInfo.add(HUDInfo.getOverworldXYZFromNether(this.mc));
                    }
                }
                if (ConfigManager.enableDirection) {
                    leftInfo.add(HUDInfo.renderDirection(this.mc));
                }
                if (ConfigManager.enableBiome) {
                    leftInfo.add(HUDInfo.getBiome(this.mc));
                }
                if (ConfigManager.enableServerIP && this.mc.func_147104_D() != null && !this.mc.func_71356_B()) {
                    leftInfo.add(HUDInfo.getServerIP(this.mc));
                }
                if (ConfigManager.enableSlimeChunkFinder && this.mc.field_71439_g.field_71093_bK == 0) {
                    String isSlimeChunk = InfoUtil.INSTANCE.isSlimeChunk(this.mc.field_71439_g.func_180425_c()) ? "Yes" : "No";
                    leftInfo.add(ColoredFontRenderer.color(ExtendedConfig.SLIME_COLOR_R, ExtendedConfig.SLIME_COLOR_G, ExtendedConfig.SLIME_COLOR_B) + "Slime Chunk: " + ColoredFontRenderer.color(ExtendedConfig.SLIME_VALUE_COLOR_R, ExtendedConfig.SLIME_VALUE_COLOR_G, ExtendedConfig.SLIME_VALUE_COLOR_B) + isSlimeChunk);
                }
                if (ExtendedConfig.CPS_POSITION.equals("left")) {
                    if (ConfigManager.enableCPS) {
                        leftInfo.add(HUDInfo.getCPS());
                    }
                    if (ConfigManager.enableRCPS) {
                        leftInfo.add(HUDInfo.getRCPS());
                    }
                }
                if (ConfigManager.donatorMessagePosition.equals("left")) {
                    String text;
                    if (!topDonator.isEmpty()) {
                        text = ExtendedConfig.TOP_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.TOP_DONATOR_TEXT + TextFormatting.RESET + " ";
                        leftInfo.add(text + topDonator);
                    }
                    if (!recentDonator.isEmpty()) {
                        text = ExtendedConfig.RECENT_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.RECENT_DONATOR_TEXT + TextFormatting.RESET + " ";
                        leftInfo.add(text + recentDonator);
                    }
                }
                if (ConfigManager.enableServerTPS && server != null) {
                    int dimension = this.mc.field_71439_g.field_71093_bK;
                    double overallTPS = (double)HUDRenderHandler.mean(server.field_71311_j) * 1.0E-6;
                    double dimensionTPS = (double)HUDRenderHandler.mean((long[])server.worldTickTimes.get(dimension)) * 1.0E-6;
                    double tps = Math.min(1000.0 / overallTPS, 20.0);
                    leftInfo.add("Overall TPS: " + tpsFormat.format(overallTPS));
                    leftInfo.add("Dimension " + dimension + " TPS: " + tpsFormat.format(dimensionTPS));
                    leftInfo.add("TPS: " + tpsFormat.format(tps));
                }
                if (ConfigManager.enableCurrentRealTime) {
                    rightInfo.add(HUDInfo.getCurrentTime());
                }
                if (ConfigManager.enableCurrentGameTime) {
                    rightInfo.add(HUDInfo.getCurrentGameTime(this.mc));
                }
                if (ConfigManager.enableGameWeather && this.mc.field_71441_e.func_72896_J()) {
                    rightInfo.add(HUDInfo.getGameWeather(this.mc));
                }
                if (ConfigManager.enableMoonPhase) {
                    rightInfo.add(InfoUtil.INSTANCE.getMoonPhase(this.mc));
                }
                if (ExtendedConfig.CPS_POSITION.equals("right")) {
                    if (ConfigManager.enableCPS) {
                        rightInfo.add(HUDInfo.getCPS());
                    }
                    if (ConfigManager.enableRCPS) {
                        rightInfo.add(HUDInfo.getRCPS());
                    }
                }
                if (ConfigManager.donatorMessagePosition.equals("right")) {
                    if (!topDonator.isEmpty()) {
                        String text = ExtendedConfig.TOP_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.TOP_DONATOR_TEXT + TextFormatting.RESET + " ";
                        rightInfo.add(text + topDonator);
                    }
                    if (!recentDonator.isEmpty()) {
                        String text = ExtendedConfig.RECENT_DONATOR_TEXT.isEmpty() ? "" : ExtendedConfig.RECENT_DONATOR_TEXT + TextFormatting.RESET + " ";
                        rightInfo.add(text + recentDonator);
                    }
                }
                if (!this.mc.field_71439_g.func_175149_v() && ConfigManager.enableRenderEquippedItem) {
                    if (ConfigManager.equipmentPosition.equals("hotbar")) {
                        HUDInfo.renderHotbarEquippedItems(this.mc);
                    } else if (ConfigManager.equipmentDirection.equals("vertical")) {
                        HUDInfo.renderVerticalEquippedItems(this.mc);
                    } else {
                        HUDInfo.renderHorizontalEquippedItems(this.mc);
                    }
                }
                if (ConfigManager.enablePotionStatusHUD) {
                    HUDInfo.renderPotionStatusHUD(this.mc);
                }
                for (i = 0; i < leftInfo.size(); ++i) {
                    ScaledResolution res = new ScaledResolution(this.mc);
                    string = (String)leftInfo.get(i);
                    float fontHeight = IndicatiaMod.coloredFontRenderer.field_78288_b + 1;
                    yOffset = 3.0f + fontHeight * (float)i;
                    float xOffset = res.func_78326_a() - 2 - IndicatiaMod.coloredFontRenderer.func_78256_a(string);
                    if (string.isEmpty()) continue;
                    this.mc.field_71424_I.func_76320_a("indicatia_info");
                    IndicatiaMod.coloredFontRenderer.func_175065_a(string, ConfigManager.swapRenderInfoToRight ? xOffset : 3.0625f, yOffset, 0xFFFFFF, true);
                    this.mc.field_71424_I.func_76319_b();
                }
                for (i = 0; i < rightInfo.size(); ++i) {
                    ScaledResolution res = new ScaledResolution(this.mc);
                    string = (String)rightInfo.get(i);
                    float fontHeight = IndicatiaMod.coloredFontRenderer.field_78288_b + 1;
                    yOffset = 3.0f + fontHeight * (float)i;
                    float xOffset = res.func_78326_a() - 2 - IndicatiaMod.coloredFontRenderer.func_78256_a(string);
                    if (string.isEmpty()) continue;
                    this.mc.field_71424_I.func_76320_a("indicatia_info");
                    IndicatiaMod.coloredFontRenderer.func_175065_a(string, ConfigManager.swapRenderInfoToRight ? 3.0625f : xOffset, yOffset, 0xFFFFFF, true);
                    this.mc.field_71424_I.func_76319_b();
                }
            }
            if (recordEnable) {
                ScaledResolution res = new ScaledResolution(this.mc);
                int color = 0xFFFFFF;
                if (this.recTick % 24 >= 0 && this.recTick % 24 <= 12) {
                    color = 0xFF5555;
                }
                IndicatiaMod.coloredFontRenderer.func_175065_a("REC: " + StringUtils.func_76337_a((int)this.recTick), res.func_78326_a() - IndicatiaMod.coloredFontRenderer.func_78256_a("REC: " + StringUtils.func_76337_a((int)this.recTick)) - 2, res.func_78328_b() - 10, color, true);
            }
            if (!this.mc.field_71474_y.field_74319_N && !this.mc.field_71474_y.field_74330_P) {
                if (ConfigManager.enableKeystroke && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiChat || this.mc.field_71462_r instanceof GuiRenderStatusSettings || this.mc.field_71462_r instanceof GuiKeystrokeColorSettings)) {
                    KeystrokeRenderer.init(this.mc);
                }
                if (ConfigManager.enableRenderInfo && ExtendedConfig.CPS_POSITION.equalsIgnoreCase("custom") && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiChat || this.mc.field_71462_r instanceof GuiRenderStatusSettings || this.mc.field_71462_r instanceof GuiKeystrokeColorSettings)) {
                    String space = ConfigManager.enableRCPS ? " " : "";
                    RenderUtil.drawRect(ExtendedConfig.CPS_X_OFFSET, ExtendedConfig.CPS_Y_OFFSET, ExtendedConfig.CPS_X_OFFSET + this.mc.field_71466_p.func_78256_a(HUDInfo.getCPS() + space + HUDInfo.getRCPS()) + 4, ExtendedConfig.CPS_Y_OFFSET + 11, 0x1000000, ExtendedConfig.CPS_OPACITY);
                    this.mc.field_71466_p.func_175065_a(HUDInfo.getCPS() + space + HUDInfo.getRCPS(), (float)(ExtendedConfig.CPS_X_OFFSET + 2), (float)(ExtendedConfig.CPS_Y_OFFSET + 2), 0xFFFFFF, true);
                }
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.PLAYER_LIST && CommonHandler.overlayPlayerList != null) {
            event.setCanceled(true);
            ScoreObjective scoreobjective = this.mc.field_71441_e.func_96441_U().func_96539_a(0);
            NetHandlerPlayClient handler = this.mc.field_71439_g.field_71174_a;
            if (this.mc.field_71474_y.field_74321_H.func_151470_d() && (!this.mc.func_71387_A() || handler.func_175106_d().size() > 1 || scoreobjective != null)) {
                CommonHandler.overlayPlayerList.func_175246_a(true);
                CommonHandler.overlayPlayerList.func_175249_a(event.getResolution().func_78326_a(), this.mc.field_71441_e.func_96441_U(), scoreobjective);
            } else {
                CommonHandler.overlayPlayerList.func_175246_a(false);
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT && ConfigManager.enableChatDepthRender) {
            event.setCanceled(true);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(event.getResolution().func_78328_b() - 48), (float)0.0f);
            GlStateManager.func_179097_i();
            this.mc.field_71456_v.func_146158_b().func_146230_a(this.mc.field_71456_v.func_73834_c());
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && !ConfigManager.enableIngamePotionHUD) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            event.setCanceled(true);
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179147_l();
            this.overlayBoss.func_184051_a();
            GlStateManager.func_179084_k();
        }
    }

    @SubscribeEvent
    public void onRenderHealthStatus(RenderLivingEvent.Specials.Post event) {
        Style color;
        EntityLivingBase entity = event.getEntity();
        float health = entity.func_110143_aJ();
        boolean halfHealth = health <= entity.func_110138_aP() / 2.0f;
        boolean halfHealth1 = health <= entity.func_110138_aP() / 4.0f;
        float range = entity.func_70093_af() ? RenderLivingBase.NAME_TAG_RANGE_SNEAK : RenderLivingBase.NAME_TAG_RANGE;
        double distance = entity.func_70068_e(this.mc.func_175606_aa());
        String mode = ConfigManager.healthStatusMode;
        boolean flag = mode.equals("disable") ? false : (mode.equals("pointed") ? entity == InfoUtil.INSTANCE.extendedPointedEntity : true);
        JsonUtil json = IndicatiaMod.json;
        Style style = halfHealth ? json.red() : (color = halfHealth1 ? json.darkRed() : json.green());
        if (!(!(distance < (double)(range * range)) || this.mc.field_71474_y.field_74319_N || entity.func_82150_aj() || !flag || entity instanceof EntityPlayerSP || entity instanceof EntityArmorStand || InfoUtil.INSTANCE.isHypixel())) {
            String heart = json.text("\u2764 ").func_150255_a(color).func_150254_d();
            RenderUtil.renderEntityHealth(entity, heart + String.format("%.1f", Float.valueOf(health)), event.getX(), event.getY(), event.getZ());
        }
    }

    private static void readTopDonatorFile() {
        File file = new File("/" + ExtendedConfig.TOP_DONATOR_FILE_PATH);
        String text = "";
        if (readFileTicks % ConfigManager.readFileInterval == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    text = line.replace("\r", "");
                }
                String[] textSplit = text.split(" ");
                topDonatorName = textSplit[0];
                topDonatorCount = textSplit[1];
            }
            catch (Exception e) {
                ModLogger.error("Couldn't read text file from path {}", file.getPath());
                e.printStackTrace();
                topDonator = TextFormatting.RED + "Cannot read text file!";
            }
        }
        topDonator = ColoredFontRenderer.color(ExtendedConfig.TOP_DONATE_NAME_COLOR_R, ExtendedConfig.TOP_DONATE_NAME_COLOR_G, ExtendedConfig.TOP_DONATE_NAME_COLOR_B) + topDonatorName + ColoredFontRenderer.color(ExtendedConfig.TOP_DONATE_COUNT_COLOR_R, ExtendedConfig.TOP_DONATE_COUNT_COLOR_G, ExtendedConfig.TOP_DONATE_COUNT_COLOR_B) + " " + topDonatorCount.replace("THB", "") + "THB";
    }

    private static void readRecentDonatorFile() {
        File file = new File("/" + ExtendedConfig.RECENT_DONATOR_FILE_PATH);
        String text = "";
        if (readFileTicks % ConfigManager.readFileInterval == 0) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    text = line.replace("\r", "");
                }
                String[] textSplit = text.split(" ");
                recentDonatorName = textSplit[0];
                recentDonatorCount = textSplit[1];
            }
            catch (Exception e) {
                ModLogger.error("Couldn't read text file from path {}", file.getPath());
                e.printStackTrace();
                recentDonator = TextFormatting.RED + "Cannot read text file!";
            }
        }
        recentDonator = ColoredFontRenderer.color(ExtendedConfig.RECENT_DONATE_NAME_COLOR_R, ExtendedConfig.RECENT_DONATE_NAME_COLOR_G, ExtendedConfig.RECENT_DONATE_NAME_COLOR_B) + recentDonatorName + ColoredFontRenderer.color(ExtendedConfig.RECENT_DONATE_COUNT_COLOR_R, ExtendedConfig.RECENT_DONATE_COUNT_COLOR_G, ExtendedConfig.RECENT_DONATE_COUNT_COLOR_B) + " " + recentDonatorCount.replace("THB", "") + "THB";
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    static {
        topDonator = "";
        recentDonator = "";
        topDonatorName = "";
        topDonatorCount = "";
        recentDonatorName = "";
        recentDonatorCount = "";
        tpsFormat = new DecimalFormat("########0.00");
    }
}

