/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.util.AutoLogin;
import stevekung.mods.indicatia.util.AutoLoginFunction;
import stevekung.mods.indicatia.util.Base64Util;
import stevekung.mods.indicatia.util.GameProfileUtil;

public class PlayerChatHandler {
    private final Minecraft mc;

    public PlayerChatHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.mc.func_152344_a(() -> MinecraftForge.EVENT_BUS.register((Object)new PlayerRunCommandHandler()));
    }

    public class PlayerRunCommandHandler {
        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof EntityPlayerSP) {
                EntityPlayerSP player = (EntityPlayerSP)event.getEntity();
                ServerData data = PlayerChatHandler.this.mc.func_147104_D();
                this.runAutoLoginCommand(player, data);
                this.runAutoLoginFunction(player, data);
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }

        private void runAutoLoginCommand(EntityPlayerSP player, ServerData data) {
            if (data != null) {
                for (AutoLogin.AutoLoginData login : ExtendedConfig.loginData.getAutoLoginList()) {
                    if (!data.field_78845_b.equalsIgnoreCase(login.getServerIP()) || !GameProfileUtil.getUUID().equals(login.getUUID())) continue;
                    player.func_71165_d(login.getCommand() + Base64Util.decode(login.getValue()));
                }
            }
        }

        private void runAutoLoginFunction(EntityPlayerSP player, ServerData data) {
            if (data != null) {
                for (AutoLogin.AutoLoginData login : ExtendedConfig.loginData.getAutoLoginList()) {
                    if (!data.field_78845_b.equalsIgnoreCase(login.getServerIP()) || !GameProfileUtil.getUUID().equals(login.getUUID()) || login.getFunction().isEmpty()) continue;
                    AutoLoginFunction.functionValue = login.getFunction();
                    AutoLoginFunction.run = true;
                }
            }
        }
    }
}

