/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.renderer;

import com.google.common.collect.Ordering;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.HorizontalEquipment;
import stevekung.mods.indicatia.util.InfoUtil;
import stevekung.mods.indicatia.util.LangUtil;

public class HUDInfo {
    public static String getFPS() {
        int fps = Minecraft.func_175610_ah();
        String color = ColoredFontRenderer.color(ExtendedConfig.FPS_M40_COLOR_R, ExtendedConfig.FPS_M40_COLOR_G, ExtendedConfig.FPS_M40_COLOR_B);
        if (fps > 25 && fps <= 40) {
            color = ColoredFontRenderer.color(ExtendedConfig.FPS_26_40_COLOR_R, ExtendedConfig.FPS_26_40_COLOR_G, ExtendedConfig.FPS_26_40_COLOR_B);
        } else if (fps <= 25) {
            color = ColoredFontRenderer.color(ExtendedConfig.FPS_L25_COLOR_R, ExtendedConfig.FPS_L25_COLOR_G, ExtendedConfig.FPS_L25_COLOR_B);
        }
        return ColoredFontRenderer.color(ExtendedConfig.FPS_COLOR_R, ExtendedConfig.FPS_COLOR_G, ExtendedConfig.FPS_COLOR_B) + "FPS: " + color + fps;
    }

    public static String getXYZ(Minecraft mc) {
        BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        String nether = mc.field_71439_g.field_71093_bK == -1 ? "Nether " : "";
        return ColoredFontRenderer.color(ExtendedConfig.XYZ_COLOR_R, ExtendedConfig.XYZ_COLOR_G, ExtendedConfig.XYZ_COLOR_B) + nether + "XYZ: " + ColoredFontRenderer.color(ExtendedConfig.XYZ_VALUE_COLOR_R, ExtendedConfig.XYZ_VALUE_COLOR_G, ExtendedConfig.XYZ_VALUE_COLOR_B) + x + " " + y + " " + z;
    }

    public static String getOverworldXYZFromNether(Minecraft mc) {
        BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return ColoredFontRenderer.color(ExtendedConfig.XYZ_COLOR_R, ExtendedConfig.XYZ_COLOR_G, ExtendedConfig.XYZ_COLOR_B) + "Overworld XYZ: " + ColoredFontRenderer.color(ExtendedConfig.XYZ_VALUE_COLOR_R, ExtendedConfig.XYZ_VALUE_COLOR_G, ExtendedConfig.XYZ_VALUE_COLOR_B) + x * 8 + " " + y + " " + z * 8;
    }

    public static String getBiome(Minecraft mc) {
        BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
        Chunk chunk = mc.field_71441_e.func_175726_f(pos);
        if (mc.field_71441_e.func_175667_e(pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            if (!chunk.func_76621_g()) {
                String biomeName = chunk.func_177411_a(pos, mc.field_71441_e.func_72959_q()).func_185359_l().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
                return ColoredFontRenderer.color(ExtendedConfig.BIOME_COLOR_R, ExtendedConfig.BIOME_COLOR_G, ExtendedConfig.BIOME_COLOR_B) + "Biome: " + ColoredFontRenderer.color(ExtendedConfig.BIOME_VALUE_COLOR_R, ExtendedConfig.BIOME_VALUE_COLOR_G, ExtendedConfig.BIOME_VALUE_COLOR_B) + biomeName;
            }
            return "Waiting for chunk...";
        }
        return "Outside of world...";
    }

    public static String getPing() {
        int responseTime = InfoUtil.INSTANCE.getPing();
        return ColoredFontRenderer.color(ExtendedConfig.PING_COLOR_R, ExtendedConfig.PING_COLOR_G, ExtendedConfig.PING_COLOR_B) + "Ping: " + HUDInfo.getResponseTimeColor(responseTime) + responseTime + "ms";
    }

    public static String getPingToSecond() {
        double responseTime = (double)InfoUtil.INSTANCE.getPing() / 1000.0;
        return ColoredFontRenderer.color(ExtendedConfig.PING_COLOR_R, ExtendedConfig.PING_COLOR_G, ExtendedConfig.PING_COLOR_B) + "Delay: " + HUDInfo.getResponseTimeColor((int)(responseTime * 1000.0)) + responseTime + "s";
    }

    public static String getServerIP(Minecraft mc) {
        String ip = ColoredFontRenderer.color(ExtendedConfig.IP_COLOR_R, ExtendedConfig.IP_COLOR_G, ExtendedConfig.IP_COLOR_B) + "IP: " + ColoredFontRenderer.color(ExtendedConfig.IP_VALUE_COLOR_R, ExtendedConfig.IP_VALUE_COLOR_G, ExtendedConfig.IP_VALUE_COLOR_B) + mc.func_147104_D().field_78845_b;
        if (ConfigManager.enableServerIPMCVersion) {
            ip = ip + "/" + IndicatiaMod.MC_VERSION;
        }
        return ip;
    }

    public static String renderDirection(Minecraft mc) {
        String direction;
        int facing;
        Entity entity = mc.func_175606_aa();
        int yaw = (int)entity.field_70177_z + 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        if ((facing = yaw / 45) < 0) {
            facing = 7;
        }
        switch (facing) {
            case 0: {
                direction = "South";
                break;
            }
            case 1: {
                direction = "South West";
                break;
            }
            case 2: {
                direction = "West";
                break;
            }
            case 3: {
                direction = "North West";
                break;
            }
            case 4: {
                direction = "North";
                break;
            }
            case 5: {
                direction = "North East";
                break;
            }
            case 6: {
                direction = "East";
                break;
            }
            case 7: {
                direction = "South East";
                break;
            }
            default: {
                direction = "Unknown";
            }
        }
        return ColoredFontRenderer.color(ExtendedConfig.DIRECTION_COLOR_R, ExtendedConfig.DIRECTION_COLOR_G, ExtendedConfig.DIRECTION_COLOR_B) + "Direction: " + ColoredFontRenderer.color(ExtendedConfig.DIRECTION_VALUE_COLOR_R, ExtendedConfig.DIRECTION_VALUE_COLOR_G, ExtendedConfig.DIRECTION_VALUE_COLOR_B) + direction;
    }

    public static String getCPS() {
        return ColoredFontRenderer.color(ExtendedConfig.CPS_COLOR_R, ExtendedConfig.CPS_COLOR_G, ExtendedConfig.CPS_COLOR_B) + "CPS: " + ColoredFontRenderer.color(ExtendedConfig.CPS_VALUE_COLOR_R, ExtendedConfig.CPS_VALUE_COLOR_G, ExtendedConfig.CPS_VALUE_COLOR_B) + InfoUtil.INSTANCE.getCPS();
    }

    public static String getRCPS() {
        return ColoredFontRenderer.color(ExtendedConfig.RCPS_COLOR_R, ExtendedConfig.RCPS_COLOR_G, ExtendedConfig.RCPS_COLOR_B) + "RCPS: " + ColoredFontRenderer.color(ExtendedConfig.RCPS_VALUE_COLOR_R, ExtendedConfig.RCPS_VALUE_COLOR_G, ExtendedConfig.RCPS_VALUE_COLOR_B) + InfoUtil.INSTANCE.getRCPS();
    }

    public static String getCurrentTime() {
        String currentTime = new SimpleDateFormat("d/M/yyyy HH:mm:ss a", Locale.ENGLISH).format(new Date());
        currentTime = "Time: " + currentTime.replace("\u0e2b\u0e25\u0e31\u0e07\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", "PM").replace("\u0e01\u0e48\u0e2d\u0e19\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", "AM");
        return currentTime;
    }

    public static String getCurrentGameTime(Minecraft mc) {
        return InfoUtil.INSTANCE.getCurrentGameTime(mc.field_71441_e.func_72820_D() % 24000L);
    }

    public static String getGameWeather(Minecraft mc) {
        String weather = mc.field_71441_e.func_72896_J() && !mc.field_71441_e.func_72911_I() ? "Raining" : (mc.field_71441_e.func_72896_J() && mc.field_71441_e.func_72911_I() ? "Thunder" : "");
        return "Weather: " + weather;
    }

    public static void renderHorizontalEquippedItems(Minecraft mc) {
        String ordering = ConfigManager.equipmentOrdering;
        ScaledResolution res = new ScaledResolution(mc);
        boolean isRightSide = ConfigManager.equipmentPosition.equals("right");
        int baseXOffset = 2;
        int baseYOffset = ExtendedConfig.ARMOR_STATUS_OFFSET;
        ItemStack mainHandItem = mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = mc.field_71439_g.func_184592_cb();
        ArrayList<HorizontalEquipment> element = new ArrayList<HorizontalEquipment>();
        int prevX = 0;
        int rightWidth = 0;
        element.clear();
        if (ordering.equals("reverse")) {
            if (mainHandItem != null) {
                element.add(new HorizontalEquipment(mainHandItem, false));
            }
            if (offHandItem != null) {
                element.add(new HorizontalEquipment(offHandItem, false));
            }
        }
        switch (ordering) {
            case "default": {
                int i;
                for (i = 3; i >= 0; --i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    element.add(new HorizontalEquipment(mc.field_71439_g.field_71071_by.field_70460_b[i], mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f()));
                }
                break;
            }
            case "reverse": {
                int i;
                for (i = 0; i <= 3; ++i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    element.add(new HorizontalEquipment(mc.field_71439_g.field_71071_by.field_70460_b[i], mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f()));
                }
                break;
            }
        }
        if (ordering.equals("default")) {
            if (mainHandItem != null) {
                element.add(new HorizontalEquipment(mainHandItem, false));
            }
            if (offHandItem != null) {
                element.add(new HorizontalEquipment(offHandItem, false));
            }
        }
        for (HorizontalEquipment equipment : element) {
            rightWidth += equipment.getWidth();
        }
        for (HorizontalEquipment equipment : element) {
            int xBaseRight = res.func_78326_a() - rightWidth - baseXOffset;
            equipment.render(isRightSide ? xBaseRight + prevX + equipment.getWidth() : baseXOffset + prevX, baseYOffset);
            prevX += equipment.getWidth();
        }
    }

    public static void renderVerticalEquippedItems(Minecraft mc) {
        String string;
        int i;
        String itemCount;
        String ordering = ConfigManager.equipmentOrdering;
        String status = ConfigManager.equipmentStatus;
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        ArrayList<String> itemStatusList = new ArrayList<String>();
        ArrayList<String> arrowCountList = new ArrayList<String>();
        ScaledResolution res = new ScaledResolution(mc);
        boolean isRightSide = ConfigManager.equipmentPosition.equals("right");
        int baseXOffset = isRightSide ? res.func_78326_a() - 18 : 2;
        int baseYOffset = ExtendedConfig.ARMOR_STATUS_OFFSET;
        ItemStack mainHandItem = mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = mc.field_71439_g.func_184592_cb();
        int arrowCount = HUDInfo.getInventoryArrowCount(mc.field_71439_g.field_71071_by);
        if (ordering.equals("reverse")) {
            if (mainHandItem != null) {
                itemStackList.add(mainHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
                itemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount))));
                if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
            if (offHandItem != null) {
                itemStackList.add(offHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, offHandItem);
                itemStatusList.add(offHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(offHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(offHandItem, Integer.parseInt(itemCount))));
                if (offHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
        }
        switch (ordering) {
            case "default": {
                String itemCount2;
                for (i = 3; i >= 0; --i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i], Integer.parseInt(itemCount2)));
                    arrowCountList.add("");
                }
                break;
            }
            case "reverse": {
                String itemCount2;
                for (i = 0; i <= 3; ++i) {
                    if (mc.field_71439_g.field_71071_by.field_70460_b[i] == null) continue;
                    itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i]);
                    itemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i], Integer.parseInt(itemCount2)));
                    arrowCountList.add("");
                }
                break;
            }
        }
        if (ordering.equals("default")) {
            if (mainHandItem != null) {
                itemStackList.add(mainHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
                itemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount))));
                if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
            if (offHandItem != null) {
                itemStackList.add(offHandItem);
                itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, offHandItem);
                itemStatusList.add(offHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(offHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(offHandItem, Integer.parseInt(itemCount))));
                if (offHandItem.func_77973_b() == Items.field_151031_f) {
                    arrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
                } else {
                    arrowCountList.add("");
                }
            }
        }
        for (int i2 = 0; i2 < itemStackList.size(); ++i2) {
            ItemStack itemStack = (ItemStack)itemStackList.get(i2);
            mc.field_71424_I.func_76320_a("item_stack_render");
            if (!itemStackList.isEmpty()) {
                int yOffset = baseYOffset + 16 * i2;
                HUDInfo.renderItem(itemStack, baseXOffset, yOffset);
                yOffset += 16;
            }
            mc.field_71424_I.func_76319_b();
        }
        float yOffset = 0.0f;
        float fontHeight = 0.0f;
        for (i = 0; i < itemStatusList.size(); ++i) {
            string = (String)itemStatusList.get(i);
            fontHeight = (float)IndicatiaMod.coloredFontRenderer.field_78288_b + 7.0625f;
            if (string.isEmpty()) continue;
            yOffset = (float)(baseYOffset + 4) + fontHeight * (float)i;
            mc.field_71424_I.func_76320_a("armor_durability_info");
            float xOffset = isRightSide ? (float)(res.func_78326_a() - mc.field_71466_p.func_78256_a(string)) - 20.0625f : (float)baseXOffset + 18.0625f;
            IndicatiaMod.coloredFontRenderer.func_175065_a(ColoredFontRenderer.color(ExtendedConfig.EQUIPMENT_COLOR_R, ExtendedConfig.EQUIPMENT_COLOR_G, ExtendedConfig.EQUIPMENT_COLOR_B) + string, xOffset, yOffset, 0xFFFFFF, true);
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < arrowCountList.size(); ++i) {
            string = (String)arrowCountList.get(i);
            yOffset = (float)(baseYOffset + 8) + fontHeight * (float)i;
            if (string.isEmpty()) continue;
            mc.field_71424_I.func_76320_a("arrow_count");
            GlStateManager.func_179097_i();
            IndicatiaMod.coloredFontRenderer.func_78264_a(true);
            IndicatiaMod.coloredFontRenderer.func_175065_a(ColoredFontRenderer.color(ExtendedConfig.ARROW_COUNT_COLOR_R, ExtendedConfig.ARROW_COUNT_COLOR_G, ExtendedConfig.ARROW_COUNT_COLOR_B) + string, isRightSide ? (float)(res.func_78326_a() - mc.field_71466_p.func_78256_a(string)) - 2.0625f : (float)baseXOffset + 8.0625f, yOffset, 0xFFFFFF, true);
            IndicatiaMod.coloredFontRenderer.func_78264_a(false);
            GlStateManager.func_179126_j();
            mc.field_71424_I.func_76319_b();
        }
    }

    public static void renderHotbarEquippedItems(Minecraft mc) {
        int yOffset;
        String string;
        int yOffset2;
        int baseXOffset;
        ItemStack itemStack;
        int i;
        String itemCount;
        int i2;
        ArrayList<ItemStack> leftItemStackList = new ArrayList<ItemStack>();
        ArrayList<String> leftItemStatusList = new ArrayList<String>();
        ArrayList<String> leftArrowCountList = new ArrayList<String>();
        ArrayList<ItemStack> rightItemStackList = new ArrayList<ItemStack>();
        ArrayList<String> rightItemStatusList = new ArrayList<String>();
        ArrayList<String> rightArrowCountList = new ArrayList<String>();
        ScaledResolution res = new ScaledResolution(mc);
        ItemStack mainHandItem = mc.field_71439_g.func_184614_ca();
        ItemStack offHandItem = mc.field_71439_g.func_184592_cb();
        int arrowCount = HUDInfo.getInventoryArrowCount(mc.field_71439_g.field_71071_by);
        String status = ConfigManager.equipmentStatus;
        for (i2 = 2; i2 <= 3; ++i2) {
            if (mc.field_71439_g.field_71071_by.field_70460_b[i2] == null) continue;
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            leftItemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            leftItemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i2]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i2], Integer.parseInt(itemCount)));
            leftArrowCountList.add("");
        }
        for (i2 = 0; i2 <= 1; ++i2) {
            if (mc.field_71439_g.field_71071_by.field_70460_b[i2] == null) continue;
            itemCount = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            rightItemStackList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2]);
            rightItemStatusList.add(mc.field_71439_g.field_71071_by.field_70460_b[i2].func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mc.field_71439_g.field_71071_by.field_70460_b[i2]) : HUDInfo.getItemStackCount(mc.field_71439_g.field_71071_by.field_70460_b[i2], Integer.parseInt(itemCount)));
            rightArrowCountList.add("");
        }
        if (mainHandItem != null) {
            leftItemStackList.add(mainHandItem);
            String itemCount2 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, mainHandItem);
            leftItemStatusList.add(mainHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(mainHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(mainHandItem, Integer.parseInt(itemCount2))));
            if (mainHandItem.func_77973_b() == Items.field_151031_f) {
                leftArrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                leftArrowCountList.add("");
            }
        }
        if (offHandItem != null) {
            rightItemStackList.add(offHandItem);
            String itemCount3 = HUDInfo.getInventoryItemCount(mc.field_71439_g.field_71071_by, offHandItem);
            rightItemStatusList.add(offHandItem.func_77984_f() ? HUDInfo.getArmorDurabilityStatus(offHandItem) : (status.equals("none") ? "" : HUDInfo.getItemStackCount(offHandItem, Integer.parseInt(itemCount3))));
            if (offHandItem.func_77973_b() == Items.field_151031_f) {
                rightArrowCountList.add(HUDInfo.getArrowStackCount(arrowCount));
            } else {
                rightArrowCountList.add("");
            }
        }
        for (i = 0; i < leftItemStackList.size(); ++i) {
            itemStack = (ItemStack)leftItemStackList.get(i);
            mc.field_71424_I.func_76320_a("item_stack_render");
            if (!leftItemStackList.isEmpty()) {
                baseXOffset = res.func_78326_a() / 2 - 91 - 20;
                yOffset2 = res.func_78328_b() - 16 * i - 40;
                HUDInfo.renderItem(itemStack, baseXOffset, yOffset2);
            }
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < rightItemStackList.size(); ++i) {
            itemStack = (ItemStack)rightItemStackList.get(i);
            mc.field_71424_I.func_76320_a("item_stack_render");
            if (!rightItemStackList.isEmpty()) {
                baseXOffset = res.func_78326_a() / 2 + 95;
                yOffset2 = res.func_78328_b() - 16 * i - 40;
                HUDInfo.renderItem(itemStack, baseXOffset, yOffset2);
            }
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < leftItemStatusList.size(); ++i) {
            string = (String)leftItemStatusList.get(i);
            mc.field_71424_I.func_76320_a("armor_durability_info");
            int stringWidth = mc.field_71466_p.func_78256_a(string);
            float xOffset = res.func_78326_a() / 2 - 114 - stringWidth;
            yOffset = res.func_78328_b() - 16 * i - 36;
            IndicatiaMod.coloredFontRenderer.func_175065_a(ColoredFontRenderer.color(ExtendedConfig.EQUIPMENT_COLOR_R, ExtendedConfig.EQUIPMENT_COLOR_G, ExtendedConfig.EQUIPMENT_COLOR_B) + string, xOffset, yOffset, 0xFFFFFF, true);
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < rightItemStatusList.size(); ++i) {
            string = (String)rightItemStatusList.get(i);
            mc.field_71424_I.func_76320_a("armor_durability_info");
            float xOffset = res.func_78326_a() / 2 + 114;
            int yOffset3 = res.func_78328_b() - 16 * i - 36;
            IndicatiaMod.coloredFontRenderer.func_175065_a(ColoredFontRenderer.color(ExtendedConfig.EQUIPMENT_COLOR_R, ExtendedConfig.EQUIPMENT_COLOR_G, ExtendedConfig.EQUIPMENT_COLOR_B) + string, xOffset, yOffset3, 0xFFFFFF, true);
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < leftArrowCountList.size(); ++i) {
            string = (String)leftArrowCountList.get(i);
            int stringWidth = mc.field_71466_p.func_78256_a(string);
            float xOffset = res.func_78326_a() / 2 - 90 - stringWidth;
            yOffset = res.func_78328_b() - 16 * i - 32;
            if (string.isEmpty()) continue;
            mc.field_71424_I.func_76320_a("arrow_count");
            GlStateManager.func_179097_i();
            IndicatiaMod.coloredFontRenderer.func_78264_a(true);
            IndicatiaMod.coloredFontRenderer.func_175065_a(ColoredFontRenderer.color(ExtendedConfig.ARROW_COUNT_COLOR_R, ExtendedConfig.ARROW_COUNT_COLOR_G, ExtendedConfig.ARROW_COUNT_COLOR_B) + string, xOffset, yOffset, 0xFFFFFF, true);
            IndicatiaMod.coloredFontRenderer.func_78264_a(false);
            GlStateManager.func_179126_j();
            mc.field_71424_I.func_76319_b();
        }
        for (i = 0; i < rightArrowCountList.size(); ++i) {
            string = (String)rightArrowCountList.get(i);
            float xOffset = res.func_78326_a() / 2 + 104;
            int yOffset4 = res.func_78328_b() - 16 * i - 32;
            if (string.isEmpty()) continue;
            mc.field_71424_I.func_76320_a("arrow_count");
            GlStateManager.func_179097_i();
            IndicatiaMod.coloredFontRenderer.func_78264_a(true);
            IndicatiaMod.coloredFontRenderer.func_175065_a(ColoredFontRenderer.color(ExtendedConfig.ARROW_COUNT_COLOR_R, ExtendedConfig.ARROW_COUNT_COLOR_G, ExtendedConfig.ARROW_COUNT_COLOR_B) + string, xOffset, yOffset4, 0xFFFFFF, true);
            IndicatiaMod.coloredFontRenderer.func_78264_a(false);
            GlStateManager.func_179126_j();
            mc.field_71424_I.func_76319_b();
        }
    }

    public static void renderPotionStatusHUD(Minecraft mc) {
        block28: {
            Collection collection;
            int lengthOverlap;
            int length;
            int size;
            ScaledResolution scaledRes;
            boolean showIcon;
            boolean iconAndTime;
            block30: {
                block29: {
                    if (!ConfigManager.enablePotionStatusHUD) break block28;
                    GlStateManager.func_179147_l();
                    iconAndTime = ConfigManager.potionStatusHUDStyle.equals("icon_and_time");
                    showIcon = ConfigManager.enablePotionHUDIcon;
                    scaledRes = new ScaledResolution(mc);
                    size = ExtendedConfig.MAX_POTION_DISPLAY;
                    length = ExtendedConfig.POTION_LENGTH_Y_OFFSET;
                    lengthOverlap = ExtendedConfig.POTION_LENGTH_Y_OFFSET_OVERLAP;
                    collection = mc.field_71439_g.func_70651_bq();
                    if (!ConfigManager.potionStatusHUDPosition.equals("hotbar_left")) break block29;
                    int xPotion = scaledRes.func_78326_a() / 2 - 91 - 35;
                    int yPotion = scaledRes.func_78328_b() - 46;
                    if (collection.isEmpty()) break block28;
                    if (collection.size() > size) {
                        length = lengthOverlap / (collection.size() - 1);
                    }
                    for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                        Potion potion = potioneffect.func_188419_a();
                        String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                        String s1 = LangUtil.translate(potion.func_76393_a());
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (showIcon) {
                            mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                            int i1 = potion.func_76392_e();
                            mc.field_71456_v.func_73729_b(xPotion + 12, yPotion + 6, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                        }
                        if (potioneffect.func_76458_c() == 1) {
                            s1 = s1 + " " + LangUtil.translate("enchantment.level.2");
                        } else if (potioneffect.func_76458_c() == 2) {
                            s1 = s1 + " " + LangUtil.translate("enchantment.level.3");
                        } else if (potioneffect.func_76458_c() == 3) {
                            s1 = s1 + " " + LangUtil.translate("enchantment.level.4");
                        }
                        int stringwidth1 = IndicatiaMod.coloredFontRenderer.func_78256_a(s);
                        int stringwidth2 = IndicatiaMod.coloredFontRenderer.func_78256_a(s1);
                        if (!iconAndTime) {
                            IndicatiaMod.coloredFontRenderer.func_175065_a(s1, showIcon ? (float)(xPotion + 8 - stringwidth2) : (float)(xPotion + 28 - stringwidth2), yPotion + 6, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                        }
                        IndicatiaMod.coloredFontRenderer.func_175065_a(s, showIcon ? (float)(xPotion + 8 - stringwidth1) : (float)(xPotion + 28 - stringwidth1), iconAndTime ? (float)(yPotion + 11) : (float)(yPotion + 16), ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                        yPotion -= length;
                    }
                    break block28;
                }
                if (!ConfigManager.potionStatusHUDPosition.equals("hotbar_right")) break block30;
                int xPotion = scaledRes.func_78326_a() / 2 + 91 - 20;
                int yPotion = scaledRes.func_78328_b() - 42;
                if (collection.isEmpty()) break block28;
                if (collection.size() > size) {
                    length = lengthOverlap / (collection.size() - 1);
                }
                for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                    Potion potion = potioneffect.func_188419_a();
                    String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                    String s1 = LangUtil.translate(potion.func_76393_a());
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (showIcon) {
                        mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                        int i1 = potion.func_76392_e();
                        mc.field_71456_v.func_73729_b(xPotion + 24, yPotion + 6, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                    }
                    if (potioneffect.func_76458_c() == 1) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.2");
                    } else if (potioneffect.func_76458_c() == 2) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.3");
                    } else if (potioneffect.func_76458_c() == 3) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.4");
                    }
                    if (!iconAndTime) {
                        IndicatiaMod.coloredFontRenderer.func_175065_a(s1, showIcon ? (float)(xPotion + 46) : (float)(xPotion + 28), yPotion + 6, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    }
                    IndicatiaMod.coloredFontRenderer.func_175065_a(s, showIcon ? (float)(xPotion + 46) : (float)(xPotion + 28), iconAndTime ? (float)(yPotion + 11) : (float)(yPotion + 16), ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    yPotion -= length;
                }
                break block28;
            }
            boolean right = ConfigManager.potionStatusHUDPosition.equals("right");
            int xPotion = right ? scaledRes.func_78326_a() - 32 : -24;
            int yPotion = scaledRes.func_78328_b() - 220 + ExtendedConfig.POTION_STATUS_OFFSET + 90;
            if (!collection.isEmpty()) {
                if (collection.size() > size) {
                    length = lengthOverlap / (collection.size() - 1);
                }
                for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                    Potion potion = potioneffect.func_188419_a();
                    String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                    String s1 = LangUtil.translate(potion.func_76393_a());
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (showIcon) {
                        mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                        int i1 = potion.func_76392_e();
                        mc.field_71456_v.func_73729_b(right ? xPotion + 12 : xPotion + 28, yPotion + 6, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                    }
                    if (potioneffect.func_76458_c() == 1) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.2");
                    } else if (potioneffect.func_76458_c() == 2) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.3");
                    } else if (potioneffect.func_76458_c() == 3) {
                        s1 = s1 + " " + LangUtil.translate("enchantment.level.4");
                    }
                    int stringwidth1 = IndicatiaMod.coloredFontRenderer.func_78256_a(s);
                    int stringwidth2 = IndicatiaMod.coloredFontRenderer.func_78256_a(s1);
                    if (!iconAndTime) {
                        IndicatiaMod.coloredFontRenderer.func_175065_a(s1, right ? (showIcon ? (float)(xPotion + 8 - stringwidth2) : (float)(xPotion + 28 - stringwidth2)) : (showIcon ? (float)(xPotion + 50) : (float)(xPotion + 28)), yPotion + 6, ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    }
                    IndicatiaMod.coloredFontRenderer.func_175065_a(s, right ? (showIcon ? (float)(xPotion + 8 - stringwidth1) : (float)(xPotion + 28 - stringwidth1)) : (showIcon ? (float)(xPotion + 50) : (float)(xPotion + 28)), iconAndTime ? (float)(yPotion + 11) : (float)(yPotion + 16), ConfigManager.alternatePotionHUDTextColor ? InfoUtil.INSTANCE.getAlternatePotionHUDTextColor(potion) : 0xFFFFFF, true);
                    yPotion += length;
                }
            }
        }
    }

    static String getArmorDurabilityStatus(ItemStack itemStack) {
        String status;
        switch (status = ConfigManager.equipmentStatus) {
            default: {
                return itemStack.func_77958_k() - itemStack.func_77952_i() + "/" + itemStack.func_77958_k();
            }
            case "percent": {
                return HUDInfo.calculateItemDurabilityPercent(itemStack) + "%";
            }
            case "damage": {
                return String.valueOf(itemStack.func_77958_k() - itemStack.func_77952_i());
            }
            case "none": 
        }
        return "";
    }

    private static int calculateItemDurabilityPercent(ItemStack itemStack) {
        return itemStack.func_77958_k() <= 0 ? 0 : 100 - itemStack.func_77952_i() * 100 / itemStack.func_77958_k();
    }

    private static String getResponseTimeColor(int responseTime) {
        if (responseTime >= 200 && responseTime < 300) {
            return ColoredFontRenderer.color(ExtendedConfig.PING_200_300_COLOR_R, ExtendedConfig.PING_200_300_COLOR_G, ExtendedConfig.PING_200_300_COLOR_B);
        }
        if (responseTime >= 300 && responseTime < 500) {
            return ColoredFontRenderer.color(ExtendedConfig.PING_300_500_COLOR_R, ExtendedConfig.PING_300_500_COLOR_G, ExtendedConfig.PING_300_500_COLOR_B);
        }
        if (responseTime >= 500) {
            return ColoredFontRenderer.color(ExtendedConfig.PING_M500_COLOR_R, ExtendedConfig.PING_M500_COLOR_G, ExtendedConfig.PING_M500_COLOR_B);
        }
        return ColoredFontRenderer.color(ExtendedConfig.PING_L200_COLOR_R, ExtendedConfig.PING_L200_COLOR_G, ExtendedConfig.PING_L200_COLOR_B);
    }

    static void renderItem(ItemStack itemStack, int x, int y) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        IndicatiaMod.MC.func_175599_af().func_180450_b(itemStack, x, y);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
        if (itemStack.func_77984_f()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179140_f();
            GlStateManager.func_179089_o();
            IndicatiaMod.MC.func_175599_af().func_175030_a((FontRenderer)IndicatiaMod.coloredFontRenderer, itemStack, x, y);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
        }
    }

    static String getInventoryItemCount(InventoryPlayer inventory, ItemStack other) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack playerItems = inventory.func_70301_a(i);
            if (playerItems == null || playerItems.func_77973_b() != other.func_77973_b() || playerItems.func_77952_i() != other.func_77952_i() || !ItemStack.func_77970_a((ItemStack)playerItems, (ItemStack)other)) continue;
            count += playerItems.field_77994_a;
        }
        return String.valueOf(count);
    }

    static int getInventoryArrowCount(InventoryPlayer inventory) {
        int arrowCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemArrow)) continue;
            arrowCount += itemStack.field_77994_a;
        }
        return arrowCount;
    }

    static String getItemStackCount(ItemStack itemStack, int count) {
        return count == 0 || count == 1 || count == 1 && itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("Unbreakable") ? "" : String.valueOf(count);
    }

    static String getArrowStackCount(int count) {
        return count == 0 ? "" : String.valueOf(count);
    }
}

