/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import stevekung.mods.indicatia.command.ClientCommandBase;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.util.GameProfileUtil;
import stevekung.mods.indicatia.util.JsonUtil;

public class CommandEntityDetector
extends ClientCommandBase {
    public String func_71517_b() {
        return "entitydetect";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        JsonUtil json = IndicatiaMod.json;
        if (args.length < 1) {
            throw new WrongUsageException("commands.entitydetect.usage", new Object[0]);
        }
        if ("entity".equalsIgnoreCase(args[0])) {
            if (args.length == 1) {
                throw new WrongUsageException("commands.entitydetect.entity.usage", new Object[0]);
            }
            String input = args[1];
            sender.func_145747_a((ITextComponent)json.text("Detecting entity: " + input));
            ExtendedConfig.ENTITY_DETECT_TYPE = input;
            ExtendedConfig.save();
        } else if ("player".equalsIgnoreCase(args[0])) {
            if (args.length == 1) {
                throw new WrongUsageException("commands.entitydetect.player.usage", new Object[0]);
            }
            String input = args[1];
            if (GameProfileUtil.getUsername().equalsIgnoreCase(input)) {
                sender.func_145747_a(json.text("Cannot set entity detector type to yourself!").func_150255_a(json.red()));
                return;
            }
            sender.func_145747_a((ITextComponent)json.text("Detecting player name: " + input));
            ExtendedConfig.ENTITY_DETECT_TYPE = input;
            ExtendedConfig.save();
        } else if ("all".equalsIgnoreCase(args[0]) || "only_mob".equalsIgnoreCase(args[0]) || "only_creature".equalsIgnoreCase(args[0]) || "only_non_mob".equalsIgnoreCase(args[0]) || "only_player".equalsIgnoreCase(args[0]) || "only_mob".equalsIgnoreCase(args[0])) {
            sender.func_145747_a((ITextComponent)json.text(args[0].equalsIgnoreCase("all") ? "Set detect to all" : "Set detecting only: " + args[0]));
            ExtendedConfig.ENTITY_DETECT_TYPE = args[0];
            ExtendedConfig.save();
        } else if ("reset".equalsIgnoreCase(args[0])) {
            sender.func_145747_a((ITextComponent)json.text("Reset entity detector"));
            ExtendedConfig.ENTITY_DETECT_TYPE = "";
            ExtendedConfig.save();
        } else {
            throw new WrongUsageException("commands.entitydetect.usage", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        NetHandlerPlayClient connection = IndicatiaMod.MC.field_71439_g.field_71174_a;
        ArrayList playerInfo = new ArrayList(connection.func_175106_d());
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"entity", "player", "all", "only_mob", "only_creature", "only_non_mob", "only_player", "reset"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("entity")) {
                return CommandBase.func_175762_a((String[])args, (Collection)EntityList.func_180124_b());
            }
            if (args[0].equalsIgnoreCase("player")) {
                ArrayList<String> playerList = new ArrayList<String>();
                for (int i = 0; i < playerInfo.size(); ++i) {
                    if (i >= playerInfo.size()) continue;
                    playerList.add(((NetworkPlayerInfo)playerInfo.get(i)).func_178845_a().getName().replace(GameProfileUtil.getUsername(), ""));
                }
                return CommandBase.func_175762_a((String[])args, playerList);
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

