/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import stevekung.mods.indicatia.util.LangUtil;

public class ConfigManager {
    private static Configuration config;
    public static final String MAIN_SETTINGS = "indicatia_main_settings";
    public static final String RENDER_SETTINGS = "indicatia_render_settings";
    public static final String DONATION_SETTINGS = "indicatia_donation_settings";
    public static int afkMessageTime;
    public static int endGameTitleTime;
    public static String endGameTitleMessage;
    public static String endGameMessage;
    public static String confirmDisconnectMode;
    public static boolean enableRenderInfo;
    public static boolean enableBlockhitAnimation;
    public static boolean enableAdditionalBlockhitAnimation;
    public static boolean enableFishingRodOldRender;
    public static boolean enableOldArmorRender;
    public static boolean enableVersionChecker;
    public static boolean enableAnnounceMessage;
    public static boolean enableAFKMessage;
    public static boolean enableFastChatRender;
    public static boolean enableCustomPlayerList;
    public static boolean enableCustomServerSelectionGui;
    public static boolean enableConfirmDisconnectButton;
    public static boolean enableChatDepthRender;
    public static boolean enableIngamePotionHUD;
    public static boolean enableRenderBossHealthBar;
    public static boolean enableRenderBossHealthStatus;
    public static boolean enableRenderScoreboard;
    public static boolean enableSmoothEyeHeight;
    public static boolean enableCustomMovementHandler;
    public static boolean enableCustomCape;
    public static boolean swapRenderInfoToRight;
    public static boolean enableFPS;
    public static boolean enableXYZ;
    public static boolean enableDirection;
    public static boolean enableBiome;
    public static boolean enablePing;
    public static boolean enablePingToSecond;
    public static boolean enableServerIP;
    public static boolean enableServerIPMCVersion;
    public static boolean enableRenderEquippedItem;
    public static boolean enablePotionStatusHUD;
    public static boolean enableKeystroke;
    public static boolean enableKeystrokeLMBRMB;
    public static boolean enableKeystrokeSprintSneak;
    public static boolean enableKeystrokeBlocking;
    public static boolean enableCPS;
    public static boolean enableRCPS;
    public static boolean enableSlimeChunkFinder;
    public static boolean enableCurrentRealTime;
    public static boolean enableCurrentGameTime;
    public static boolean enableGameWeather;
    public static boolean enableMoonPhase;
    public static boolean enablePotionHUDIcon;
    public static boolean alternatePotionHUDTextColor;
    public static boolean enableServerTPS;
    public static String healthStatusMode;
    public static String keystrokePosition;
    public static String equipmentOrdering;
    public static String equipmentDirection;
    public static String equipmentStatus;
    public static String equipmentPosition;
    public static String potionStatusHUDStyle;
    public static String potionStatusHUDPosition;
    public static String donatorMessagePosition;
    public static int readFileInterval;

    public static void init(File file) {
        config = new Configuration(file);
        ConfigManager.syncConfig(true);
    }

    public static void syncConfig(boolean load) {
        if (!ConfigManager.config.isChild && load) {
            config.load();
        }
        config.setCategoryPropertyOrder(MAIN_SETTINGS, ConfigManager.addMainSetting());
        config.setCategoryPropertyOrder(RENDER_SETTINGS, ConfigManager.addRenderSetting());
        config.setCategoryPropertyOrder(DONATION_SETTINGS, ConfigManager.addDonationSetting());
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static List<String> addMainSetting() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Render Info", true);
        enableRenderInfo = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "AFK Message Time (minute)", 5);
        prop.setMinValue(1).setMaxValue(60).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        afkMessageTime = prop.getInt();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "End Game Message Time (game tick)", 20);
        prop.setMinValue(20).setMaxValue(100).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        endGameTitleTime = prop.getInt();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Confirm Disconnect Mode", "gui");
        prop.setValidValues(new String[]{"gui", "click_again"});
        confirmDisconnectMode = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "End Game Title Message", "you lose,you win,game end,victory");
        endGameTitleMessage = prop.getString().toLowerCase();
        prop.setComment(LangUtil.translate("gui.config.indicatia.end_game_title_message"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "End Game Message", "");
        endGameMessage = prop.getString();
        prop.setComment(LangUtil.translate("gui.config.indicatia.end_game_message"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Blockhit Animation", false);
        enableBlockhitAnimation = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.blockhit_animation"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Additional Blockhit Animation", false);
        enableAdditionalBlockhitAnimation = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.additional_blockhit_animation"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Fishing Rod Old Render", false);
        enableFishingRodOldRender = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.old_fish_render"));
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Old Armor Render", false);
        enableOldArmorRender = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.old_armor_render"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Fast Chat Render", false);
        enableFastChatRender = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.fast_chat"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Custom Player List", false);
        enableCustomPlayerList = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.custom_player_list"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Custom Server Selection GUI", false);
        enableCustomServerSelectionGui = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.custom_server_selection"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Confirm Disconnect Button", false);
        enableConfirmDisconnectButton = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.confirm_disconnect_button"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Chat Depth Render", true);
        enableChatDepthRender = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.chat_depth_render"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Ingame Potion HUD", true);
        enableIngamePotionHUD = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.potion_hud"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Boss Health Bar", true);
        enableRenderBossHealthBar = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Boss Health Status", true);
        enableRenderBossHealthStatus = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Scoreboard Sidebar Render", true);
        enableRenderScoreboard = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable AFK Message", true);
        enableAFKMessage = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Smooth Eye Height", false);
        enableSmoothEyeHeight = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.smooth_eye_height"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Custom Movement Handler", true);
        enableCustomMovementHandler = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.custom_movement_handler"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Custom Cape", false);
        enableCustomCape = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.custom_cape"));
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Version Checker", true);
        enableVersionChecker = prop.getBoolean();
        prop.setRequiresMcRestart(true);
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Enable Announce Message", true);
        enableAnnounceMessage = prop.getBoolean();
        propOrder.add(prop.getName());
        return propOrder;
    }

    private static List<String> addRenderSetting() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = ConfigManager.getProperty(RENDER_SETTINGS, "Swap Render Info to Right", false);
        swapRenderInfoToRight = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Health Status Mode", "disable");
        prop.setValidValues(new String[]{"disable", "always", "pointed"});
        healthStatusMode = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Keystroke Position", "right");
        prop.setValidValues(new String[]{"right", "left"});
        keystrokePosition = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Equipment Ordering", "default");
        prop.setValidValues(new String[]{"default", "reverse"});
        equipmentOrdering = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Equipment Direction", "vertical");
        prop.setValidValues(new String[]{"vertical", "horizontal"});
        equipmentDirection = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Equipment Status", "damage/max_damage");
        prop.setValidValues(new String[]{"damage/max_damage", "percent", "damage", "none"});
        equipmentStatus = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Equipment Position", "left");
        prop.setValidValues(new String[]{"left", "right", "hotbar"});
        equipmentPosition = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Potion Status HUD Style", "default");
        prop.setValidValues(new String[]{"default", "icon_and_time"});
        potionStatusHUDStyle = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Potion Status HUD Position", "left");
        prop.setValidValues(new String[]{"left", "right", "hotbar_left", "hotbar_right"});
        potionStatusHUDPosition = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable FPS", true);
        enableFPS = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable XYZ", true);
        enableXYZ = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Direction", true);
        enableDirection = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Biome", true);
        enableBiome = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Ping", true);
        enablePing = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Ping to Second", false);
        enablePingToSecond = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Server IP", true);
        enableServerIP = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Server IP with Minecraft Version", false);
        enableServerIPMCVersion = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Render Equipped Item", true);
        enableRenderEquippedItem = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Potion Status HUD", false);
        enablePotionStatusHUD = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Keystroke", false);
        enableKeystroke = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable LMB/RMB on Keystroke", false);
        enableKeystrokeLMBRMB = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Sprint/Sneak on Keystroke", false);
        enableKeystrokeSprintSneak = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Blocking on Keystroke", false);
        enableKeystrokeBlocking = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable CPS", false);
        enableCPS = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable RCPS", false);
        enableRCPS = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Slime Chunk Finder", false);
        enableSlimeChunkFinder = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Current Real Time", true);
        enableCurrentRealTime = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Current Game Time", true);
        enableCurrentGameTime = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Game Weather", true);
        enableGameWeather = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Moon Phase", false);
        enableMoonPhase = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Potion HUD Icon", false);
        enablePotionHUDIcon = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(MAIN_SETTINGS, "Alternate Potion HUD Text Color", false);
        alternatePotionHUDTextColor = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(RENDER_SETTINGS, "Enable Server TPS", false);
        enableServerTPS = prop.getBoolean();
        prop.setComment(LangUtil.translate("gui.config.indicatia.server_tps"));
        propOrder.add(prop.getName());
        return propOrder;
    }

    private static List<String> addDonationSetting() {
        ArrayList<String> propOrder = new ArrayList<String>();
        Property prop = ConfigManager.getProperty(DONATION_SETTINGS, "Donator Message Position", "right");
        prop.setValidValues(new String[]{"left", "right"});
        donatorMessagePosition = prop.getString();
        propOrder.add(prop.getName());
        prop = ConfigManager.getProperty(DONATION_SETTINGS, "Read File Interval", 200);
        prop.setMinValue(200).setMaxValue(1200).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        readFileInterval = prop.getInt();
        propOrder.add(prop.getName());
        return propOrder;
    }

    public static Property getProperty(String category, String name, boolean defaultValue) {
        return config.get(category, name, defaultValue);
    }

    public static Property getProperty(String category, String name, String defaultValue) {
        return config.get(category, name, defaultValue);
    }

    private static Property getProperty(String category, String name, int defaultValue) {
        return config.get(category, name, defaultValue);
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new ConfigElement(config.getCategory(MAIN_SETTINGS)));
        list.add((IConfigElement)new ConfigElement(config.getCategory(RENDER_SETTINGS)));
        list.add((IConfigElement)new ConfigElement(config.getCategory(DONATION_SETTINGS)));
        return list;
    }

    public static Configuration getConfig() {
        return config;
    }
}

