/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.core;

import java.io.File;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import stevekung.mods.indicatia.command.CommandAFK;
import stevekung.mods.indicatia.command.CommandAutoClick;
import stevekung.mods.indicatia.command.CommandAutoLogin;
import stevekung.mods.indicatia.command.CommandChangeLog;
import stevekung.mods.indicatia.command.CommandEntityDetector;
import stevekung.mods.indicatia.command.CommandHideName;
import stevekung.mods.indicatia.command.CommandIndicatia;
import stevekung.mods.indicatia.command.CommandMojangStatusCheck;
import stevekung.mods.indicatia.command.CommandProfile;
import stevekung.mods.indicatia.command.CommandSlimeChunkSeed;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.handler.BlockhitAnimationHandler;
import stevekung.mods.indicatia.handler.CommonHandler;
import stevekung.mods.indicatia.handler.HUDRenderHandler;
import stevekung.mods.indicatia.handler.KeyBindingHandler;
import stevekung.mods.indicatia.handler.PlayerChatHandler;
import stevekung.mods.indicatia.profile.RenderProfileConfig;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.RenderFishNew;
import stevekung.mods.indicatia.util.CapeUtil;
import stevekung.mods.indicatia.util.GameProfileUtil;
import stevekung.mods.indicatia.util.JsonUtil;
import stevekung.mods.indicatia.util.ModLogger;
import stevekung.mods.indicatia.util.VersionChecker;

@Mod(modid="indicatia", name="Indicatia", version="1.1.9", dependencies="after:forge@[13.20.1.2476,);", clientSideOnly=true, guiFactory="stevekung.mods.indicatia.config.ConfigGuiFactory", certificateFingerprint="b3468b224a74e296555ad7efeb35f482e6f445de", acceptedMinecraftVersions="[1.11.2]")
public class IndicatiaMod {
    public static final String NAME = "Indicatia";
    public static final String MOD_ID = "indicatia";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    public static final int BUILD_VERSION = 9;
    public static final String VERSION = "1.1.9";
    public static final String MC_VERSION = String.valueOf(FMLInjectionData.data()[4]);
    public static final String GUI_FACTORY = "stevekung.mods.indicatia.config.ConfigGuiFactory";
    public static final String FORGE_VERSION = "after:forge@[13.20.1.2476,);";
    public static final String URL = "https://minecraft.curseforge.com/projects/indicatia";
    public static final String CERTIFICATE = "b3468b224a74e296555ad7efeb35f482e6f445de";
    private static boolean DEOBFUSCATED;
    public static Minecraft MC;
    public static boolean CHECK_NO_CONNECTION;
    public static boolean SHOW_ANNOUNCE_MESSAGE;
    public static boolean FOUND_LATEST;
    public static ColoredFontRenderer coloredFontRenderer;
    public static JsonUtil json;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IndicatiaMod.init(event.getModMetadata());
        ConfigManager.init(new File(event.getModConfigurationDirectory(), "indicatia.cfg"));
        KeyBindingHandler.init();
        ExtendedConfig.load();
        RenderProfileConfig.load();
        MinecraftForge.EVENT_BUS.register((Object)new HUDRenderHandler(MC));
        MinecraftForge.EVENT_BUS.register((Object)new CommonHandler(MC));
        MinecraftForge.EVENT_BUS.register((Object)new BlockhitAnimationHandler(MC));
        MinecraftForge.EVENT_BUS.register((Object)new PlayerChatHandler(MC));
        if (ConfigManager.enableFishingRodOldRender) {
            ModelLoader.setCustomModelResourceLocation((Item)Items.field_151112_aM, (int)0, (ModelResourceLocation)new ModelResourceLocation("indicatia:fishing_rod", "inventory"));
            ModLogger.info("Successfully replacing vanilla Fishing Rod item model");
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandMojangStatusCheck());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandChangeLog());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutoLogin());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSlimeChunkSeed());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAFK());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandIndicatia());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandProfile());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandHideName());
        if (IndicatiaMod.isSteveKunG()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandEntityDetector());
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutoClick());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (ConfigManager.enableFishingRodOldRender) {
            IndicatiaMod.MC.func_175598_ae().field_78729_o.entrySet().removeIf(entry -> ((Class)entry.getKey()).equals(EntityFishHook.class));
            IndicatiaMod.MC.func_175598_ae().field_78729_o.put(EntityFishHook.class, new RenderFishNew(MC.func_175598_ae()));
            ModLogger.info("Successfully replacing {}", EntityFishHook.class.getName());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ConfigManager.enableVersionChecker) {
            VersionChecker.startCheck();
        }
        CapeUtil.loadCapeTextureAtStartup();
        coloredFontRenderer = new ColoredFontRenderer(IndicatiaMod.MC.field_71474_y, new ResourceLocation("textures/font/ascii.png"), IndicatiaMod.MC.field_71446_o, false);
        ((IReloadableResourceManager)MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)coloredFontRenderer);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!IndicatiaMod.isObfuscatedEnvironment()) {
            throw new RuntimeException("Invalid fingerprint detected! This version will NOT be supported by the author!");
        }
        ModLogger.info("Development environment detected! Ignore certificate check.");
    }

    public static boolean isObfuscatedEnvironment() {
        return DEOBFUSCATED;
    }

    public static boolean isSteveKunG() {
        return GameProfileUtil.getUsername().equals("SteveKunG") && GameProfileUtil.getUUID().equals(UUID.fromString("eef3a603-1c1b-4c98-8264-d2f04b231ef4")) || IndicatiaMod.isObfuscatedEnvironment();
    }

    private static void init(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.description = "Simple in-game info and utility!";
        info.url = URL;
        info.authorList = Arrays.asList("SteveKunG");
    }

    static {
        try {
            DEOBFUSCATED = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MC = Minecraft.func_71410_x();
        json = new JsonUtil();
    }
}

